/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import org.gradle.api.internal.initialization.AbstractClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootClassLoaderScope
extends AbstractClassLoaderScope {
    private final ClassLoader localClassLoader;
    private final ClassLoader exportClassLoader;

    public RootClassLoaderScope(ClassLoader localClassLoader, ClassLoader exportClassLoader, ClassLoaderCache classLoaderCache) {
        super(new ClassLoaderScopeIdentifier(null, "root"), classLoaderCache);
        this.localClassLoader = localClassLoader;
        this.exportClassLoader = exportClassLoader;
    }

    @Override
    public ClassLoader getLocalClassLoader() {
        return this.localClassLoader;
    }

    @Override
    public ClassLoader getExportClassLoader() {
        return this.exportClassLoader;
    }

    @Override
    public ClassLoaderScope getParent() {
        return this;
    }

    @Override
    public boolean defines(Class<?> clazz) {
        return this.localClassLoader.equals(clazz.getClassLoader()) || this.exportClassLoader.equals(clazz.getClassLoader());
    }

    @Override
    public ClassLoaderScope local(ClassPath classPath) {
        throw new UnsupportedOperationException("root class loader scope is immutable");
    }

    @Override
    public ClassLoaderScope export(ClassPath classPath) {
        throw new UnsupportedOperationException("root class loader scope is immutable");
    }

    @Override
    public ClassLoaderScope export(ClassLoader classLoader) {
        throw new UnsupportedOperationException("root class loader scope is immutable");
    }

    @Override
    public ClassLoaderScope lock() {
        return this;
    }

    @Override
    public boolean isLocked() {
        return true;
    }
}

