/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij;

import java.lang.ref.Reference;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.kotlin.com.intellij.BundleBase;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;

public class CommonBundle
extends BundleBase {
    private static Reference<ResourceBundle> ourBundle;

    public static String message(@NotNull @PropertyKey(resourceBundle="messages.CommonBundle") String key, Object ... params) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/CommonBundle", "message"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/com/intellij/CommonBundle", "message"));
        }
        return CommonBundle.message(CommonBundle.getCommonBundle(), key, params);
    }

    @NotNull
    private static ResourceBundle getCommonBundle() {
        ResourceBundle bundle = SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("messages.CommonBundle");
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/CommonBundle", "getCommonBundle"));
        }
        return resourceBundle;
    }

    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/CommonBundle", "messageOrDefault"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/com/intellij/CommonBundle", "messageOrDefault"));
        }
        return BundleBase.messageOrDefault(bundle, key, defaultValue, params);
    }

    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "org/jetbrains/kotlin/com/intellij/CommonBundle", "message"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/CommonBundle", "message"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/com/intellij/CommonBundle", "message"));
        }
        String string = BundleBase.message(bundle, key, params);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/CommonBundle", "message"));
        }
        return string;
    }
}

