/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.injected.editor.DocumentWindow;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.DocumentEx;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.IgnorePsiEventsMarker;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiTreeChangeAdapter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTreeChangeEvent;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentTransactionListener;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiFileEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.ImmutableCharSequence;

public class PsiToDocumentSynchronizer
extends PsiTreeChangeAdapter {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiToDocumentSynchronizer");
    private static final Key<Boolean> PSI_DOCUMENT_ATOMIC_ACTION = Key.create("PSI_DOCUMENT_ATOMIC_ACTION");
    private final PsiDocumentManagerBase myPsiDocumentManager;
    private final MessageBus myBus;
    private final Map<Document, Pair<DocumentChangeTransaction, Integer>> myTransactionsMap = new HashMap<Document, Pair<DocumentChangeTransaction, Integer>>();
    private volatile Document mySyncDocument;
    private boolean myIgnorePsiEvents;

    PsiToDocumentSynchronizer(PsiDocumentManagerBase psiDocumentManager, MessageBus bus) {
        this.myPsiDocumentManager = psiDocumentManager;
        this.myBus = bus;
    }

    @Nullable
    public DocumentChangeTransaction getTransaction(Document document) {
        Pair<DocumentChangeTransaction, Integer> pair = this.myTransactionsMap.get(document);
        return pair != null ? pair.getFirst() : null;
    }

    public boolean isInSynchronization(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "isInSynchronization"));
        }
        return this.mySyncDocument == document;
    }

    void cleanupForNextTest() {
        this.myTransactionsMap.clear();
        this.mySyncDocument = null;
    }

    private void checkPsiModificationAllowed(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "checkPsiModificationAllowed"));
        }
        if (!this.toProcessPsiEvent()) {
            return;
        }
        PsiFile psiFile = event.getFile();
        if (!(psiFile instanceof PsiFileEx) || !((PsiFileEx)psiFile).isContentsLoaded()) {
            return;
        }
        Document document = this.myPsiDocumentManager.getCachedDocument(psiFile);
        if (document != null && this.myPsiDocumentManager.isUncommited(document)) {
            throw new IllegalStateException("Attempt to modify PSI for non-committed Document!");
        }
    }

    private DocumentEx getCachedDocument(PsiFile psiFile, boolean force) {
        DocumentEx document = (DocumentEx)this.myPsiDocumentManager.getCachedDocument(psiFile);
        if (document == null || document instanceof DocumentWindow || !force && this.getTransaction(document) == null) {
            return null;
        }
        return document;
    }

    private void doSync(@NotNull PsiTreeChangeEvent event, boolean force, @NotNull DocSyncAction syncAction) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "doSync"));
        }
        if (syncAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncAction", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "doSync"));
        }
        if (!this.toProcessPsiEvent()) {
            return;
        }
        PsiFile psiFile = event.getFile();
        if (!(psiFile instanceof PsiFileEx) || !((PsiFileEx)psiFile).isContentsLoaded()) {
            return;
        }
        DocumentEx document = this.getCachedDocument(psiFile, force);
        if (document == null) {
            return;
        }
        PsiToDocumentSynchronizer.performAtomically(psiFile, () -> {
            if (syncAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncAction", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "lambda$doSync$0"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "lambda$doSync$0"));
            }
            syncAction.syncDocument(document, (PsiTreeChangeEventImpl)event);
        });
        boolean insideTransaction = this.myTransactionsMap.containsKey(document);
        if (!insideTransaction) {
            document.setModificationStamp(psiFile.getViewProvider().getModificationStamp());
        }
    }

    static boolean isInsideAtomicChange(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "isInsideAtomicChange"));
        }
        return file.getUserData(PSI_DOCUMENT_ATOMIC_ACTION) == Boolean.TRUE;
    }

    static void performAtomically(@NotNull PsiFile file, @NotNull Runnable runnable) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "performAtomically"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "performAtomically"));
        }
        PsiUtilCore.ensureValid(file);
        assert (!PsiToDocumentSynchronizer.isInsideAtomicChange(file));
        file.putUserData(PSI_DOCUMENT_ATOMIC_ACTION, Boolean.TRUE);
        try {
            runnable.run();
        }
        finally {
            file.putUserData(PSI_DOCUMENT_ATOMIC_ACTION, null);
        }
    }

    @Override
    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "beforeChildAddition"));
        }
        this.checkPsiModificationAllowed(event);
    }

    @Override
    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "beforeChildRemoval"));
        }
        this.checkPsiModificationAllowed(event);
    }

    @Override
    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "beforeChildReplacement"));
        }
        this.checkPsiModificationAllowed(event);
    }

    @Override
    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "beforeChildrenChange"));
        }
        this.checkPsiModificationAllowed(event);
    }

    @Override
    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "childAdded"));
        }
        if (!(event.getChild() instanceof ForeignLeafPsiElement)) {
            this.doSync(event, false, new DocSyncAction(){

                @Override
                public void syncDocument(@NotNull Document document, @NotNull PsiTreeChangeEventImpl event) {
                    if (document == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$1", "syncDocument"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$1", "syncDocument"));
                    }
                    PsiToDocumentSynchronizer.this.insertString(document, event.getOffset(), event.getChild().getText());
                }
            });
        }
    }

    @Override
    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "childRemoved"));
        }
        if (!(event.getChild() instanceof ForeignLeafPsiElement)) {
            this.doSync(event, false, new DocSyncAction(){

                @Override
                public void syncDocument(@NotNull Document document, @NotNull PsiTreeChangeEventImpl event) {
                    if (document == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$2", "syncDocument"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$2", "syncDocument"));
                    }
                    PsiToDocumentSynchronizer.this.deleteString(document, event.getOffset(), event.getOffset() + event.getOldLength());
                }
            });
        }
    }

    @Override
    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "childReplaced"));
        }
        this.doSync(event, false, new DocSyncAction(){

            @Override
            public void syncDocument(@NotNull Document document, @NotNull PsiTreeChangeEventImpl event) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$3", "syncDocument"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$3", "syncDocument"));
                }
                int oldLength = event.getOldChild() instanceof ForeignLeafPsiElement ? 0 : event.getOldLength();
                String newText = event.getNewChild() instanceof ForeignLeafPsiElement ? "" : event.getNewChild().getText();
                PsiToDocumentSynchronizer.this.replaceString(document, event.getOffset(), event.getOffset() + oldLength, newText, event.getNewChild());
            }
        });
    }

    @Override
    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "childrenChanged"));
        }
        this.doSync(event, false, new DocSyncAction(){

            @Override
            public void syncDocument(@NotNull Document document, @NotNull PsiTreeChangeEventImpl event) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$4", "syncDocument"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$4", "syncDocument"));
                }
                PsiToDocumentSynchronizer.this.replaceString(document, event.getOffset(), event.getOffset() + event.getOldLength(), event.getParent().getText(), event.getParent());
            }
        });
    }

    public void setIgnorePsiEvents(boolean ignorePsiEvents) {
        this.myIgnorePsiEvents = ignorePsiEvents;
    }

    public boolean isIgnorePsiEvents() {
        return this.myIgnorePsiEvents;
    }

    public boolean toProcessPsiEvent() {
        return !this.myIgnorePsiEvents && !this.myPsiDocumentManager.isCommitInProgress() && !ApplicationManager.getApplication().hasWriteAction(IgnorePsiEventsMarker.class);
    }

    public void replaceString(Document document, int startOffset, int endOffset, String s) {
        this.replaceString(document, startOffset, endOffset, s, null);
    }

    private void replaceString(Document document, int startOffset, int endOffset, String s, @Nullable PsiElement replacement) {
        DocumentChangeTransaction documentChangeTransaction = this.getTransaction(document);
        if (documentChangeTransaction != null) {
            documentChangeTransaction.replace(startOffset, endOffset - startOffset, s, replacement);
        }
    }

    public void insertString(Document document, int offset2, String s) {
        DocumentChangeTransaction documentChangeTransaction = this.getTransaction(document);
        if (documentChangeTransaction != null) {
            documentChangeTransaction.replace(offset2, 0, s, null);
        }
    }

    private void deleteString(Document document, int startOffset, int endOffset) {
        DocumentChangeTransaction documentChangeTransaction = this.getTransaction(document);
        if (documentChangeTransaction != null) {
            documentChangeTransaction.replace(startOffset, endOffset - startOffset, "", null);
        }
    }

    public void startTransaction(@NotNull Project project, @NotNull Document doc, @NotNull PsiElement scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "startTransaction"));
        }
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "startTransaction"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "startTransaction"));
        }
        LOG.assertTrue(!project.isDisposed());
        Pair<DocumentChangeTransaction, Integer> pair = this.myTransactionsMap.get(doc);
        if (pair == null) {
            PsiFile psiFile = scope.getContainingFile();
            pair = new Pair<DocumentChangeTransaction, Integer>(new DocumentChangeTransaction(doc, psiFile), 0);
            this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC).transactionStarted(doc, psiFile);
        } else {
            pair = new Pair<DocumentChangeTransaction, Integer>(pair.getFirst(), pair.getSecond() + 1);
        }
        this.myTransactionsMap.put(doc, pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTransaction(Document document) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        final DocumentChangeTransaction documentChangeTransaction = this.removeTransaction(document);
        if (documentChangeTransaction == null) {
            return false;
        }
        PsiFile changeScope = documentChangeTransaction.myChangeScope;
        try {
            this.mySyncDocument = document;
            PsiTreeChangeEventImpl fakeEvent = new PsiTreeChangeEventImpl(changeScope.getManager());
            fakeEvent.setParent(changeScope);
            fakeEvent.setFile(changeScope);
            this.checkPsiModificationAllowed(fakeEvent);
            this.doSync(fakeEvent, true, new DocSyncAction(){

                @Override
                public void syncDocument(@NotNull Document document, @NotNull PsiTreeChangeEventImpl event) {
                    if (document == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$5", "syncDocument"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$5", "syncDocument"));
                    }
                    PsiToDocumentSynchronizer.doCommitTransaction(document, documentChangeTransaction);
                }
            });
            this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC).transactionCompleted(document, changeScope);
        }
        catch (Throwable e) {
            this.myPsiDocumentManager.forceReload(changeScope.getViewProvider().getVirtualFile(), changeScope.getViewProvider());
            ExceptionUtil.rethrowAllAsUnchecked(e);
        }
        finally {
            this.mySyncDocument = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCommitTransaction(@NotNull Document document, @NotNull DocumentChangeTransaction documentChangeTransaction) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "doCommitTransaction"));
        }
        if (documentChangeTransaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentChangeTransaction", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer", "doCommitTransaction"));
        }
        DocumentEx ex = (DocumentEx)document;
        ex.suppressGuardedExceptions();
        try {
            boolean isReadOnly = !document.isWritable();
            ex.setReadOnly(false);
            for (Map.Entry entry : documentChangeTransaction.myAffectedFragments.descendingMap().entrySet()) {
                ex.replaceString(((TextRange)entry.getKey()).getStartOffset(), ((TextRange)entry.getKey()).getEndOffset(), (CharSequence)entry.getValue());
            }
            ex.setReadOnly(isReadOnly);
        }
        finally {
            ex.unSuppressGuardedExceptions();
        }
    }

    @Nullable
    private DocumentChangeTransaction removeTransaction(Document doc) {
        Pair<DocumentChangeTransaction, Integer> pair = this.myTransactionsMap.get(doc);
        if (pair == null) {
            return null;
        }
        int nestedCount = pair.getSecond();
        if (nestedCount > 0) {
            pair = Pair.create(pair.getFirst(), nestedCount - 1);
            this.myTransactionsMap.put(doc, pair);
            return null;
        }
        this.myTransactionsMap.remove(doc);
        return pair.getFirst();
    }

    public boolean isDocumentAffectedByTransactions(Document document) {
        return this.myTransactionsMap.containsKey(document);
    }

    public static class DocumentChangeTransaction {
        private final TreeMap<TextRange, CharSequence> myAffectedFragments;
        private final PsiFile myChangeScope;
        private ImmutableCharSequence myPsiText;

        DocumentChangeTransaction(@NotNull Document doc, @NotNull PsiFile scope) {
            if (doc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$DocumentChangeTransaction", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$DocumentChangeTransaction", "<init>"));
            }
            this.myAffectedFragments = new TreeMap(Comparator.comparingInt(TextRange::getStartOffset));
            this.myChangeScope = scope;
            this.myPsiText = CharArrayUtil.createImmutableCharSequence(doc.getImmutableCharSequence());
        }

        @NotNull
        public Map<TextRange, CharSequence> getAffectedFragments() {
            TreeMap<TextRange, CharSequence> treeMap = this.myAffectedFragments;
            if (treeMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$DocumentChangeTransaction", "getAffectedFragments"));
            }
            return treeMap;
        }

        public void replace(int psiStart, int length, @NotNull String replace2, @Nullable PsiElement replacement) {
            int newEndInReplace;
            int newStartInReplace;
            if (replace2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replace", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$DocumentChangeTransaction", "replace"));
            }
            int start = 0;
            int end = start + length;
            CharSequence chars = this.myPsiText.subSequence(psiStart, psiStart + length);
            if (StringUtil.equals(chars, replace2)) {
                return;
            }
            int replaceLength = replace2.length();
            for (newStartInReplace = 0; newStartInReplace < replaceLength && start < end && replace2.charAt(newStartInReplace) == chars.charAt(start); ++start, ++newStartInReplace) {
            }
            for (newEndInReplace = replaceLength; start < end && newStartInReplace < newEndInReplace && replace2.charAt(newEndInReplace - 1) == chars.charAt(end - 1); --newEndInReplace, --end) {
            }
            if (replacement != null && (newStartInReplace > 0 || newEndInReplace < replaceLength)) {
                PsiElement startLeaf = replacement.findElementAt(newStartInReplace);
                PsiElement endLeaf = replacement.findElementAt(newEndInReplace - 1);
                if (startLeaf != null && endLeaf != null) {
                    int leafStart = startLeaf.getTextRange().getStartOffset() - replacement.getTextRange().getStartOffset();
                    int leafEnd = endLeaf.getTextRange().getEndOffset() - replacement.getTextRange().getStartOffset();
                    start += leafStart - newStartInReplace;
                    end += leafEnd - newEndInReplace;
                    newStartInReplace = leafStart;
                    newEndInReplace = leafEnd;
                }
            }
            if (newStartInReplace == newEndInReplace && start > 0 && start < end && StringUtil.indexOf(chars, '\n', start, end) != -1) {
                while (start > 0 && newStartInReplace > 0 && chars.charAt(start - 1) == chars.charAt(end - 1) && chars.charAt(end - 1) != '\n') {
                    --start;
                    --end;
                    --newStartInReplace;
                    --newEndInReplace;
                }
            }
            start += psiStart;
            end += psiStart;
            ImmutableCharSequence charsSequence = this.myPsiText;
            while (start < charsSequence.length() && end < charsSequence.length() && start > 0 && charsSequence.subSequence(start, end).toString().endsWith("><") && charsSequence.charAt(start - 1) == '<') {
                --start;
                --newStartInReplace;
                --end;
                --newEndInReplace;
            }
            this.updateFragments(start, end, replace2.substring(newStartInReplace, newEndInReplace));
        }

        private void updateFragments(int start, int end, @NotNull String replace2) {
            if (replace2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replace", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$DocumentChangeTransaction", "updateFragments"));
            }
            int docStart = this.psiToDocumentOffset(start);
            int docEnd = this.psiToDocumentOffset(end);
            TextRange startRange = this.findFragment(docStart);
            TextRange endRange = this.findFragment(docEnd);
            this.myPsiText = this.myPsiText.delete(start, end).insert(start, replace2);
            TextRange newFragment = new TextRange(startRange != null ? startRange.getStartOffset() : docStart, endRange != null ? endRange.getEndOffset() : docEnd);
            CharSequence newReplacement = this.myPsiText.subSequence(this.documentToPsiOffset(newFragment.getStartOffset(), false), this.documentToPsiOffset(newFragment.getEndOffset(), true) + replace2.length() - (end - start));
            Iterator<TextRange> iterator2 = this.myAffectedFragments.keySet().iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().intersects(newFragment)) continue;
                iterator2.remove();
            }
            this.myAffectedFragments.put(newFragment, newReplacement);
        }

        private TextRange findFragment(int docOffset) {
            return ContainerUtil.find(this.myAffectedFragments.keySet(), range -> range.containsOffset(docOffset));
        }

        private int psiToDocumentOffset(int offset2) {
            for (Map.Entry<TextRange, CharSequence> entry : this.myAffectedFragments.entrySet()) {
                int lengthAfter = entry.getValue().length();
                TextRange range = entry.getKey();
                if (range.getStartOffset() + lengthAfter < offset2) {
                    offset2 += range.getLength() - lengthAfter;
                    continue;
                }
                return Math.min(range.getStartOffset(), offset2);
            }
            return offset2;
        }

        private int documentToPsiOffset(int offset2, boolean greedyRight) {
            int delta = 0;
            for (Map.Entry<TextRange, CharSequence> entry : this.myAffectedFragments.entrySet()) {
                int lengthAfter = entry.getValue().length();
                TextRange range = entry.getKey();
                if (range.containsOffset(offset2)) {
                    return range.getStartOffset() + delta + (greedyRight ? lengthAfter : 0);
                }
                if (range.getStartOffset() > offset2) break;
                delta += lengthAfter - range.getLength();
            }
            return offset2 + delta;
        }
    }

    private static interface DocSyncAction {
        public void syncDocument(@NotNull Document var1, @NotNull PsiTreeChangeEventImpl var2);
    }
}

