/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiForeachStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class PsiForeachStatementImpl
extends CompositePsiElement
implements PsiForeachStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiForeachStatementImpl");

    public PsiForeachStatementImpl() {
        super(FOREACH_STATEMENT);
    }

    @Override
    @NotNull
    public PsiParameter getIterationParameter() {
        PsiParameter psiParameter = (PsiParameter)this.findChildByRoleAsPsiElement(125);
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiForeachStatementImpl", "getIterationParameter"));
        }
        return psiParameter;
    }

    @Override
    public PsiExpression getIteratedValue() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(124);
    }

    @Override
    public PsiStatement getBody() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(38);
    }

    @Override
    @NotNull
    public PsiJavaToken getLParenth() {
        PsiJavaToken psiJavaToken = (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
        if (psiJavaToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiForeachStatementImpl", "getLParenth"));
        }
        return psiJavaToken;
    }

    @Override
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 38: {
                return PsiImplUtil.findStatementChild(this);
            }
            case 124: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 37: {
                return this.getFirstChildNode();
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 125: {
                return this.findChildByType(PARAMETER);
            }
            case 87: {
                return this.findChildByType(COLON);
            }
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == FOR_KEYWORD) {
            return 37;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (i == PARAMETER) {
            return 125;
        }
        if (i == COLON) {
            return 87;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 124;
        }
        if (child.getPsi() instanceof PsiStatement) {
            return 38;
        }
        return 0;
    }

    @Override
    public String toString() {
        return "PsiForeachStatement";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiForeachStatementImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiForeachStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiForeachStatementImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        if (lastParent == null || lastParent.getParent() != this || lastParent == this.getIteratedValue()) {
            return true;
        }
        return processor.execute(this.getIterationParameter(), state2);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiForeachStatementImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitForeachStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }
}

