/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.lang.reflect.Type;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MultiNodeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Serializer;
import org.jetbrains.kotlin.org.jdom.Element;

public abstract class Binding {
    static final Logger LOG = Logger.getInstance(Binding.class);
    protected final MutableAccessor myAccessor;

    protected Binding(MutableAccessor accessor) {
        this.myAccessor = accessor;
    }

    @NotNull
    public MutableAccessor getAccessor() {
        MutableAccessor mutableAccessor = this.myAccessor;
        if (mutableAccessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/Binding", "getAccessor"));
        }
        return mutableAccessor;
    }

    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/Binding", "isBoundTo"));
        }
        return false;
    }

    public void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/kotlin/com/intellij/util/xmlb/Binding", "init"));
        }
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "org/jetbrains/kotlin/com/intellij/util/xmlb/Binding", "init"));
        }
    }

    @Nullable
    public static Object deserializeList(@NotNull Binding binding, @Nullable Object context, @NotNull List<Element> nodes) {
        if (binding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binding", "org/jetbrains/kotlin/com/intellij/util/xmlb/Binding", "deserializeList"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "org/jetbrains/kotlin/com/intellij/util/xmlb/Binding", "deserializeList"));
        }
        if (binding instanceof MultiNodeBinding) {
            return ((MultiNodeBinding)((Object)binding)).deserializeList(context, nodes);
        }
        if (nodes.size() == 1) {
            return binding.deserializeUnsafe(context, nodes.get(0));
        }
        if (nodes.isEmpty()) {
            return null;
        }
        throw new AssertionError((Object)("Duplicate data for " + binding + " will be ignored"));
    }

    public abstract Object deserializeUnsafe(Object var1, @NotNull Element var2);
}

