/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;

public class SourceFilePathResolver {
    @NotNull
    private final Set<File> sourceRoots;
    @NotNull
    private final Map<File, String> cache;

    public SourceFilePathResolver(@NotNull List<File> sourceRoots) {
        if (sourceRoots == null) {
            SourceFilePathResolver.$$$reportNull$$$0(0);
        }
        this.cache = new HashMap<File, String>();
        this.sourceRoots = new HashSet<File>();
        for (File sourceRoot : sourceRoots) {
            this.sourceRoots.add(sourceRoot.getAbsoluteFile());
        }
    }

    @NotNull
    public String getPathRelativeToSourceRoots(@NotNull File file) throws IOException {
        String path;
        if (file == null) {
            SourceFilePathResolver.$$$reportNull$$$0(1);
        }
        if ((path = this.cache.get(file)) == null) {
            path = this.calculatePathRelativeToSourceRoots(file);
            this.cache.put(file, path);
        }
        String string = path;
        if (string == null) {
            SourceFilePathResolver.$$$reportNull$$$0(2);
        }
        return string;
    }

    private String calculatePathRelativeToSourceRoots(@NotNull File file) throws IOException {
        if (file == null) {
            SourceFilePathResolver.$$$reportNull$$$0(3);
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (File currentFile = file.getCanonicalFile(); currentFile != null; currentFile = currentFile.getParentFile()) {
            if (this.sourceRoots.contains(currentFile)) {
                if (parts.isEmpty()) break;
                Collections.reverse(parts);
                return StringUtil.join(parts, File.separator);
            }
            parts.add(currentFile.getName());
        }
        return file.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathRelativeToSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToSourceRoots";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculatePathRelativeToSourceRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

