/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines.experimental;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.CancellableContinuation;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.CoroutineDispatcher;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.Delay;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.DisposableFutureHandle;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.DisposableHandle;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.Job;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.JobKt;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.PoolThread;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.ResumeUndispatchedRunnable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J&\u0010 \u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\"H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/ThreadPoolDispatcher;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/CoroutineDispatcher;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/Delay;", "nThreads", "", "name", "", "job", "Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/Job;", "(ILjava/lang/String;Lkotlinx/coroutines/experimental/Job;)V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "getJob", "()Lkotlinx/coroutines/experimental/Job;", "threadNo", "Ljava/util/concurrent/atomic/AtomicInteger;", "getThreadNo", "()Ljava/util/concurrent/atomic/AtomicInteger;", "dispatch", "", "context", "Lkotlin/coroutines/experimental/CoroutineContext;", "block", "Ljava/lang/Runnable;", "invokeOnTimeout", "Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/DisposableHandle;", "time", "", "unit", "Ljava/util/concurrent/TimeUnit;", "scheduleResumeAfterDelay", "continuation", "Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/CancellableContinuation;", "kotlinx-coroutines-core"})
public final class ThreadPoolDispatcher
extends CoroutineDispatcher
implements Delay {
    @NotNull
    private final AtomicInteger threadNo;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final Job job;

    @NotNull
    public final AtomicInteger getThreadNo() {
        return this.threadNo;
    }

    @NotNull
    public final ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(block, "block");
        this.executor.execute(block);
    }

    @Override
    public void scheduleResumeAfterDelay(long time, @NotNull TimeUnit unit, @NotNull CancellableContinuation<? super Unit> continuation2) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull(continuation2, "continuation");
        ScheduledFuture<?> timeout = this.executor.schedule(new ResumeUndispatchedRunnable(this, continuation2), time, unit);
        Job job = continuation2;
        ScheduledFuture<?> scheduledFuture = timeout;
        Intrinsics.checkExpressionValueIsNotNull(scheduledFuture, "timeout");
        JobKt.cancelFutureOnCompletion(job, (Future)scheduledFuture);
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long time, @NotNull TimeUnit unit, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull(block, "block");
        ScheduledFuture<?> scheduledFuture = this.executor.schedule(block, time, unit);
        Intrinsics.checkExpressionValueIsNotNull(scheduledFuture, "executor.schedule(block, time, unit)");
        return new DisposableFutureHandle((Future)scheduledFuture);
    }

    @NotNull
    public final Job getJob() {
        return this.job;
    }

    public ThreadPoolDispatcher(int nThreads, @NotNull String name, @NotNull Job job) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(job, "job");
        this.job = job;
        this.threadNo = new AtomicInteger();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(nThreads, new ThreadFactory(this, nThreads, name){
            final /* synthetic */ ThreadPoolDispatcher this$0;
            final /* synthetic */ int $nThreads;
            final /* synthetic */ String $name;

            @NotNull
            public final PoolThread newThread(Runnable target) {
                Runnable runnable = target;
                Intrinsics.checkExpressionValueIsNotNull(runnable, "target");
                return new PoolThread(this.this$0, runnable, this.$nThreads == 1 ? this.$name : this.$name + "-" + this.this$0.getThreadNo().incrementAndGet());
            }
            {
                this.this$0 = threadPoolDispatcher;
                this.$nThreads = n;
                this.$name = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(scheduledExecutorService, "Executors.newScheduledTh\u2026.incrementAndGet())\n    }");
        this.executor = scheduledExecutorService;
        this.job.invokeOnCompletion((Function1<? super Throwable, Unit>)new Function1<Throwable, Unit>(){

            @Override
            public final void invoke(@Nullable Throwable it) {
                this.getExecutor().shutdown();
            }
        });
    }

    @Override
    @Nullable
    public Object delay(long time, @NotNull TimeUnit unit, @NotNull Continuation<? super Unit> $continuation) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull($continuation, "$continuation");
        return Delay.DefaultImpls.delay(this, time, unit, $continuation);
    }
}

