/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core;

import grails.core.GrailsApplication;
import grails.core.GrailsClass;
import grails.plugins.GrailsVersionUtils;
import grails.util.GrailsMetaClassUtils;
import grails.util.GrailsNameUtils;
import grails.web.Action;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.grails.core.exceptions.NewInstanceCreationException;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractGrailsClass
implements GrailsClass {
    private final Class<?> clazz;
    private final String fullName;
    private final String name;
    private final String packageName;
    private final String naturalName;
    private final String shortName;
    private final String propertyName;
    private final String logicalPropertyName;
    private ClassPropertyFetcher classPropertyFetcher;
    protected GrailsApplication grailsApplication;
    private boolean isAbstract;

    public AbstractGrailsClass(Class<?> clazz, String trailingName) {
        Assert.notNull(clazz, (String)"Clazz parameter should not be null");
        this.clazz = clazz;
        this.fullName = clazz.getName();
        this.packageName = ClassUtils.getPackageName(clazz);
        this.naturalName = GrailsNameUtils.getNaturalName((String)clazz.getName());
        this.shortName = ClassUtils.getShortName(clazz);
        this.name = GrailsNameUtils.getLogicalName(clazz, (String)trailingName);
        this.propertyName = GrailsNameUtils.getPropertyNameRepresentation((String)this.shortName);
        this.logicalPropertyName = !StringUtils.hasText((String)this.name) ? this.propertyName : GrailsNameUtils.getPropertyNameRepresentation((String)this.name);
        this.isAbstract = Modifier.isAbstract(clazz.getModifiers());
    }

    @Override
    public String getPluginName() {
        return GrailsVersionUtils.getPluginName(this.clazz);
    }

    @Override
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    @Override
    public GrailsApplication getApplication() {
        return this.grailsApplication;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public Object newInstance() {
        try {
            Constructor<?> defaultConstructor = this.getClazz().getDeclaredConstructor(new Class[0]);
            if (!defaultConstructor.isAccessible()) {
                defaultConstructor.setAccessible(true);
            }
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwable targetException = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            throw new NewInstanceCreationException("Could not create a new instance of class [" + this.getClazz().getName() + "]!", targetException);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNaturalName() {
        return this.naturalName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getLogicalPropertyName() {
        return this.logicalPropertyName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public Object getReferenceInstance() {
        Object obj = BeanUtils.instantiate(this.clazz);
        if (obj instanceof GroovyObject) {
            ((GroovyObject)obj).setMetaClass(this.getMetaClass());
        }
        return obj;
    }

    @Deprecated
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.resolvePropertyFetcher().getPropertyDescriptors();
    }

    private ClassPropertyFetcher resolvePropertyFetcher() {
        if (this.classPropertyFetcher == null) {
            this.classPropertyFetcher = ClassPropertyFetcher.forClass(this.clazz);
        }
        return this.classPropertyFetcher;
    }

    public List<MetaProperty> getMetaProperties() {
        return this.resolvePropertyFetcher().getMetaProperties();
    }

    public Class<?> getPropertyType(String typeName) {
        return ClassPropertyFetcher.getPropertyType(this.getClazz(), (String)typeName);
    }

    public boolean isReadableProperty(String propName) {
        return ClassPropertyFetcher.getPropertyType(this.getClazz(), (String)propName) != null;
    }

    public boolean isActionMethod(String methodName) {
        Method m = ReflectionUtils.findMethod(this.getClazz(), (String)methodName, (Class[])new Class[0]);
        if (m != null) {
            ReflectionUtils.makeAccessible((Method)m);
        }
        return m != null && m.getAnnotation(Action.class) != null;
    }

    public boolean hasMetaMethod(String methodName) {
        return this.hasMetaMethod(methodName, null);
    }

    public boolean hasMetaMethod(String methodName, Object[] args) {
        return this.getMetaClass().getMetaMethod(methodName, args) != null;
    }

    public boolean hasMetaProperty(String propName) {
        return this.getMetaClass().getMetaProperty(propName) != null;
    }

    protected <T> T getPropertyOrStaticPropertyOrFieldValue(String name, Class<T> type) {
        return (T)ClassPropertyFetcher.getStaticPropertyValue(this.getClazz(), (String)name, type);
    }

    public <T> T getStaticPropertyValue(String propName, Class<T> type) {
        return (T)ClassPropertyFetcher.getStaticPropertyValue(this.getClazz(), (String)propName, type);
    }

    @Override
    public <T> T getPropertyValue(String propName, Class<T> type) {
        return (T)ClassPropertyFetcher.getStaticPropertyValue(this.getClazz(), (String)this.name, type);
    }

    public Object getPropertyValueObject(String propertyNAme) {
        return this.getPropertyValue(propertyNAme, Object.class);
    }

    @Override
    public Object getPropertyValue(String propName) {
        return this.getPropertyOrStaticPropertyOrFieldValue(propName, Object.class);
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean hasProperty(String propName) {
        return ClassPropertyFetcher.getPropertyType(this.getClazz(), (String)propName) != null;
    }

    @Override
    public MetaClass getMetaClass() {
        return GrailsMetaClassUtils.getExpandoMetaClass(this.getClazz());
    }

    public String toString() {
        return "Artefact > " + this.getName();
    }
}

