/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.help.HelpIndex;
import org.gjt.sp.jedit.help.HelpViewerInterface;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class HelpSearchPanel
extends JPanel {
    private HelpViewerInterface helpViewer;
    private HistoryTextField searchField;
    private JList<Result> results;
    private HelpIndex index;

    public HelpSearchPanel(HelpViewerInterface helpViewerInterface) {
        super(new BorderLayout(6, 6));
        this.helpViewer = helpViewerInterface;
        Box box = new Box(0);
        box.add(new JLabel(jEdit.getProperty("helpviewer.search.caption")));
        box.add(Box.createHorizontalStrut(6));
        this.searchField = new HistoryTextField("helpviewer.search");
        box.add(this.searchField);
        this.searchField.addActionListener(new ActionHandler());
        this.add("North", box);
        this.results = new JList();
        this.results.addMouseListener(new MouseHandler());
        this.results.setSelectionMode(0);
        this.results.setCellRenderer(new ResultRenderer());
        this.add("Center", new JScrollPane(this.results));
    }

    private HelpIndex getHelpIndex() {
        if (this.index == null) {
            this.index = new HelpIndex();
            try {
                this.index.indexEditorHelp();
            }
            catch (Exception exception) {
                this.index = null;
                Log.log(9, this, exception);
                GUIUtilities.error(this.helpViewer.getComponent(), "helpviewer.search.error", new String[]{exception.toString()});
            }
        }
        return this.index;
    }

    public class MouseHandler
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = HelpSearchPanel.this.results.locationToIndex(mouseEvent.getPoint());
            if (n != -1) {
                Result result = (Result)HelpSearchPanel.this.results.getModel().getElementAt(n);
                HelpSearchPanel.this.helpViewer.gotoURL(result.file, true, 0);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final HelpIndex helpIndex = HelpSearchPanel.this.getHelpIndex();
            if (helpIndex == null) {
                return;
            }
            HelpSearchPanel.this.results.setListData(new Result[]{new Result(jEdit.getProperty("helpviewer.searching"))});
            final String string = HelpSearchPanel.this.searchField.getText();
            final ArrayList arrayList = new ArrayList();
            ThreadUtilities.runInBackground(new Runnable(){

                @Override
                public void run() {
                    Object object;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",.;:-? ");
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken().toLowerCase();
                        object = helpIndex.lookupWord(string2);
                        if (object == null) continue;
                        for (int i = 0; i < ((HelpIndex.Word)object).occurCount; ++i) {
                            HelpIndex.Word.Occurrence occurrence = ((HelpIndex.Word)object).occurrences[i];
                            boolean bl = false;
                            HelpIndex.HelpFile helpFile = helpIndex.getFile(occurrence.file);
                            for (int j = 0; j < arrayList.size(); ++j) {
                                Result result = (Result)arrayList.get(j);
                                if (!result.file.equals(helpFile.file)) continue;
                                result.rank += occurrence.count;
                                result.rank += 20;
                                n = Math.max(result.rank, n);
                                bl = true;
                                break;
                            }
                            if (bl) continue;
                            n = Math.max(occurrence.count, n);
                            arrayList.add(new Result(helpFile, occurrence.count));
                        }
                    }
                    if (n != 0) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            object = (Result)arrayList.get(i);
                            ((Result)object).rank = (int)Math.ceil((double)((Result)object).rank * 4.0 / (double)n);
                        }
                        Collections.sort(arrayList, new ResultCompare());
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (arrayList.isEmpty()) {
                                HelpSearchPanel.this.results.setListData(new Result[]{new Result(jEdit.getProperty("helpviewer.no-results"))});
                                UIManager.getLookAndFeel().provideErrorFeedback(null);
                            } else {
                                HelpSearchPanel.this.results.setListData(arrayList.toArray(new Result[arrayList.size()]));
                            }
                        }
                    });
                }
            });
        }
    }

    static class ResultCompare
    implements Comparator<Result> {
        ResultCompare() {
        }

        @Override
        public int compare(Result result, Result result2) {
            if (result.rank == result2.rank) {
                return result.title.compareTo(result2.title);
            }
            return result2.rank - result.rank;
        }
    }

    static class Result {
        String file;
        String title;
        int rank;

        Result(String string) {
            this.title = string;
        }

        Result(HelpIndex.HelpFile helpFile, int n) {
            this.file = helpFile.file;
            this.title = helpFile.title;
            this.rank = n;
        }
    }

    static class ResultRenderer
    extends DefaultListCellRenderer {
        ResultRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, (Object)null, n, bl, bl2);
            if (object instanceof String) {
                this.setIcon(null);
                this.setText((String)object);
            } else {
                Result result = (Result)object;
                this.setIcon(new ResultIcon(result.rank));
                this.setText(result.title);
            }
            return this;
        }
    }

    static class ResultIcon
    implements Icon {
        private static RenderingHints renderingHints;
        private int rank;

        ResultIcon(int n) {
            this.rank = n;
        }

        @Override
        public int getIconWidth() {
            return 40;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHints(renderingHints);
            for (int i = 0; i < 4; ++i) {
                if (this.rank > i) {
                    graphics2D.setColor(UIManager.getColor("Label.foreground"));
                } else {
                    graphics2D.setColor(UIManager.getColor("Label.disabledForeground"));
                }
                graphics2D.fillOval(n + i * 10, n2, 9, 9);
            }
        }

        static {
            HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
            hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints = new RenderingHints(hashMap);
        }
    }
}

