/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.util.Map;
import java.util.Set;

public class TileSourceInfo {
    protected String id;
    protected String url;
    protected String name;
    protected Map<String, Set<String>> noTileHeaders;
    protected Map<String, Set<String>> noTileChecksums;
    protected int minZoom;
    protected int maxZoom;
    protected String cookies = "";
    private int tileSize = -1;
    protected Map<String, String> metadataHeaders;

    public TileSourceInfo(String name, String baseUrl, String id) {
        this.name = name;
        this.url = baseUrl;
        this.id = id;
    }

    public TileSourceInfo(String name) {
        this(name, null, null);
    }

    public TileSourceInfo() {
        this(null, null, null);
    }

    public final String getName() {
        return this.name;
    }

    public final String getUrl() {
        return this.url;
    }

    public final String getId() {
        return this.id;
    }

    public Map<String, Set<String>> getNoTileHeaders() {
        return this.noTileHeaders;
    }

    public Map<String, Set<String>> getNoTileChecksums() {
        return this.noTileChecksums;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public String getCookies() {
        return this.cookies;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public Map<String, String> getMetadataHeaders() {
        return this.metadataHeaders;
    }

    public final void setTileSize(int tileSize) {
        if (tileSize == 0 || tileSize < -1) {
            throw new AssertionError((Object)("Invalid tile size: " + tileSize));
        }
        this.tileSize = tileSize;
    }

    public final void setUrl(String url) {
        this.url = url;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setId(String id) {
        this.id = id;
    }
}

