/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class OffsetBookmark {
    private static final List<OffsetBookmark> allBookmarks = new ArrayList<OffsetBookmark>();
    @StructUtils.StructEntry
    private String projection_code;
    @StructUtils.StructEntry
    private String imagery_name;
    @StructUtils.StructEntry
    private String name;
    @StructUtils.StructEntry
    @StructUtils.WriteExplicitly
    private double dx;
    @StructUtils.StructEntry
    @StructUtils.WriteExplicitly
    private double dy;
    @StructUtils.StructEntry
    private double center_lon;
    @StructUtils.StructEntry
    private double center_lat;

    public boolean isUsable(ImageryLayer layer) {
        if (this.projection_code == null) {
            return false;
        }
        if (!Main.getProjection().toCode().equals(this.projection_code) && !this.hasCenter()) {
            return false;
        }
        return layer.getInfo().getName().equals(this.imagery_name);
    }

    public OffsetBookmark() {
    }

    public OffsetBookmark(String projectionCode, String imageryName, String name, double dx, double dy) {
        this(projectionCode, imageryName, name, dx, dy, 0.0, 0.0);
    }

    public OffsetBookmark(String projectionCode, String imageryName, String name, double dx, double dy, double centerLon, double centerLat) {
        this.projection_code = projectionCode;
        this.imagery_name = imageryName;
        this.name = name;
        this.dx = dx;
        this.dy = dy;
        this.center_lon = centerLon;
        this.center_lat = centerLat;
    }

    public OffsetBookmark(Collection<String> list) {
        ArrayList<String> array = new ArrayList<String>(list);
        this.projection_code = (String)array.get(0);
        this.imagery_name = (String)array.get(1);
        this.name = (String)array.get(2);
        this.dx = Double.parseDouble((String)array.get(3));
        this.dy = Double.parseDouble((String)array.get(4));
        if (array.size() >= 7) {
            this.center_lon = Double.parseDouble((String)array.get(5));
            this.center_lat = Double.parseDouble((String)array.get(6));
        }
        if (this.projection_code == null) {
            Logging.error(I18n.tr("Projection ''{0}'' is not found, bookmark ''{1}'' is not usable", this.projection_code, this.name));
        }
    }

    public String getProjectionCode() {
        return this.projection_code;
    }

    public String getName() {
        return this.name;
    }

    public String getImageryName() {
        return this.imagery_name;
    }

    public EastNorth getDisplacement() {
        return new EastNorth(this.dx, this.dy);
    }

    public EastNorth getDisplacement(Projection proj) {
        if (proj.toCode().equals(this.projection_code)) {
            return this.getDisplacement();
        }
        LatLon center = this.getCenter();
        Projection offsetProj = Projections.getProjectionByCode(this.projection_code);
        EastNorth centerEN = center.getEastNorth(offsetProj);
        EastNorth shiftedEN = centerEN.add(this.getDisplacement());
        LatLon shifted = offsetProj.eastNorth2latlon(shiftedEN);
        EastNorth centerEN2 = center.getEastNorth(proj);
        EastNorth shiftedEN2 = shifted.getEastNorth(proj);
        return shiftedEN2.subtract(centerEN2);
    }

    public LatLon getCenter() {
        return new LatLon(this.center_lat, this.center_lon);
    }

    public boolean hasCenter() {
        return this.center_lat != 0.0 || this.center_lon != 0.0;
    }

    public void setProjectionCode(String projectionCode) {
        this.projection_code = projectionCode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setImageryName(String imageryName) {
        this.imagery_name = imageryName;
    }

    public void setDisplacement(EastNorth displacement) {
        this.dx = displacement.east();
        this.dy = displacement.north();
    }

    public static void loadBookmarks() {
        List<OffsetBookmark> bookmarks = StructUtils.getListOfStructs(Config.getPref(), "imagery.offsetbookmarks", null, OffsetBookmark.class);
        if (bookmarks == null) {
            OffsetBookmark.loadBookmarksOld();
            OffsetBookmark.saveBookmarks();
        } else {
            allBookmarks.addAll(bookmarks);
        }
    }

    private static void loadBookmarksOld() {
        for (Collection collection : Config.getPref().getListOfLists("imagery.offsets")) {
            allBookmarks.add(new OffsetBookmark(collection));
        }
    }

    public static void saveBookmarks() {
        StructUtils.putListOfStructs(Config.getPref(), "imagery.offsetbookmarks", allBookmarks, OffsetBookmark.class);
    }

    public static List<OffsetBookmark> getBookmarks() {
        return Collections.unmodifiableList(allBookmarks);
    }

    public static int getBookmarksSize() {
        return allBookmarks.size();
    }

    public static boolean addBookmark(OffsetBookmark ob) {
        return allBookmarks.add(ob);
    }

    public static boolean removeBookmark(OffsetBookmark ob) {
        return allBookmarks.remove(ob);
    }

    public static OffsetBookmark getBookmarkByIndex(int index) {
        return allBookmarks.get(index);
    }

    public static OffsetBookmark getBookmarkByName(ImageryLayer layer, String name) {
        for (OffsetBookmark b : allBookmarks) {
            if (!b.isUsable(layer) || !name.equals(b.name)) continue;
            return b;
        }
        return null;
    }

    public static void bookmarkOffset(String name, AbstractTileSourceLayer layer) {
        LatLon center = MainApplication.isDisplayingMapView() ? Main.getProjection().eastNorth2latlon(MainApplication.getMap().mapView.getCenter()) : LatLon.ZERO;
        OffsetBookmark nb = new OffsetBookmark(Main.getProjection().toCode(), layer.getInfo().getName(), name, layer.getDisplaySettings().getDx(), layer.getDisplaySettings().getDy(), center.lon(), center.lat());
        ListIterator<OffsetBookmark> it = allBookmarks.listIterator();
        while (it.hasNext()) {
            OffsetBookmark b = it.next();
            if (!b.isUsable(layer) || !name.equals(b.name)) continue;
            it.set(nb);
            OffsetBookmark.saveBookmarks();
            return;
        }
        allBookmarks.add(nb);
        OffsetBookmark.saveBookmarks();
    }

    public Map<String, String> toPropertiesMap() {
        return StructUtils.serializeStruct(this, OffsetBookmark.class);
    }

    public static OffsetBookmark fromPropertiesMap(Map<String, String> properties) {
        return StructUtils.deserializeStruct(properties, OffsetBookmark.class);
    }
}

