/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Locale;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class UntaggedNode
extends Test
implements AbstractPrimitive.KeyValueVisitor {
    protected static final int UNTAGGED_NODE_BLANK = 201;
    protected static final int UNTAGGED_NODE_FIXME = 202;
    protected static final int UNTAGGED_NODE_NOTE = 203;
    protected static final int UNTAGGED_NODE_CREATED_BY = 204;
    protected static final int UNTAGGED_NODE_WATCH = 205;
    protected static final int UNTAGGED_NODE_SOURCE = 206;
    protected static final int UNTAGGED_NODE_OTHER = 207;
    protected static final String ERROR_MESSAGE = I18n.tr("Unconnected nodes without physical tags", new Object[0]);

    public UntaggedNode() {
        super(I18n.tr("Untagged and unconnected nodes", new Object[0]), I18n.tr("This test checks for untagged nodes that are not part of any way.", new Object[0]));
    }

    @Override
    public void visit(Node n) {
        if (n.isUsable() && !n.isTagged() && n.getReferrers().isEmpty()) {
            if (!n.hasKeys() && IN_DOWNLOADED_AREA.test(n)) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 201).message(ERROR_MESSAGE, I18n.marktr("No tags"), new Object[0]).primitives(n).build());
                return;
            }
            n.visitKeys(this);
        }
    }

    private static OsmPrimitive[] castPrim(AbstractPrimitive n) {
        OsmPrimitive[] osmPrimitiveArray;
        if (n instanceof OsmPrimitive) {
            OsmPrimitive[] osmPrimitiveArray2 = new OsmPrimitive[1];
            osmPrimitiveArray = osmPrimitiveArray2;
            osmPrimitiveArray2[0] = (OsmPrimitive)n;
        } else {
            osmPrimitiveArray = new OsmPrimitive[]{};
        }
        return osmPrimitiveArray;
    }

    @Override
    public void visitKeyValue(AbstractPrimitive n, String key, String value) {
        if (key.toLowerCase(Locale.ENGLISH).contains("fixme") || value.toLowerCase(Locale.ENGLISH).contains("fixme")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 202).message(ERROR_MESSAGE, I18n.marktr("Has tag containing ''fixme'' or ''FIXME''"), new Object[0]).primitives(UntaggedNode.castPrim(n)).build());
            return;
        }
        String msg = null;
        int code = 0;
        if (key.startsWith("note") || key.startsWith("comment") || key.startsWith("description")) {
            msg = I18n.marktr("Has key ''note'' or ''comment'' or ''description''");
            code = 203;
        } else if (key.startsWith("created_by") || key.startsWith("converted_by")) {
            msg = I18n.marktr("Has key ''created_by'' or ''converted_by''");
            code = 204;
        } else if (key.startsWith("watch")) {
            msg = I18n.marktr("Has key ''watch''");
            code = 205;
        } else if (key.startsWith("source")) {
            msg = I18n.marktr("Has key ''source''");
            code = 206;
        }
        if (msg != null) {
            this.errors.add(TestError.builder(this, Severity.WARNING, code).message(ERROR_MESSAGE, msg, new Object[0]).primitives(UntaggedNode.castPrim(n)).build());
            return;
        }
        this.errors.add(TestError.builder(this, Severity.WARNING, 207).message(ERROR_MESSAGE, I18n.marktr("Other"), new Object[0]).primitives(UntaggedNode.castPrim(n)).build());
    }

    @Override
    public Command fixError(TestError testError) {
        return this.deletePrimitivesIfNeeded(testError.getPrimitives());
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof UntaggedNode) {
            int code = testError.getCode();
            switch (code) {
                case 201: 
                case 204: 
                case 205: 
                case 206: {
                    return true;
                }
            }
        }
        return false;
    }
}

