/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapSlider;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.autofilter.AutoFilterManager;
import org.openstreetmap.josm.gui.datatransfer.OsmTransferHandler;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class MapView
extends NavigatableComponent
implements PropertyChangeListener,
PreferenceChangedListener,
LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    private final MainLayerManager layerManager;
    public transient PlayHeadMarker playHeadMarker;
    public MouseEvent lastMEvent = new MouseEvent(this, 0, 0L, 0, 0, 0, 0, false);
    private final transient Set<MapViewPaintable> temporaryLayers = new LinkedHashSet<MapViewPaintable>();
    private transient BufferedImage nonChangedLayersBuffer;
    private transient BufferedImage offscreenBuffer;
    private final transient List<Layer> nonChangedLayers = new ArrayList<Layer>();
    private int lastViewID;
    private final AtomicBoolean paintPreferencesChanged = new AtomicBoolean(true);
    private Rectangle lastClipBounds = new Rectangle();
    private transient MapMover mapMover;
    private final LayerInvalidatedListener invalidatedListener = new LayerInvalidatedListener();
    private final HashMap<Layer, MapViewPaintable.LayerPainter> registeredLayers = new HashMap();
    private Dimension oldSize;
    private Point oldLoc;
    private boolean virtualNodesEnabled;
    private final transient DataSelectionListener repaintSelectionChangedListener = event -> this.repaint();
    private final transient CopyOnWriteArrayList<RepaintListener> repaintListeners = new CopyOnWriteArrayList();

    @Deprecated
    public MapView(MainLayerManager layerManager, JPanel contentPane, ViewportData viewportData) {
        this(layerManager, viewportData);
    }

    public MapView(MainLayerManager layerManager, ViewportData viewportData) {
        this.layerManager = layerManager;
        this.initialViewport = viewportData;
        layerManager.addAndFireLayerChangeListener(this);
        layerManager.addActiveLayerChangeListener(this);
        Config.getPref().addPreferenceChangeListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MapView.this.removeComponentListener(this);
                MapView.this.mapMover = new MapMover(MapView.this);
            }
        });
        SelectionEventManager.getInstance().addSelectionListenerForEdt(this.repaintSelectionChangedListener);
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mouseMoved(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                MapView.this.lastMEvent = e;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                MapView.this.requestFocus();
            }
        });
        this.setFocusTraversalKeysEnabled(!Shortcut.findShortcut(9, 0).isPresent());
        for (JComponent jComponent : MapView.getMapNavigationComponents(this)) {
            this.add(jComponent);
        }
        if (AutoFilterManager.PROP_AUTO_FILTER_ENABLED.get().booleanValue()) {
            AutoFilterManager.getInstance().enableAutoFilterRule(AutoFilterManager.PROP_AUTO_FILTER_RULE.get());
        }
        this.setTransferHandler(new OsmTransferHandler());
    }

    public static List<? extends JComponent> getMapNavigationComponents(MapView forMapView) {
        MapSlider zoomSlider = new MapSlider(forMapView);
        Dimension size = zoomSlider.getPreferredSize();
        zoomSlider.setSize(size);
        zoomSlider.setLocation(3, 0);
        zoomSlider.setFocusTraversalKeysEnabled(!Shortcut.findShortcut(9, 0).isPresent());
        MapScaler scaler = new MapScaler(forMapView);
        scaler.setPreferredLineLength(size.width - 10);
        scaler.setSize(scaler.getPreferredSize());
        scaler.setLocation(3, size.height);
        return Arrays.asList(zoomSlider, scaler);
    }

    public void rememberLastPositionOnScreen() {
        this.oldSize = this.getSize();
        this.oldLoc = this.getLocationOnScreen();
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
        try {
            Layer layer = e.getAddedLayer();
            this.registeredLayers.put(layer, new WarningLayerPainter(layer));
            MapViewPaintable.LayerPainter painter = layer.attachToMapView(new MapViewPaintable.MapViewEvent(this, false));
            if (!this.registeredLayers.containsKey(layer)) {
                Logging.warn("Layer was removed during attachToMapView()");
            } else {
                ProjectionBounds viewProjectionBounds;
                this.registeredLayers.put(layer, painter);
                if (e.isZoomRequired() && (viewProjectionBounds = layer.getViewProjectionBounds()) != null) {
                    this.scheduleZoomTo(new ViewportData(viewProjectionBounds));
                }
                layer.addPropertyChangeListener(this);
                Main.addProjectionChangeListener(layer);
                this.invalidatedListener.addTo(layer);
                AudioPlayer.reset();
                this.repaint();
            }
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException t) {
            throw BugReport.intercept(t).put("layer", e.getAddedLayer());
        }
    }

    public boolean isActiveLayerDrawable() {
        return this.layerManager.getEditLayer() != null;
    }

    public boolean isActiveLayerVisible() {
        OsmDataLayer e = this.layerManager.getEditLayer();
        return e != null && e.isVisible();
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        Layer layer = e.getRemovedLayer();
        MapViewPaintable.LayerPainter painter = this.registeredLayers.remove(layer);
        if (painter == null) {
            Logging.error("The painter for layer " + layer + " was not registered.");
            return;
        }
        painter.detachFromMapView(new MapViewPaintable.MapViewEvent(this, false));
        Main.removeProjectionChangeListener(layer);
        layer.removePropertyChangeListener(this);
        this.invalidatedListener.removeFrom(layer);
        layer.destroy();
        AudioPlayer.reset();
        this.repaint();
    }

    public void setVirtualNodesEnabled(boolean enabled) {
        if (this.virtualNodesEnabled != enabled) {
            this.virtualNodesEnabled = enabled;
            this.repaint();
        }
    }

    public boolean isVirtualNodesEnabled() {
        return this.virtualNodesEnabled;
    }

    public void moveLayer(Layer layer, int pos) {
        this.layerManager.moveLayer(layer, pos);
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
        AudioPlayer.reset();
        this.repaint();
    }

    public void paintLayer(Layer layer, Graphics2D g) {
        try {
            MapViewPaintable.LayerPainter painter = this.registeredLayers.get(layer);
            if (painter == null) {
                Logging.warn("Cannot paint layer, it is not registered: {0}", layer);
                return;
            }
            MapViewState.MapViewRectangle clipBounds = this.getState().getViewArea(g.getClipBounds());
            MapViewGraphics paintGraphics = new MapViewGraphics(this, g, clipBounds);
            if (layer.getOpacity() < 1.0) {
                g.setComposite(AlphaComposite.getInstance(3, (float)layer.getOpacity()));
            }
            painter.paint(paintGraphics);
            g.setPaintMode();
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException t) {
            BugReport.intercept(t).put("layer", layer).warn();
        }
    }

    @Override
    public void paint(Graphics g) {
        try {
            if (!this.prepareToDraw()) {
                return;
            }
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
            BugReport.intercept(e).put("center", this::getCenter).warn();
            return;
        }
        try {
            this.drawMapContent(g);
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
            throw BugReport.intercept(e).put("visibleLayers", this.layerManager::getVisibleLayersInZOrder).put("temporaryLayers", this.temporaryLayers);
        }
        super.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMapContent(Graphics g) {
        int i;
        Graphics2D g2;
        boolean canUseBuffer;
        Graphics2D gg = (Graphics2D)g;
        AffineTransform trOrig = gg.getTransform();
        double uiScaleX = gg.getTransform().getScaleX();
        double uiScaleY = gg.getTransform().getScaleY();
        int width = (int)Math.round((double)this.getWidth() * uiScaleX);
        int height = (int)Math.round((double)this.getHeight() * uiScaleY);
        AffineTransform trDef = AffineTransform.getScaleInstance(uiScaleX, uiScaleY);
        Shape scaledClip = trDef.createTransformedShape(g.getClip());
        List<Layer> visibleLayers = this.layerManager.getVisibleLayersInZOrder();
        int nonChangedLayersCount = 0;
        Set<MapViewPaintable> invalidated = this.invalidatedListener.collectInvalidatedLayers();
        for (Layer l : visibleLayers) {
            if (invalidated.contains(l)) break;
            ++nonChangedLayersCount;
        }
        boolean bl = canUseBuffer = !this.paintPreferencesChanged.getAndSet(false) && this.nonChangedLayers.size() <= nonChangedLayersCount && this.lastViewID == this.getViewID() && this.lastClipBounds.contains(g.getClipBounds()) && this.nonChangedLayers.equals(visibleLayers.subList(0, this.nonChangedLayers.size()));
        if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != width || this.offscreenBuffer.getHeight() != height) {
            this.offscreenBuffer = new BufferedImage(width, height, 5);
        }
        if (!canUseBuffer || this.nonChangedLayersBuffer == null) {
            if (null == this.nonChangedLayersBuffer || this.nonChangedLayersBuffer.getWidth() != width || this.nonChangedLayersBuffer.getHeight() != height) {
                this.nonChangedLayersBuffer = new BufferedImage(width, height, 5);
            }
            g2 = this.nonChangedLayersBuffer.createGraphics();
            g2.setClip(scaledClip);
            g2.setTransform(trDef);
            g2.setColor(PaintColors.getBackgroundColor());
            g2.fillRect(0, 0, width, height);
            for (i = 0; i < nonChangedLayersCount; ++i) {
                this.paintLayer(visibleLayers.get(i), g2);
            }
        } else if (this.nonChangedLayers.size() != nonChangedLayersCount) {
            g2 = this.nonChangedLayersBuffer.createGraphics();
            g2.setClip(scaledClip);
            g2.setTransform(trDef);
            for (i = this.nonChangedLayers.size(); i < nonChangedLayersCount; ++i) {
                this.paintLayer(visibleLayers.get(i), g2);
            }
        }
        this.nonChangedLayers.clear();
        this.nonChangedLayers.addAll(visibleLayers.subList(0, nonChangedLayersCount));
        this.lastViewID = this.getViewID();
        this.lastClipBounds = g.getClipBounds();
        Graphics2D tempG = this.offscreenBuffer.createGraphics();
        tempG.setClip(scaledClip);
        tempG.setTransform(new AffineTransform());
        tempG.drawImage((Image)this.nonChangedLayersBuffer, 0, 0, null);
        tempG.setTransform(trDef);
        for (i = nonChangedLayersCount; i < visibleLayers.size(); ++i) {
            this.paintLayer(visibleLayers.get(i), tempG);
        }
        try {
            this.drawTemporaryLayers(tempG, this.getLatLonBounds(new Rectangle((int)Math.round((double)g.getClipBounds().x * uiScaleX), (int)Math.round((double)g.getClipBounds().y * uiScaleY))));
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
            BugReport.intercept(e).put("temporaryLayers", this.temporaryLayers).warn();
        }
        try {
            this.drawWorldBorders(tempG);
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
            BugReport.intercept(e).put("bounds", () -> this.getProjection().getWorldBoundsLatLon()).warn();
        }
        MapFrame map = MainApplication.getMap();
        if (AutoFilterManager.getInstance().getCurrentAutoFilter() != null) {
            AutoFilterManager.getInstance().drawOSDText(tempG);
        } else if (MainApplication.isDisplayingMapView() && map.filterDialog != null) {
            map.filterDialog.drawOSDText(tempG);
        }
        if (this.playHeadMarker != null) {
            this.playHeadMarker.paint(tempG, this);
        }
        try {
            gg.setTransform(new AffineTransform(1.0, 0.0, 0.0, 1.0, trOrig.getTranslateX(), trOrig.getTranslateY()));
            gg.drawImage((Image)this.offscreenBuffer, 0, 0, null);
        }
        catch (ClassCastException e) {
            Logging.error(e);
        }
        finally {
            gg.setTransform(trOrig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawTemporaryLayers(Graphics2D tempG, Bounds box) {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            for (MapViewPaintable mvp : this.temporaryLayers) {
                try {
                    mvp.paint(tempG, this, box);
                }
                catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                    throw BugReport.intercept(e).put("mvp", mvp);
                }
            }
        }
    }

    private void drawWorldBorders(Graphics2D tempG) {
        tempG.setColor(Color.WHITE);
        Bounds b = this.getProjection().getWorldBoundsLatLon();
        int w = this.getWidth();
        int h = this.getHeight();
        Area border = this.getState().getArea(b);
        Area viewport = new Area(new Rectangle(-1, -1, w + 2, h + 2));
        border.intersect(viewport);
        tempG.draw(border);
    }

    public boolean prepareToDraw() {
        this.updateLocationState();
        if (this.initialViewport != null) {
            this.zoomTo(this.initialViewport);
            this.initialViewport = null;
        }
        if (this.getCenter() == null) {
            return false;
        }
        if (this.oldLoc != null && this.oldSize != null) {
            Point l1 = this.getLocationOnScreen();
            EastNorth newCenter = new EastNorth(this.getCenter().getX() + ((double)(l1.x - this.oldLoc.x) - (double)(this.oldSize.width - this.getWidth()) / 2.0) * this.getScale(), this.getCenter().getY() + ((double)(this.oldLoc.y - l1.y) + (double)(this.oldSize.height - this.getHeight()) / 2.0) * this.getScale());
            this.oldLoc = null;
            this.oldSize = null;
            this.zoomTo(newCenter);
        }
        return true;
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            for (AbstractButton abstractButton : map.allMapModeButtons) {
                MapMode mode = (MapMode)abstractButton.getAction();
                boolean activeLayerSupported = mode.layerIsSupported(this.layerManager.getActiveLayer());
                if (activeLayerSupported) {
                    MainApplication.registerActionShortcut(mode, mode.getShortcut());
                } else {
                    MainApplication.unregisterShortcut(mode.getShortcut());
                }
                abstractButton.setEnabled(activeLayerSupported);
            }
        }
        this.getLayerManager().getLayers().forEach(this.invalidatedListener::invalidate);
        AudioPlayer.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTemporaryLayer(MapViewPaintable mvp) {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            boolean added = this.temporaryLayers.add(mvp);
            if (added) {
                this.invalidatedListener.addTo(mvp);
            }
            this.repaint();
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTemporaryLayer(MapViewPaintable mvp) {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            boolean removed = this.temporaryLayers.remove(mvp);
            if (removed) {
                this.invalidatedListener.removeFrom(mvp);
            }
            this.repaint();
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MapViewPaintable> getTemporaryLayers() {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<MapViewPaintable>(this.temporaryLayers));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Layer l;
        if (evt.getPropertyName().equals(Layer.VISIBLE_PROP)) {
            this.repaint();
        } else if ((evt.getPropertyName().equals(Layer.OPACITY_PROP) || evt.getPropertyName().equals(Layer.FILTER_STATE_PROP)) && (l = (Layer)evt.getSource()).isVisible()) {
            this.invalidatedListener.invalidate(l);
        }
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        this.paintPreferencesChanged.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.layerManager.removeAndFireLayerChangeListener(this);
        this.layerManager.removeActiveLayerChangeListener(this);
        Config.getPref().removePreferenceChangeListener(this);
        SelectionEventManager.getInstance().removeSelectionListener(this.repaintSelectionChangedListener);
        MultipolygonCache.getInstance().clear();
        if (this.mapMover != null) {
            this.mapMover.destroy();
        }
        this.nonChangedLayers.clear();
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            this.temporaryLayers.clear();
        }
        this.nonChangedLayersBuffer = null;
        this.offscreenBuffer = null;
    }

    public String getLayerInformationForSourceTag() {
        TreeSet<String> layerInfo = new TreeSet<String>();
        if (!this.layerManager.getLayersOfType(GpxLayer.class).isEmpty()) {
            layerInfo.add("survey");
        }
        for (GeoImageLayer geoImageLayer : this.layerManager.getLayersOfType(GeoImageLayer.class)) {
            if (!geoImageLayer.isVisible()) continue;
            layerInfo.add(geoImageLayer.getName());
        }
        for (ImageryLayer imageryLayer : this.layerManager.getLayersOfType(ImageryLayer.class)) {
            if (!imageryLayer.isVisible()) continue;
            layerInfo.add(ImageryInfo.ImageryType.BING.equals((Object)imageryLayer.getInfo().getImageryType()) ? "Bing" : imageryLayer.getName());
        }
        return Utils.join("; ", layerInfo);
    }

    public void addRepaintListener(RepaintListener l) {
        this.repaintListeners.add(l);
    }

    public void removeRepaintListener(RepaintListener l) {
        this.repaintListeners.remove(l);
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        if (this.repaintListeners != null) {
            for (RepaintListener l : this.repaintListeners) {
                l.repaint(tm, x, y, width, height);
            }
        }
        super.repaint(tm, x, y, width, height);
    }

    @Override
    public void repaint() {
        if (Logging.isTraceEnabled()) {
            this.invalidatedListener.traceRandomRepaint();
        }
        super.repaint();
    }

    public final MainLayerManager getLayerManager() {
        return this.layerManager;
    }

    public void scheduleZoomTo(ViewportData viewportData) {
        this.initialViewport = viewportData;
    }

    public final MapMover getMapMover() {
        return this.mapMover;
    }

    static {
        MapPaintStyles.addMapPaintSylesUpdateListener(new MapPaintStyles.MapPaintSylesUpdateListener(){

            @Override
            public void mapPaintStylesUpdated() {
                SwingUtilities.invokeLater(() -> MainApplication.getLayerManager().getLayers().stream().filter(layer -> layer instanceof OsmDataLayer).forEach(AbstractMapViewPaintable::invalidate));
            }

            @Override
            public void mapPaintStyleEntryUpdated(int index) {
                this.mapPaintStylesUpdated();
            }
        });
    }

    @FunctionalInterface
    public static interface RepaintListener {
        public void repaint(long var1, int var3, int var4, int var5, int var6);
    }

    private static class WarningLayerPainter
    implements MapViewPaintable.LayerPainter {
        boolean warningPrinted;
        private final Layer layer;

        WarningLayerPainter(Layer layer) {
            this.layer = layer;
        }

        @Override
        public void paint(MapViewGraphics graphics) {
            if (!this.warningPrinted) {
                Logging.debug("A layer triggered a repaint while being added: " + this.layer);
                this.warningPrinted = true;
            }
        }

        @Override
        public void detachFromMapView(MapViewPaintable.MapViewEvent event) {
        }
    }

    private class LayerInvalidatedListener
    implements MapViewPaintable.PaintableInvalidationListener {
        private boolean ignoreRepaint;
        private final Set<MapViewPaintable> invalidatedLayers = Collections.newSetFromMap(new IdentityHashMap());

        private LayerInvalidatedListener() {
        }

        @Override
        public void paintableInvalidated(MapViewPaintable.PaintableInvalidationEvent event) {
            this.invalidate(event.getLayer());
        }

        public synchronized void invalidate(MapViewPaintable mapViewPaintable) {
            this.ignoreRepaint = true;
            this.invalidatedLayers.add(mapViewPaintable);
            MapView.this.repaint();
        }

        public synchronized void addTo(MapViewPaintable p) {
            p.addInvalidationListener(this);
        }

        public synchronized void removeFrom(MapViewPaintable p) {
            p.removeInvalidationListener(this);
            this.invalidatedLayers.remove(p);
        }

        protected synchronized void traceRandomRepaint() {
            if (!this.ignoreRepaint) {
                System.err.println("Repaint:");
                Thread.dumpStack();
            }
            this.ignoreRepaint = false;
        }

        protected synchronized Set<MapViewPaintable> collectInvalidatedLayers() {
            Set<MapViewPaintable> layers = Collections.newSetFromMap(new IdentityHashMap());
            layers.addAll(this.invalidatedLayers);
            this.invalidatedLayers.clear();
            return layers;
        }
    }
}

