/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ButtonModel;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.imagery.TileLoaderFactory;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.SizeButton;
import org.openstreetmap.josm.gui.bbox.SlippyMapControler;
import org.openstreetmap.josm.gui.bbox.SourceButton;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class SlippyMapBBoxChooser
extends JMapViewer
implements BBoxChooser,
ChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    private static CopyOnWriteArrayList<TileSourceProvider> providers = new CopyOnWriteArrayList();
    private static final StringProperty PROP_MAPSTYLE;
    private static final BooleanProperty PROP_SHOWDLAREA;
    public static final String RESIZE_PROP;
    private final transient TileLoader cachedLoader;
    private final transient OsmTileLoader uncachedLoader;
    private final SizeButton iSizeButton;
    private final ButtonModel showDownloadAreaButtonModel;
    private final SourceButton iSourceButton;
    private transient Bounds bbox;
    private transient ICoordinate iSelectionRectStart;
    private transient ICoordinate iSelectionRectEnd;

    public static void addTileSourceProvider(TileSourceProvider tileSourceProvider) {
        providers.addIfAbsent(tileSourceProvider);
    }

    public SlippyMapBBoxChooser() {
        debug = Logging.isDebugEnabled();
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", Version.getInstance().getFullAgentString());
        TileLoaderFactory cachedLoaderFactory = AbstractCachedTileSourceLayer.getTileLoaderFactory("TMS", TMSCachedTileLoader.class);
        this.cachedLoader = cachedLoaderFactory != null ? cachedLoaderFactory.makeTileLoader(this, headers) : null;
        this.uncachedLoader = new OsmTileLoader(this);
        this.uncachedLoader.headers.putAll(headers);
        this.setZoomContolsVisible(Config.getPref().getBoolean("slippy_map_chooser.zoomcontrols", false));
        this.setMapMarkerVisible(false);
        this.setMinimumSize(new Dimension(350, 175));
        this.setBounds(new Rectangle(this.getMinimumSize()));
        if (this.cachedLoader == null) {
            this.setFileCacheEnabled(false);
        } else {
            this.setFileCacheEnabled(Config.getPref().getBoolean("slippy_map_chooser.file_cache", true));
        }
        this.setMaxTilesInMemory(Config.getPref().getInt("slippy_map_chooser.max_tiles", 1000));
        List<TileSource> tileSources = SlippyMapBBoxChooser.getAllTileSources();
        this.showDownloadAreaButtonModel = new JToggleButton.ToggleButtonModel();
        this.showDownloadAreaButtonModel.setSelected(PROP_SHOWDLAREA.get());
        this.showDownloadAreaButtonModel.addChangeListener(this);
        this.iSourceButton = new SourceButton(this, tileSources, this.showDownloadAreaButtonModel);
        this.add(this.iSourceButton);
        springLayout.putConstraint("East", (Component)this.iSourceButton, -2, "East", (Component)this);
        springLayout.putConstraint("North", (Component)this.iSourceButton, 2, "North", (Component)this);
        this.iSizeButton = new SizeButton(this);
        this.add(this.iSizeButton);
        String mapStyle = PROP_MAPSTYLE.get();
        boolean foundSource = false;
        for (TileSource source : tileSources) {
            if (!source.getName().equals(mapStyle)) continue;
            this.setTileSource(source);
            this.iSourceButton.setCurrentMap(source);
            foundSource = true;
            break;
        }
        if (!foundSource) {
            this.setTileSource(tileSources.get(0));
            this.iSourceButton.setCurrentMap(tileSources.get(0));
        }
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
        new SlippyMapControler(this, this);
    }

    private static List<TileSource> getAllTileSources() {
        ArrayList<TileSource> tileSources = new ArrayList<TileSource>();
        for (TileSourceProvider provider : providers) {
            tileSources.addAll(provider.getTileSources());
        }
        return tileSources;
    }

    public boolean handleAttribution(Point p, boolean click) {
        return this.attribution.handleAttribution(p, click);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        if (editLayer != null && this.showDownloadAreaButtonModel.isSelected() && !editLayer.data.getDataSources().isEmpty()) {
            Rectangle b = this.getBounds();
            b.grow(100, 100);
            Path2D.Float p = new Path2D.Float();
            for (Bounds bounds : editLayer.data.getDataSourceBounds()) {
                if (bounds.isCollapsed()) continue;
                Rectangle r = new Rectangle(this.getMapPosition(bounds.getMinLat(), bounds.getMinLon(), false));
                r.add(this.getMapPosition(bounds.getMaxLat(), bounds.getMaxLon(), false));
                p.append(r, false);
            }
            Area a = new Area(b);
            a.subtract(new Area(p));
            g2d.setPaint(new Color(0, 0, 0, 32));
            g2d.fill(a);
        }
        if (this.iSelectionRectStart != null && this.iSelectionRectEnd != null) {
            Rectangle box = new Rectangle(this.getMapPosition(this.iSelectionRectStart, false));
            box.add(this.getMapPosition(this.iSelectionRectEnd, false));
            g.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
            g.fillRect(box.x, box.y, box.width, box.height);
            g.setColor(Color.BLACK);
            g.drawRect(box.x, box.y, box.width, box.height);
        }
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        PROP_SHOWDLAREA.put(this.showDownloadAreaButtonModel.isSelected());
        this.repaint();
    }

    public final void setFileCacheEnabled(boolean enabled) {
        if (enabled && this.cachedLoader != null) {
            this.setTileLoader(this.cachedLoader);
        } else {
            this.setTileLoader(this.uncachedLoader);
        }
    }

    public final void setMaxTilesInMemory(int tiles) {
        ((MemoryTileCache)this.getTileCache()).setCacheSize(tiles);
    }

    public void setSelection(Point aStart, Point aEnd) {
        if (aStart == null || aEnd == null || aStart.x == aEnd.x || aStart.y == aEnd.y) {
            return;
        }
        Point pMax = new Point(Math.max(aEnd.x, aStart.x), Math.max(aEnd.y, aStart.y));
        Point pMin = new Point(Math.min(aEnd.x, aStart.x), Math.min(aEnd.y, aStart.y));
        this.iSelectionRectStart = this.getPosition(pMin);
        this.iSelectionRectEnd = this.getPosition(pMax);
        Bounds b = new Bounds(new LatLon(Math.min(this.iSelectionRectStart.getLat(), this.iSelectionRectEnd.getLat()), LatLon.toIntervalLon(Math.min(this.iSelectionRectStart.getLon(), this.iSelectionRectEnd.getLon()))), new LatLon(Math.max(this.iSelectionRectStart.getLat(), this.iSelectionRectEnd.getLat()), LatLon.toIntervalLon(Math.max(this.iSelectionRectStart.getLon(), this.iSelectionRectEnd.getLon()))));
        Bounds oldValue = this.bbox;
        this.bbox = b;
        this.repaint();
        this.firePropertyChange(BBOX_PROP, oldValue, this.bbox);
    }

    public void resizeSlippyMap() {
        boolean large = this.iSizeButton.isEnlarged();
        this.firePropertyChange(RESIZE_PROP, !large, large);
    }

    public void toggleMapSource(TileSource tileSource) {
        this.tileController.setTileCache(new MemoryTileCache());
        this.setTileSource(tileSource);
        PROP_MAPSTYLE.put(tileSource.getName());
        if (this.iSourceButton.getCurrentSource() != tileSource) {
            this.iSourceButton.setCurrentMap(tileSource);
        }
    }

    @Override
    public Bounds getBoundingBox() {
        return this.bbox;
    }

    @Override
    public void setBoundingBox(Bounds bbox) {
        if (bbox == null || bbox.getMinLat() == 0.0 && bbox.getMinLon() == 0.0 && bbox.getMaxLat() == 0.0 && bbox.getMaxLon() == 0.0) {
            this.bbox = null;
            this.iSelectionRectStart = null;
            this.iSelectionRectEnd = null;
            this.repaint();
            return;
        }
        this.bbox = bbox;
        this.iSelectionRectStart = new Coordinate(bbox.getMinLat(), bbox.getMinLon());
        this.iSelectionRectEnd = new Coordinate(bbox.getMaxLat(), bbox.getMaxLon());
        MapMarkerDot min = new MapMarkerDot(bbox.getMinLat(), bbox.getMinLon());
        MapMarkerDot max = new MapMarkerDot(bbox.getMaxLat(), bbox.getMaxLon());
        ArrayList<MapMarker> marker = new ArrayList<MapMarker>(2);
        marker.add(min);
        marker.add(max);
        this.setMapMarkerList(marker);
        this.setDisplayToFitMapMarkers();
        this.zoomOut();
        this.repaint();
    }

    public void setSizeButtonVisible(boolean visible) {
        this.iSizeButton.setVisible(visible);
    }

    public final void refreshTileSources() {
        this.iSourceButton.setSources(SlippyMapBBoxChooser.getAllTileSources());
    }

    static {
        SlippyMapBBoxChooser.addTileSourceProvider(() -> Arrays.asList(new OsmTileSource.Mapnik()));
        SlippyMapBBoxChooser.addTileSourceProvider(new TMSTileSourceProvider());
        PROP_MAPSTYLE = new StringProperty("slippy_map_chooser.mapstyle", "Mapnik");
        PROP_SHOWDLAREA = new BooleanProperty("slippy_map_chooser.show_downloaded_area", true);
        RESIZE_PROP = SlippyMapBBoxChooser.class.getName() + ".resize";
    }

    public static class TMSTileSourceProvider
    implements TileSourceProvider {
        private static final Set<String> existingSlippyMapUrls = new HashSet<String>();

        @Override
        public List<TileSource> getTileSources() {
            if (!TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get().booleanValue()) {
                return Collections.emptyList();
            }
            ArrayList<TileSource> sources = new ArrayList<TileSource>();
            for (ImageryInfo info : ImageryLayerInfo.instance.getLayers()) {
                if (existingSlippyMapUrls.contains(info.getUrl())) continue;
                try {
                    AbstractTMSTileSource source = TMSLayer.getTileSourceStatic(info);
                    if (source == null) continue;
                    sources.add(source);
                }
                catch (IllegalArgumentException ex) {
                    Logging.warn(ex);
                    if (ex.getMessage() == null || ex.getMessage().isEmpty()) continue;
                    JOptionPane.showMessageDialog(Main.parent, ex.getMessage(), I18n.tr("Warning", new Object[0]), 2);
                }
            }
            return sources;
        }

        static {
            existingSlippyMapUrls.add("https://{switch:a,b,c}.tile.openstreetmap.org/{zoom}/{x}/{y}.png");
        }
    }

    @FunctionalInterface
    public static interface TileSourceProvider {
        public List<TileSource> getTileSources();
    }
}

