/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.dialogs.changeset.query.DateValidator;
import org.openstreetmap.josm.gui.dialogs.changeset.query.RestrictionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.TimeValidator;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class TimeRestrictionPanel
extends JPanel
implements RestrictionPanel {
    private final JRadioButton rbClosedAfter = new JRadioButton();
    private final JRadioButton rbClosedAfterAndCreatedBefore = new JRadioButton();
    private final JosmTextField tfClosedAfterDate1 = new JosmTextField();
    private transient DateValidator valClosedAfterDate1;
    private final JosmTextField tfClosedAfterTime1 = new JosmTextField();
    private transient TimeValidator valClosedAfterTime1;
    private final JosmTextField tfClosedAfterDate2 = new JosmTextField();
    private transient DateValidator valClosedAfterDate2;
    private final JosmTextField tfClosedAfterTime2 = new JosmTextField();
    private transient TimeValidator valClosedAfterTime2;
    private final JosmTextField tfCreatedBeforeDate = new JosmTextField();
    private transient DateValidator valCreatedBeforeDate;
    private final JosmTextField tfCreatedBeforeTime = new JosmTextField();
    private transient TimeValidator valCreatedBeforeTime;

    public TimeRestrictionPanel() {
        this.build();
    }

    protected JPanel buildClosedAfterInputPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        pnl.add((Component)new JLabel(I18n.tr("Date: ", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 0.7;
        pnl.add((Component)this.tfClosedAfterDate1, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterDate1);
        this.valClosedAfterDate1 = DateValidator.decorate(this.tfClosedAfterDate1);
        this.tfClosedAfterDate1.setToolTipText(this.valClosedAfterDate1.getStandardTooltipTextAsHtml());
        gc.gridx = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Time:", new Object[0])), gc);
        gc.gridx = 3;
        gc.weightx = 0.3;
        pnl.add((Component)this.tfClosedAfterTime1, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterTime1);
        this.valClosedAfterTime1 = TimeValidator.decorate(this.tfClosedAfterTime1);
        this.tfClosedAfterTime1.setToolTipText(this.valClosedAfterTime1.getStandardTooltipTextAsHtml());
        return pnl;
    }

    protected JPanel buildClosedAfterAndCreatedBeforeInputPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        pnl.add((Component)new JLabel(I18n.tr("Closed after - ", new Object[0])), gc);
        gc.gridx = 1;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        pnl.add((Component)new JLabel(I18n.tr("Date:", new Object[0])), gc);
        gc.gridx = 2;
        gc.weightx = 0.7;
        pnl.add((Component)this.tfClosedAfterDate2, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterDate2);
        this.valClosedAfterDate2 = DateValidator.decorate(this.tfClosedAfterDate2);
        this.tfClosedAfterDate2.setToolTipText(this.valClosedAfterDate2.getStandardTooltipTextAsHtml());
        gc.gridx = 3;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Time:", new Object[0])), gc);
        gc.gridx = 4;
        gc.weightx = 0.3;
        pnl.add((Component)this.tfClosedAfterTime2, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterTime2);
        this.valClosedAfterTime2 = TimeValidator.decorate(this.tfClosedAfterTime2);
        this.tfClosedAfterTime2.setToolTipText(this.valClosedAfterTime2.getStandardTooltipTextAsHtml());
        gc.gridy = 1;
        gc.gridx = 0;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        pnl.add((Component)new JLabel(I18n.tr("Created before - ", new Object[0])), gc);
        gc.gridx = 1;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        pnl.add((Component)new JLabel(I18n.tr("Date:", new Object[0])), gc);
        gc.gridx = 2;
        gc.weightx = 0.7;
        pnl.add((Component)this.tfCreatedBeforeDate, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfCreatedBeforeDate);
        this.valCreatedBeforeDate = DateValidator.decorate(this.tfCreatedBeforeDate);
        this.tfCreatedBeforeDate.setToolTipText(this.valCreatedBeforeDate.getStandardTooltipTextAsHtml());
        gc.gridx = 3;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Time:", new Object[0])), gc);
        gc.gridx = 4;
        gc.weightx = 0.3;
        pnl.add((Component)this.tfCreatedBeforeTime, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfCreatedBeforeTime);
        this.valCreatedBeforeTime = TimeValidator.decorate(this.tfCreatedBeforeTime);
        this.tfCreatedBeforeTime.setToolTipText(this.valCreatedBeforeDate.getStandardTooltipTextAsHtml());
        return pnl;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.gridx = 0;
        gc.fill = 2;
        gc.weightx = 0.0;
        this.add((Component)this.rbClosedAfter, gc);
        gc.gridx = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        this.add((Component)new JMultilineLabel(I18n.tr("Only changesets closed after the following date/time", new Object[0])), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        this.add((Component)this.buildClosedAfterInputPanel(), gc);
        gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.gridy = 2;
        gc.gridx = 0;
        gc.fill = 2;
        gc.weightx = 0.0;
        this.add((Component)this.rbClosedAfterAndCreatedBefore, gc);
        gc.gridx = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        this.add((Component)new JMultilineLabel(I18n.tr("Only changesets closed after and created before a specific date/time", new Object[0])), gc);
        gc.gridx = 1;
        gc.gridy = 3;
        gc.fill = 2;
        gc.weightx = 1.0;
        this.add((Component)this.buildClosedAfterAndCreatedBeforeInputPanel(), gc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbClosedAfter);
        bg.add(this.rbClosedAfterAndCreatedBefore);
        TimeRestrictionChangedHandler restrictionChangeHandler = new TimeRestrictionChangedHandler();
        this.rbClosedAfter.addItemListener(restrictionChangeHandler);
        this.rbClosedAfterAndCreatedBefore.addItemListener(restrictionChangeHandler);
        this.rbClosedAfter.setSelected(true);
    }

    @Override
    public boolean isValidChangesetQuery() {
        if (this.rbClosedAfter.isSelected()) {
            return this.valClosedAfterDate1.isValid() && this.valClosedAfterTime1.isValid();
        }
        if (this.rbClosedAfterAndCreatedBefore.isSelected()) {
            return this.valClosedAfterDate2.isValid() && this.valClosedAfterTime2.isValid() && this.valCreatedBeforeDate.isValid() && this.valCreatedBeforeTime.isValid();
        }
        return true;
    }

    public void startUserInput() {
        this.restoreFromSettings();
    }

    @Override
    public void fillInQuery(ChangesetQuery query) {
        if (!this.isValidChangesetQuery()) {
            throw new IllegalStateException(I18n.tr("Cannot build changeset query with time based restrictions. Input is not valid.", new Object[0]));
        }
        if (this.rbClosedAfter.isSelected()) {
            LocalDate d1 = this.valClosedAfterDate1.getDate();
            LocalTime d2 = this.valClosedAfterTime1.getTime();
            Date d3 = new Date(d1.atTime(d2).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            query.closedAfter(d3);
        } else if (this.rbClosedAfterAndCreatedBefore.isSelected()) {
            LocalDate d1 = this.valClosedAfterDate2.getDate();
            LocalTime d2 = this.valClosedAfterTime2.getTime();
            Date d3 = new Date(d1.atTime(d2).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            d1 = this.valCreatedBeforeDate.getDate();
            d2 = this.valCreatedBeforeTime.getTime();
            Date d4 = new Date(d1.atTime(d2).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            query.closedAfterAndCreatedBefore(d3, d4);
        }
    }

    @Override
    public void displayMessageIfInvalid() {
        if (this.isValidChangesetQuery()) {
            return;
        }
        HelpAwareOptionPane.showOptionDialog(this, I18n.tr("<html>Please enter valid date/time values to restrict<br>the query to a specific time range.</html>", new Object[0]), I18n.tr("Invalid date/time values", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidDateTimeValues"));
    }

    public void rememberSettings() {
        String prefRoot = "changeset-query.advanced.time-restrictions";
        if (this.rbClosedAfter.isSelected()) {
            Config.getPref().put(prefRoot + ".query-type", "closed-after");
        } else if (this.rbClosedAfterAndCreatedBefore.isSelected()) {
            Config.getPref().put(prefRoot + ".query-type", "closed-after-created-before");
        }
        Config.getPref().put(prefRoot + ".closed-after.date", this.tfClosedAfterDate1.getText());
        Config.getPref().put(prefRoot + ".closed-after.time", this.tfClosedAfterTime1.getText());
        Config.getPref().put(prefRoot + ".closed-created.closed.date", this.tfClosedAfterDate2.getText());
        Config.getPref().put(prefRoot + ".closed-created.closed.time", this.tfClosedAfterTime2.getText());
        Config.getPref().put(prefRoot + ".closed-created.created.date", this.tfCreatedBeforeDate.getText());
        Config.getPref().put(prefRoot + ".closed-created.created.time", this.tfCreatedBeforeTime.getText());
    }

    public void restoreFromSettings() {
        String prefRoot = "changeset-query.advanced.open-restrictions";
        String v = Config.getPref().get(prefRoot + ".query-type", "closed-after");
        this.rbClosedAfter.setSelected("closed-after".equals(v));
        this.rbClosedAfterAndCreatedBefore.setSelected("closed-after-created-before".equals(v));
        if (!this.rbClosedAfter.isSelected() && !this.rbClosedAfterAndCreatedBefore.isSelected()) {
            this.rbClosedAfter.setSelected(true);
        }
        this.tfClosedAfterDate1.setText(Config.getPref().get(prefRoot + ".closed-after.date", ""));
        this.tfClosedAfterTime1.setText(Config.getPref().get(prefRoot + ".closed-after.time", ""));
        this.tfClosedAfterDate2.setText(Config.getPref().get(prefRoot + ".closed-created.closed.date", ""));
        this.tfClosedAfterTime2.setText(Config.getPref().get(prefRoot + ".closed-created.closed.time", ""));
        this.tfCreatedBeforeDate.setText(Config.getPref().get(prefRoot + ".closed-created.created.date", ""));
        this.tfCreatedBeforeTime.setText(Config.getPref().get(prefRoot + ".closed-created.created.time", ""));
        if (!this.valClosedAfterDate1.isValid()) {
            this.tfClosedAfterDate1.setText("");
        }
        if (!this.valClosedAfterTime1.isValid()) {
            this.tfClosedAfterTime1.setText("");
        }
        if (!this.valClosedAfterDate2.isValid()) {
            this.tfClosedAfterDate2.setText("");
        }
        if (!this.valClosedAfterTime2.isValid()) {
            this.tfClosedAfterTime2.setText("");
        }
        if (!this.valCreatedBeforeDate.isValid()) {
            this.tfCreatedBeforeDate.setText("");
        }
        if (!this.valCreatedBeforeTime.isValid()) {
            this.tfCreatedBeforeTime.setText("");
        }
    }

    class TimeRestrictionChangedHandler
    implements ItemListener {
        TimeRestrictionChangedHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            TimeRestrictionPanel.this.tfClosedAfterDate1.setEnabled(TimeRestrictionPanel.this.rbClosedAfter.isSelected());
            TimeRestrictionPanel.this.tfClosedAfterTime1.setEnabled(TimeRestrictionPanel.this.rbClosedAfter.isSelected());
            TimeRestrictionPanel.this.tfClosedAfterDate2.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
            TimeRestrictionPanel.this.tfClosedAfterTime2.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
            TimeRestrictionPanel.this.tfCreatedBeforeDate.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
            TimeRestrictionPanel.this.tfCreatedBeforeTime.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
        }
    }
}

