/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTable;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryViewerPanel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TagInfoTransferHandler;
import org.openstreetmap.josm.gui.history.TagTableColumnModel;

public class TagInfoViewer
extends HistoryViewerPanel {
    public TagInfoViewer(HistoryBrowserModel model) {
        super(model);
    }

    @Override
    protected JTable buildReferenceTable() {
        JTable table = new JTable(this.model.getTagTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME), new TagTableColumnModel());
        table.setName("table.referencetagtable");
        this.setUpDataTransfer(table);
        return table;
    }

    @Override
    protected JTable buildCurrentTable() {
        JTable table = new JTable(this.model.getTagTableModel(PointInTimeType.CURRENT_POINT_IN_TIME), new TagTableColumnModel());
        table.setName("table.currenttagtable");
        this.setUpDataTransfer(table);
        return table;
    }

    private void setUpDataTransfer(JTable table) {
        table.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        table.setTransferHandler(new TagInfoTransferHandler());
        table.addFocusListener(new RepaintOnFocusChange());
    }

    private static final class RepaintOnFocusChange
    implements FocusListener {
        private RepaintOnFocusChange() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            RepaintOnFocusChange.repaintSelected(e);
        }

        @Override
        public void focusGained(FocusEvent e) {
            RepaintOnFocusChange.repaintSelected(e);
        }

        private static void repaintSelected(FocusEvent e) {
            e.getComponent().repaint();
        }
    }
}

