/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.Extensions;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.CustomizeColor;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.gpx.ConvertToDataLayerAction;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class MarkerLayer
extends Layer
implements JumpToMarkerActions.JumpToMarkerLayer {
    public final List<Marker> data;
    private boolean mousePressed;
    public GpxLayer fromLayer;
    private Marker currentMarker;
    public AudioMarker syncAudioMarker;
    private static final Color DEFAULT_COLOR = Color.magenta;
    private static final NamedColorProperty COLOR_PROPERTY = new NamedColorProperty(I18n.marktr("gps marker"), DEFAULT_COLOR);

    public MarkerLayer(GpxData indata, String name, File associatedFile, GpxLayer fromLayer) {
        super(name);
        this.setAssociatedFile(associatedFile);
        this.data = new ArrayList<Marker>();
        this.fromLayer = fromLayer;
        double firstTime = -1.0;
        String lastLinkedFile = "";
        for (WayPoint wpt : indata.waypoints) {
            Collection<Marker> markers;
            double time = wpt.time;
            boolean wptHasLink = wpt.attr.containsKey("meta.links");
            if (firstTime < 0.0 && wptHasLink) {
                firstTime = time;
                Iterator iterator = wpt.getCollection("meta.links").iterator();
                if (iterator.hasNext()) {
                    GpxLink oneLink = (GpxLink)iterator.next();
                    lastLinkedFile = oneLink.uri;
                }
            }
            if (wptHasLink) {
                for (GpxLink oneLink : wpt.getCollection("meta.links")) {
                    String uri = oneLink.uri;
                    if (uri == null) continue;
                    if (!uri.equals(lastLinkedFile)) {
                        firstTime = time;
                    }
                    lastLinkedFile = uri;
                    break;
                }
            }
            Double offset = null;
            Extensions exts = (Extensions)wpt.get("meta.extensions");
            if (exts != null && exts.containsKey("offset")) {
                try {
                    offset = Double.valueOf((String)exts.get("offset"));
                }
                catch (NumberFormatException nfe) {
                    Logging.warn(nfe);
                }
            }
            if (offset == null) {
                offset = time - firstTime;
            }
            if ((markers = Marker.createMarkers(wpt, indata.storageFile, this, time, offset)) == null) continue;
            this.data.addAll(markers);
        }
    }

    @Override
    public MapViewPaintable.LayerPainter attachToMapView(MapViewPaintable.MapViewEvent event) {
        event.getMapView().addMouseListener(new MarkerMouseAdapter());
        if (event.getMapView().playHeadMarker == null) {
            event.getMapView().playHeadMarker = PlayHeadMarker.create();
        }
        return super.attachToMapView(event);
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "marker_small");
    }

    @Override
    protected NamedColorProperty getBaseColorProperty() {
        return COLOR_PROPERTY;
    }

    public static Color getGenericColor() {
        return COLOR_PROPERTY.get();
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        boolean showTextOrIcon = this.isTextOrIconShown();
        g.setColor(this.getColorProperty().get());
        if (this.mousePressed) {
            boolean mousePressedTmp = this.mousePressed;
            Point mousePos = mv.getMousePosition();
            for (Marker mkr : this.data) {
                if (mousePos == null || !mkr.containsPoint(mousePos)) continue;
                mkr.paint(g, mv, mousePressedTmp, showTextOrIcon);
                mousePressedTmp = false;
            }
        } else {
            for (Marker mkr : this.data) {
                mkr.paint(g, mv, false, showTextOrIcon);
            }
        }
    }

    @Override
    public String getToolTipText() {
        return Integer.toString(this.data.size()) + ' ' + I18n.trn("marker", "markers", this.data.size(), new Object[0]);
    }

    @Override
    public void mergeFrom(Layer from) {
        if (from instanceof MarkerLayer) {
            this.data.addAll(((MarkerLayer)from).data);
            this.data.sort(Comparator.comparingDouble(o -> o.time));
        }
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof MarkerLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Marker mkr : this.data) {
            v.visit(mkr);
        }
    }

    @Override
    public Object getInfoComponent() {
        return "<html>" + I18n.trn("{0} consists of {1} marker", "{0} consists of {1} markers", this.data.size(), Utils.escapeReservedCharactersHTML(this.getName()), this.data.size()) + "</html>";
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<AbstractAction> components = new ArrayList<AbstractAction>();
        components.add(LayerListDialog.getInstance().createShowHideLayerAction());
        components.add(new ShowHideMarkerText(this));
        components.add(LayerListDialog.getInstance().createDeleteLayerAction());
        components.add(LayerListDialog.getInstance().createMergeLayerAction(this));
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new CustomizeColor(this));
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new SynchronizeAudio());
        if (Config.getPref().getBoolean("marker.traceaudio", true)) {
            components.add(new MoveAudio());
        }
        components.add(new JumpToMarkerActions.JumpToNextMarker(this));
        components.add(new JumpToMarkerActions.JumpToPreviousMarker(this));
        components.add(new ConvertToDataLayerAction.FromMarkerLayer(this));
        components.add(new RenameLayerAction(this.getAssociatedFile(), this));
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new LayerListPopup.InfoAction(this));
        return components.toArray(new Action[components.size()]);
    }

    public boolean synchronizeAudioMarkers(AudioMarker startMarker) {
        this.syncAudioMarker = startMarker;
        if (this.syncAudioMarker != null && !this.data.contains(this.syncAudioMarker)) {
            this.syncAudioMarker = null;
        }
        if (this.syncAudioMarker == null) {
            for (Marker m : this.data) {
                if (!(m instanceof AudioMarker)) continue;
                this.syncAudioMarker = (AudioMarker)m;
                break;
            }
        }
        if (this.syncAudioMarker == null) {
            return false;
        }
        double adjustment = AudioPlayer.position() - this.syncAudioMarker.offset;
        boolean seenStart = false;
        try {
            URI uri = this.syncAudioMarker.url().toURI();
            for (Marker m : this.data) {
                AudioMarker ma;
                if (m == this.syncAudioMarker) {
                    seenStart = true;
                }
                if (!seenStart || !(m instanceof AudioMarker) || !(ma = (AudioMarker)m).url().toURI().equals(uri)) continue;
                ma.adjustOffset(adjustment);
            }
        }
        catch (URISyntaxException e) {
            Logging.warn(e);
        }
        return true;
    }

    public AudioMarker addAudioMarker(double time, LatLon coor) {
        double offset = 0.0;
        AudioMarker am = null;
        for (Marker m : this.data) {
            if (m.getClass() != AudioMarker.class) continue;
            am = (AudioMarker)m;
            offset = time - am.time;
            break;
        }
        if (am == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No existing audio markers in this layer to offset from.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            return null;
        }
        AudioMarker newAudioMarker = new AudioMarker(coor, null, AudioPlayer.url(), this, time, offset);
        ArrayList<Marker> newData = new ArrayList<Marker>();
        am = null;
        AudioMarker ret = newAudioMarker;
        for (Marker m : this.data) {
            if (m.getClass() == AudioMarker.class) {
                am = (AudioMarker)m;
                if (newAudioMarker != null && offset < am.offset) {
                    newAudioMarker.adjustOffset(am.syncOffset());
                    newData.add(newAudioMarker);
                    newAudioMarker = null;
                }
            }
            newData.add(m);
        }
        if (newAudioMarker != null) {
            if (am != null) {
                newAudioMarker.adjustOffset(am.syncOffset());
            }
            newData.add(newAudioMarker);
        }
        this.data.clear();
        this.data.addAll(newData);
        return ret;
    }

    @Override
    public void jumpToNextMarker() {
        if (this.currentMarker == null) {
            this.currentMarker = this.data.get(0);
        } else {
            boolean foundCurrent = false;
            for (Marker m : this.data) {
                if (foundCurrent) {
                    this.currentMarker = m;
                    break;
                }
                if (this.currentMarker != m) continue;
                foundCurrent = true;
            }
        }
        MainApplication.getMap().mapView.zoomTo(this.currentMarker);
    }

    @Override
    public void jumpToPreviousMarker() {
        if (this.currentMarker == null) {
            this.currentMarker = this.data.get(this.data.size() - 1);
        } else {
            boolean foundCurrent = false;
            for (int i = this.data.size() - 1; i >= 0; --i) {
                Marker m = this.data.get(i);
                if (foundCurrent) {
                    this.currentMarker = m;
                    break;
                }
                if (this.currentMarker != m) continue;
                foundCurrent = true;
            }
        }
        MainApplication.getMap().mapView.zoomTo(this.currentMarker);
    }

    public static void playAudio() {
        MarkerLayer.playAdjacentMarker(null, true);
    }

    public static void playNextMarker() {
        MarkerLayer.playAdjacentMarker(AudioMarker.recentlyPlayedMarker(), true);
    }

    public static void playPreviousMarker() {
        MarkerLayer.playAdjacentMarker(AudioMarker.recentlyPlayedMarker(), false);
    }

    private static Marker getAdjacentMarker(Marker startMarker, boolean next, Layer layer) {
        Marker previousMarker = null;
        boolean nextTime = false;
        if (layer.getClass() == MarkerLayer.class) {
            MarkerLayer markerLayer = (MarkerLayer)layer;
            for (Marker marker : markerLayer.data) {
                if (marker == startMarker) {
                    if (next) {
                        nextTime = true;
                        continue;
                    }
                    if (previousMarker == null) {
                        previousMarker = startMarker;
                    }
                    return previousMarker;
                }
                if (marker.getClass() != AudioMarker.class) continue;
                if (nextTime || startMarker == null) {
                    return marker;
                }
                previousMarker = marker;
            }
            if (nextTime) {
                return startMarker;
            }
        }
        return null;
    }

    private static void playAdjacentMarker(Marker startMarker, boolean next) {
        if (!MainApplication.isDisplayingMapView()) {
            return;
        }
        Marker m = null;
        Layer l = MainApplication.getLayerManager().getActiveLayer();
        if (l != null) {
            m = MarkerLayer.getAdjacentMarker(startMarker, next, l);
        }
        if (m == null) {
            Layer layer;
            Iterator<Layer> iterator = MainApplication.getLayerManager().getLayers().iterator();
            while (iterator.hasNext() && (m = MarkerLayer.getAdjacentMarker(startMarker, next, layer = iterator.next())) == null) {
            }
        }
        if (m != null) {
            ((AudioMarker)m).play();
        }
    }

    private boolean isTextOrIconShown() {
        String current = Config.getPref().get("marker.show " + this.getName(), "show");
        return "show".equalsIgnoreCase(current);
    }

    private class MoveAudio
    extends AbstractAction {
        MoveAudio() {
            super(I18n.tr("Make Audio Marker at Play Head", new Object[0]));
            new ImageProvider("addmarkers").getResource().attachImageIcon(this, true);
            this.putValue("help", HelpUtil.ht("/Action/MakeAudioMarkerAtPlayHead"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AudioPlayer.paused()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to have paused audio at the point on the track where you want the marker.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            PlayHeadMarker playHeadMarker = MainApplication.getMap().mapView.playHeadMarker;
            if (playHeadMarker == null) {
                return;
            }
            MarkerLayer.this.addAudioMarker(playHeadMarker.time, playHeadMarker.getCoor());
            MarkerLayer.this.invalidate();
        }
    }

    private class SynchronizeAudio
    extends AbstractAction {
        SynchronizeAudio() {
            super(I18n.tr("Synchronize Audio", new Object[0]));
            new ImageProvider("audio-sync").getResource().attachImageIcon(this, true);
            this.putValue("help", HelpUtil.ht("/Action/SynchronizeAudio"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AudioPlayer.paused()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to pause audio at the moment when you hear your synchronization cue.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            AudioMarker recent = AudioMarker.recentlyPlayedMarker();
            if (MarkerLayer.this.synchronizeAudioMarkers(recent)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Audio synchronized at point {0}.", MarkerLayer.this.syncAudioMarker.getText()), I18n.tr("Information", new Object[0]), 1);
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unable to synchronize in layer being played.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    public static final class ShowHideMarkerText
    extends AbstractAction
    implements Layer.LayerAction {
        private final transient MarkerLayer layer;

        public ShowHideMarkerText(MarkerLayer layer) {
            super(I18n.tr("Show Text/Icons", new Object[0]));
            new ImageProvider("dialogs", "showhide").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Toggle visible state of the marker text and icons.", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Action/ShowHideTextIcons"));
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Config.getPref().put("marker.show " + this.layer.getName(), this.layer.isTextOrIconShown() ? "hide" : "show");
            this.layer.invalidate();
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem showMarkerTextItem = new JCheckBoxMenuItem(this);
            showMarkerTextItem.setState(this.layer.isTextOrIconShown());
            return showMarkerTextItem;
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return layers.size() == 1 && layers.get(0) instanceof MarkerLayer;
        }
    }

    private final class MarkerMouseAdapter
    extends MouseAdapter {
        private MarkerMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            boolean mousePressedInButton = false;
            for (Marker mkr : MarkerLayer.this.data) {
                if (!mkr.containsPoint(e.getPoint())) continue;
                mousePressedInButton = true;
                break;
            }
            if (!mousePressedInButton) {
                return;
            }
            MarkerLayer.this.mousePressed = true;
            if (MarkerLayer.this.isVisible()) {
                MarkerLayer.this.invalidate();
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (ev.getButton() != 1 || !MarkerLayer.this.mousePressed) {
                return;
            }
            MarkerLayer.this.mousePressed = false;
            if (!MarkerLayer.this.isVisible()) {
                return;
            }
            for (Marker mkr : MarkerLayer.this.data) {
                if (!mkr.containsPoint(ev.getPoint())) continue;
                mkr.actionPerformed(new ActionEvent(this, 0, null));
            }
            MarkerLayer.this.invalidate();
        }
    }
}

