/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.text.MessageFormat;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public final class CheckParameterUtil {
    private CheckParameterUtil() {
    }

    public static <T> void ensure(T obj, String parameterName, String conditionMsg, Predicate<T> condition) {
        CheckParameterUtil.ensureParameterNotNull(obj, parameterName);
        if (!condition.test(obj)) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter value ''{0}'' of type {1} is invalid, violated condition: ''{2}'', got ''{3}''", parameterName, obj.getClass().getCanonicalName(), conditionMsg, obj));
        }
    }

    public static <T> void ensure(T obj, String parameterName, Predicate<T> condition) {
        CheckParameterUtil.ensureParameterNotNull(obj, parameterName);
        if (!condition.test(obj)) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter value ''{0}'' of type {1} is invalid, got ''{2}''", parameterName, obj.getClass().getCanonicalName(), obj));
        }
    }

    @Deprecated
    public static void ensureValidPrimitiveId(PrimitiveId id, String parameterName) {
        CheckParameterUtil.ensureParameterNotNull(id, parameterName);
        if (id.getUniqueId() <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected unique id > 0 for primitive ''{1}'', got {0}", id.getUniqueId(), parameterName));
        }
    }

    @Deprecated
    public static void ensureValidCoordinates(LatLon latlon, String parameterName) {
        CheckParameterUtil.ensureParameterNotNull(latlon, parameterName);
        if (!latlon.isValid()) {
            throw new IllegalArgumentException(MessageFormat.format("Expected valid lat/lon for parameter ''{0}'', got {1}", parameterName, latlon));
        }
    }

    @Deprecated
    public static void ensureValidCoordinates(EastNorth eastnorth, String parameterName) {
        CheckParameterUtil.ensureParameterNotNull(eastnorth, parameterName);
        if (!eastnorth.isValid()) {
            throw new IllegalArgumentException(MessageFormat.format("Expected valid east/north for parameter ''{0}'', got {1}", parameterName, eastnorth));
        }
    }

    @Deprecated
    public static void ensureValidVersion(long version, String parameterName) {
        if (version < 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value of type long > 0 for parameter ''{0}'', got {1}", parameterName, version));
        }
    }

    public static void ensureParameterNotNull(Object value, String parameterName) {
        if (value == null) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' must not be null", parameterName));
        }
    }

    public static void ensureParameterNotNull(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
    }

    public static void ensureThat(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void ensureThat(boolean condition, Supplier<String> messageSupplier) {
        if (!condition) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
    }

    @Deprecated
    public static void ensureValidNodeId(PrimitiveId id, String parameterName) {
        CheckParameterUtil.ensureParameterNotNull(id, parameterName);
        if (!id.getType().equals((Object)OsmPrimitiveType.NODE)) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' of type node expected, got ''{1}''", parameterName, id.getType().getAPIName()));
        }
    }
}

