/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnchorElementInfo
extends SelfElementInfo {
    private volatile long myStubElementTypeAndId;

    AnchorElementInfo(@NotNull PsiElement anchor2, @NotNull PsiFile containingFile, Identikit.ByAnchor identikit) {
        if (anchor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        super(containingFile.getProject(), ProperTextRange.create(anchor2.getTextRange()), identikit, containingFile, false);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    AnchorElementInfo(@NotNull PsiElement anchor2, @NotNull PsiFileWithStubSupport containingFile, int stubId, @NotNull IStubElementType stubElementType) {
        if (anchor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (stubElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubElementType", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        super(containingFile.getProject(), null, Identikit.fromTypes(anchor2.getClass(), stubElementType, LanguageUtil.getRootLanguage(containingFile)), containingFile, false);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(stubId, stubElementType);
        assert (!(anchor2 instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor2;
    }

    private static long pack(int stubId, IStubElementType stubElementType) {
        short index2;
        short s = index2 = stubElementType == null ? (short)0 : stubElementType.getIndex();
        assert (index2 >= 0) : "Unregistered token types not allowed here: " + stubElementType;
        return (long)stubId | (long)index2 << 32;
    }

    private int getStubId() {
        return (int)this.myStubElementTypeAndId;
    }

    @Override
    @Nullable
    public PsiElement restoreElement() {
        long typeAndId = this.myStubElementTypeAndId;
        int stubId = (int)typeAndId;
        if (stubId != -1) {
            PsiFile file = this.restoreFile();
            if (!(file instanceof PsiFileWithStubSupport)) {
                return null;
            }
            short index2 = (short)(typeAndId >> 32);
            IStubElementType stubElementType = (IStubElementType)IElementType.find(index2);
            return PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)file, stubId, stubElementType, false);
        }
        return super.restoreElement();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof AnchorElementInfo) {
            if (!this.getVirtualFile().equals(other.getVirtualFile())) {
                return false;
            }
            long packed1 = this.myStubElementTypeAndId;
            long packed2 = ((AnchorElementInfo)other).myStubElementTypeAndId;
            if (packed1 != -1L && packed2 != -1L) {
                return packed1 == packed2;
            }
            if (packed1 != -1L || packed2 != -1L) {
                return ReadAction.compute(() -> {
                    if (other == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "lambda$pointsToTheSameElementAs$0"));
                    }
                    return Comparing.equal(this.restoreElement(), other.restoreElement());
                });
            }
        }
        return super.pointsToTheSameElementAs(other);
    }

    @Override
    public void fastenBelt() {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        super.fastenBelt();
    }

    private void switchToTree() {
        PsiElement element = this.restoreElement();
        SmartPointerTracker tracker = this.myManager.getTracker(this.getVirtualFile());
        if (element != null && tracker != null) {
            tracker.switchStubToAst(this, element);
        }
    }

    void switchToTreeRange(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/AnchorElementInfo", "switchToTreeRange"));
        }
        this.switchToAnchor(element);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    @Override
    public Segment getRange() {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        return super.getRange();
    }

    @Override
    @Nullable
    public TextRange getPsiRange() {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        return super.getPsiRange();
    }

    @Override
    public String toString() {
        return super.toString() + ",stubId=" + this.getStubId();
    }
}

