/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.components.fields.IntegerField;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class SmartIndentOptionsEditor
extends IndentOptionsEditor {
    public static final String CONTINUATION_INDENT_LABEL = ApplicationBundle.message("editbox.indent.continuation.indent", new Object[0]);
    private JCheckBox myCbSmartTabs;
    private IntegerField myContinuationIndentField;
    private JLabel myContinuationIndentLabel;
    private JCheckBox myCbKeepIndentsOnEmptyLines;

    @Override
    protected void addTabOptions() {
        super.addTabOptions();
        this.myCbSmartTabs = new JCheckBox(ApplicationBundle.message("checkbox.indent.smart.tabs", new Object[0]));
        this.add((JComponent)this.myCbSmartTabs, true);
    }

    @Override
    protected void addComponents() {
        super.addComponents();
        this.myContinuationIndentField = this.createIndentTextField(CONTINUATION_INDENT_LABEL, 0, 16, 8);
        this.myContinuationIndentLabel = new JLabel(CONTINUATION_INDENT_LABEL);
        this.add((JComponent)this.myContinuationIndentLabel, this.myContinuationIndentField);
        this.myCbKeepIndentsOnEmptyLines = new JCheckBox(ApplicationBundle.message("checkbox.indent.keep.indents.on.empty.lines", new Object[0]));
        this.add(this.myCbKeepIndentsOnEmptyLines);
    }

    @Override
    public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        boolean isModified = super.isModified(settings, options);
        isModified |= SmartIndentOptionsEditor.isFieldModified(this.myCbSmartTabs, options.SMART_TABS);
        isModified |= SmartIndentOptionsEditor.isFieldModified(this.myContinuationIndentField, options.CONTINUATION_INDENT_SIZE);
        return isModified |= SmartIndentOptionsEditor.isFieldModified(this.myCbKeepIndentsOnEmptyLines, options.KEEP_INDENTS_ON_EMPTY_LINES);
    }

    @Override
    public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        super.apply(settings, options);
        options.CONTINUATION_INDENT_SIZE = this.myContinuationIndentField.getValue();
        options.SMART_TABS = SmartIndentOptionsEditor.isSmartTabValid(options.INDENT_SIZE, options.TAB_SIZE) && this.myCbSmartTabs.isSelected();
        options.KEEP_INDENTS_ON_EMPTY_LINES = this.myCbKeepIndentsOnEmptyLines.isSelected();
    }

    @Override
    public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (settings == null) {
            SmartIndentOptionsEditor.$$$reportNull$$$0(0);
        }
        if (options == null) {
            SmartIndentOptionsEditor.$$$reportNull$$$0(1);
        }
        super.reset(settings, options);
        this.myContinuationIndentField.setValue(options.CONTINUATION_INDENT_SIZE);
        this.myCbSmartTabs.setSelected(options.SMART_TABS);
        this.myCbKeepIndentsOnEmptyLines.setSelected(options.KEEP_INDENTS_ON_EMPTY_LINES);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean smartTabsChecked = enabled && this.myCbUseTab.isSelected();
        boolean smartTabsValid = smartTabsChecked && SmartIndentOptionsEditor.isSmartTabValid(this.getUIIndent(), this.getUITabSize());
        this.myCbSmartTabs.setEnabled(smartTabsValid);
        this.myCbSmartTabs.setToolTipText(smartTabsChecked && !smartTabsValid ? ApplicationBundle.message("tooltip.indent.must.be.multiple.of.tab.size.for.smart.tabs.to.operate", new Object[0]) : null);
        this.myContinuationIndentField.setEnabled(enabled);
        this.myContinuationIndentLabel.setEnabled(enabled);
    }

    private static boolean isSmartTabValid(int indent, int tabSize) {
        return indent / tabSize * tabSize == indent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "options";
                break;
            }
        }
        objectArray[1] = "com/intellij/application/options/SmartIndentOptionsEditor";
        objectArray[2] = "reset";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

