/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ColorConverter;
import com.intellij.util.Matrix;
import com.intellij.util.Vector;

final class MatrixConverter
extends ColorConverter {
    private final Double myWeight;
    private final Matrix myMatrix;

    public MatrixConverter(Matrix matrix) {
        this(null, matrix);
    }

    public MatrixConverter(Double weight, Matrix matrix) {
        if (!(weight == null || 0.0 < weight && weight < 1.0)) {
            throw new IllegalArgumentException("unsupported weight");
        }
        int rows = matrix.getRows();
        if (rows != 3 && rows != 4) {
            throw new IllegalArgumentException("unsupported rows");
        }
        int columns = matrix.getColumns();
        if (columns != 3 && columns != 4) {
            throw new IllegalArgumentException("unsupported columns");
        }
        this.myWeight = weight;
        this.myMatrix = matrix;
    }

    @Override
    public int convert(int red, int green, int blue, int alpha) {
        Vector vector = this.myMatrix.getRows() == 4 ? Vector.create((double[])new double[]{red, green, blue, alpha}) : Vector.create((double[])new double[]{red, green, blue});
        Vector result = vector.multiply(this.myMatrix);
        if (this.myWeight != null) {
            if (vector.getSize() != result.getSize()) {
                vector = result.getSize() == 4 ? Vector.create((double[])new double[]{red, green, blue, alpha}) : Vector.create((double[])new double[]{red, green, blue});
            }
            vector = vector.multiply(1.0 - this.myWeight);
            result = result.multiply(this.myWeight.doubleValue()).plus(vector);
        }
        red = (int)result.get(0);
        green = (int)result.get(1);
        blue = (int)result.get(2);
        if (result.getSize() == 4) {
            alpha = (int)result.get(3);
        }
        return super.convert(red, green, blue, alpha);
    }
}

