/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionRule
implements Cloneable {
    @Nullable
    private final String myStartComment;
    @Nullable
    private final String myEndComment;
    private final List<StdArrangementMatchRule> myMatchRules;

    private ArrangementSectionRule(@Nullable String start, @Nullable String end, @NotNull List<StdArrangementMatchRule> rules) {
        if (rules == null) {
            ArrangementSectionRule.$$$reportNull$$$0(0);
        }
        this.myStartComment = start;
        this.myEndComment = end;
        this.myMatchRules = rules;
    }

    public List<StdArrangementMatchRule> getMatchRules() {
        return this.myMatchRules;
    }

    public static ArrangementSectionRule create(StdArrangementMatchRule ... rules) {
        if (rules == null) {
            ArrangementSectionRule.$$$reportNull$$$0(1);
        }
        return ArrangementSectionRule.create(null, null, rules);
    }

    public static ArrangementSectionRule create(@Nullable String start, @Nullable String end, StdArrangementMatchRule ... rules) {
        if (rules == null) {
            ArrangementSectionRule.$$$reportNull$$$0(2);
        }
        return ArrangementSectionRule.create(start, end, rules.length == 0 ? ContainerUtil.emptyList() : ContainerUtil.newArrayList((Object[])rules));
    }

    public static ArrangementSectionRule create(@Nullable String start, @Nullable String end, @NotNull List<StdArrangementMatchRule> rules) {
        if (rules == null) {
            ArrangementSectionRule.$$$reportNull$$$0(3);
        }
        ArrayList matchRules = ContainerUtil.newArrayList();
        if (StringUtil.isNotEmpty((String)start)) {
            matchRules.add(ArrangementSectionRule.createSectionRule(start, StdArrangementTokens.Section.START_SECTION));
        }
        matchRules.addAll(rules);
        if (StringUtil.isNotEmpty((String)end)) {
            matchRules.add(ArrangementSectionRule.createSectionRule(end, StdArrangementTokens.Section.END_SECTION));
        }
        return new ArrangementSectionRule(start, end, matchRules);
    }

    @NotNull
    private static StdArrangementMatchRule createSectionRule(@NotNull String comment, @NotNull ArrangementSettingsToken token) {
        if (comment == null) {
            ArrangementSectionRule.$$$reportNull$$$0(4);
        }
        if (token == null) {
            ArrangementSectionRule.$$$reportNull$$$0(5);
        }
        ArrangementAtomMatchCondition text = new ArrangementAtomMatchCondition(StdArrangementTokens.Regexp.TEXT, comment);
        ArrangementMatchCondition condition2 = ArrangementUtil.combine(new ArrangementAtomMatchCondition(token), text);
        StdArrangementMatchRule stdArrangementMatchRule = new StdArrangementMatchRule(new StdArrangementEntryMatcher(condition2));
        if (stdArrangementMatchRule == null) {
            ArrangementSectionRule.$$$reportNull$$$0(6);
        }
        return stdArrangementMatchRule;
    }

    @Nullable
    public String getStartComment() {
        return this.myStartComment;
    }

    @Nullable
    public String getEndComment() {
        return this.myEndComment;
    }

    public int hashCode() {
        int factor = 31;
        int hash = StringUtil.notNullize((String)this.myStartComment).hashCode() + factor * StringUtil.notNullize((String)this.myEndComment).hashCode();
        for (StdArrangementMatchRule rule : this.myMatchRules) {
            factor *= factor;
            hash += rule.hashCode() * factor;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementSectionRule section = (ArrangementSectionRule)o;
        if (!StringUtil.equals((CharSequence)this.myStartComment, (CharSequence)section.myStartComment) || !StringUtil.equals((CharSequence)this.myEndComment, (CharSequence)section.myEndComment) || this.myMatchRules.size() != section.getMatchRules().size()) {
            return false;
        }
        List<StdArrangementMatchRule> matchRules = section.getMatchRules();
        for (int i = 0; i < this.myMatchRules.size(); ++i) {
            StdArrangementMatchRule rule2;
            StdArrangementMatchRule rule1 = this.myMatchRules.get(i);
            if (rule1.equals(rule2 = matchRules.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (StringUtil.isEmpty((String)this.myStartComment)) {
            return "Section: [" + StringUtil.join(this.myMatchRules, (String)",") + "]";
        }
        return "Section (" + this.myStartComment + (StringUtil.isEmpty((String)this.myEndComment) ? "" : ", " + this.myEndComment) + ")";
    }

    public ArrangementSectionRule clone() {
        ArrayList rules = ContainerUtil.newArrayList();
        for (StdArrangementMatchRule myMatchRule : this.myMatchRules) {
            rules.add(myMatchRule.clone());
        }
        return new ArrangementSectionRule(this.myStartComment, this.myEndComment, rules);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/match/ArrangementSectionRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/match/ArrangementSectionRule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSectionRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSectionRule";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

