/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.highlighters.MergeCommitsHighlighter;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import git4idea.GitBranch;
import git4idea.branch.DeepComparatorHolder;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeepComparator
implements VcsLogHighlighter,
Disposable {
    private static final Logger LOG = Logger.getInstance(DeepComparator.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final VcsLogUi myUi;
    @Nullable
    private MyTask myTask;
    @Nullable
    private Set<CommitId> myNonPickedCommits;

    public DeepComparator(@NotNull Project project, @NotNull GitRepositoryManager manager, @NotNull VcsLogUi ui, @NotNull Disposable parent) {
        if (project == null) {
            DeepComparator.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DeepComparator.$$$reportNull$$$0(1);
        }
        if (ui == null) {
            DeepComparator.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            DeepComparator.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myRepositoryManager = manager;
        this.myUi = ui;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void highlightInBackground(@NotNull String branchToCompare, @NotNull VcsLogDataProvider dataProvider) {
        if (branchToCompare == null) {
            DeepComparator.$$$reportNull$$$0(4);
        }
        if (dataProvider == null) {
            DeepComparator.$$$reportNull$$$0(5);
        }
        if (this.myTask != null) {
            LOG.error("Shouldn't be possible");
            return;
        }
        Map<GitRepository, GitBranch> repositories = this.getRepositories(this.myUi.getDataPack().getLogProviders(), branchToCompare);
        if (repositories.isEmpty()) {
            this.removeHighlighting();
            return;
        }
        this.myTask = new MyTask(this.myProject, repositories, dataProvider, branchToCompare);
        this.myTask.queue();
    }

    @NotNull
    private Map<GitRepository, GitBranch> getRepositories(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull String branchToCompare) {
        if (providers == null) {
            DeepComparator.$$$reportNull$$$0(6);
        }
        if (branchToCompare == null) {
            DeepComparator.$$$reportNull$$$0(7);
        }
        HashMap repos = ContainerUtil.newHashMap();
        for (VirtualFile root : providers.keySet()) {
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null || repository.getCurrentBranch() == null || repository.getBranches().findBranchByName(branchToCompare) == null) continue;
            repos.put(repository, repository.getCurrentBranch());
        }
        HashMap hashMap = repos;
        if (hashMap == null) {
            DeepComparator.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    public void stopAndUnhighlight() {
        this.stopTask();
        this.removeHighlighting();
    }

    private void stopTask() {
        if (this.myTask != null) {
            this.myTask.cancel();
            this.myTask = null;
        }
    }

    private void removeHighlighting() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myNonPickedCommits = null;
    }

    public void dispose() {
        this.stopAndUnhighlight();
    }

    public boolean hasHighlightingOrInProgress() {
        return this.myTask != null;
    }

    public static DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogUi logUi) {
        if (project == null) {
            DeepComparator.$$$reportNull$$$0(9);
        }
        if (logUi == null) {
            DeepComparator.$$$reportNull$$$0(10);
        }
        return ((DeepComparatorHolder)ServiceManager.getService((Project)project, DeepComparatorHolder.class)).getInstance(logUi);
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(@NotNull VcsShortCommitDetails commitDetails, boolean isSelected) {
        if (commitDetails == null) {
            DeepComparator.$$$reportNull$$$0(11);
        }
        if (this.myNonPickedCommits == null) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                DeepComparator.$$$reportNull$$$0(12);
            }
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.foreground((Color)(!this.myNonPickedCommits.contains(new CommitId((Hash)commitDetails.getId(), commitDetails.getRoot())) ? MergeCommitsHighlighter.MERGE_COMMIT_FOREGROUND : null));
        if (vcsCommitStyle == null) {
            DeepComparator.$$$reportNull$$$0(13);
        }
        return vcsCommitStyle;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        if (dataPack == null) {
            DeepComparator.$$$reportNull$$$0(14);
        }
        if (this.myTask == null) {
            return;
        }
        String comparedBranch = this.myTask.myComparedBranch;
        VcsLogBranchFilter branchFilter = dataPack.getFilters().getBranchFilter();
        if (branchFilter == null || !this.myTask.myComparedBranch.equals(VcsLogUtil.getSingleFilteredBranch((VcsLogBranchFilter)branchFilter, (VcsLogRefs)dataPack.getRefs()))) {
            this.stopAndUnhighlight();
            return;
        }
        if (refreshHappened) {
            Map repositoriesWithCurrentBranches = this.myTask.myRepositoriesWithCurrentBranches;
            VcsLogDataProvider provider = this.myTask.myProvider;
            this.stopTask();
            Map<GitRepository, GitBranch> repositories = this.getRepositories(dataPack.getLogProviders(), comparedBranch);
            if (repositories.equals(repositoriesWithCurrentBranches)) {
                this.highlightInBackground(comparedBranch, provider);
            } else {
                this.removeHighlighting();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToCompare";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/DeepComparator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitDetails";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/DeepComparator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "highlightInBackground";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStyle";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTask
    extends Task.Backgroundable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Map<GitRepository, GitBranch> myRepositoriesWithCurrentBranches;
        @NotNull
        private final VcsLogDataProvider myProvider;
        @NotNull
        private final String myComparedBranch;
        @NotNull
        private final Set<CommitId> myCollectedNonPickedCommits;
        @Nullable
        private VcsException myException;
        private boolean myCancelled;

        public MyTask(@NotNull Project project, @NotNull Map<GitRepository, GitBranch> repositoriesWithCurrentBranches, @NotNull VcsLogDataProvider dataProvider, String branchToCompare) {
            if (project == null) {
                MyTask.$$$reportNull$$$0(0);
            }
            if (repositoriesWithCurrentBranches == null) {
                MyTask.$$$reportNull$$$0(1);
            }
            if (dataProvider == null) {
                MyTask.$$$reportNull$$$0(2);
            }
            if (branchToCompare == null) {
                MyTask.$$$reportNull$$$0(3);
            }
            super(project, "Comparing Branches...");
            this.myCollectedNonPickedCommits = ContainerUtil.newHashSet();
            this.myProject = project;
            this.myRepositoriesWithCurrentBranches = repositoriesWithCurrentBranches;
            this.myProvider = dataProvider;
            this.myComparedBranch = branchToCompare;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyTask.$$$reportNull$$$0(4);
            }
            try {
                for (Map.Entry<GitRepository, GitBranch> entry : this.myRepositoriesWithCurrentBranches.entrySet()) {
                    GitRepository repo = entry.getKey();
                    GitBranch currentBranch = entry.getValue();
                    this.myCollectedNonPickedCommits.addAll(this.getNonPickedCommitsFromGit(this.myProject, repo.getRoot(), currentBranch.getName(), this.myComparedBranch));
                }
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                this.myException = e;
            }
        }

        public void onSuccess() {
            if (this.myCancelled) {
                return;
            }
            DeepComparator.this.removeHighlighting();
            if (this.myException != null) {
                VcsNotifier.getInstance((Project)this.myProject).notifyError("Couldn't compare with branch " + this.myComparedBranch, this.myException.getMessage());
                return;
            }
            DeepComparator.this.myNonPickedCommits = this.myCollectedNonPickedCommits;
        }

        public void cancel() {
            this.myCancelled = true;
        }

        @NotNull
        private Set<CommitId> getNonPickedCommitsFromGit(@NotNull Project project, final @NotNull VirtualFile root, @NotNull String currentBranch, @NotNull String comparedBranch) throws VcsException {
            if (project == null) {
                MyTask.$$$reportNull$$$0(5);
            }
            if (root == null) {
                MyTask.$$$reportNull$$$0(6);
            }
            if (currentBranch == null) {
                MyTask.$$$reportNull$$$0(7);
            }
            if (comparedBranch == null) {
                MyTask.$$$reportNull$$$0(8);
            }
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.CHERRY);
            handler.addParameters(currentBranch, comparedBranch);
            final HashSet pickedCommits = ContainerUtil.newHashSet();
            handler.addLineListener(new GitLineHandlerAdapter(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (line.startsWith("+")) {
                        try {
                            line = line.substring(2).trim();
                            int firstSpace = line.indexOf(32);
                            if (firstSpace > 0) {
                                line = line.substring(0, firstSpace);
                            }
                            Hash hash = HashImpl.build((String)line);
                            pickedCommits.add(new CommitId(hash, root));
                        }
                        catch (Exception e) {
                            LOG.error("Couldn't parse line [" + line + "]");
                        }
                    }
                }
            });
            handler.runInCurrentThread(null);
            HashSet hashSet = pickedCommits;
            if (hashSet == null) {
                MyTask.$$$reportNull$$$0(9);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositoriesWithCurrentBranches";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchToCompare";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentBranch";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comparedBranch";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/branch/DeepComparator$MyTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/branch/DeepComparator$MyTask";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNonPickedCommitsFromGit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getNonPickedCommitsFromGit";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "CHERRY_PICKED_COMMITS";

        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logDataManager, @NotNull VcsLogUi logUi) {
            if (logDataManager == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (logUi == null) {
                Factory.$$$reportNull$$$0(1);
            }
            DeepComparator deepComparator = DeepComparator.getInstance(logDataManager.getProject(), logUi);
            if (deepComparator == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return deepComparator;
        }

        @NotNull
        public String getId() {
            if (ID == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return ID;
        }

        @NotNull
        public String getTitle() {
            if ("Cherry Picked Commits" == null) {
                Factory.$$$reportNull$$$0(4);
            }
            return "Cherry Picked Commits";
        }

        public boolean showMenuItem() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logDataManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logUi";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/branch/DeepComparator$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/branch/DeepComparator$Factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHighlighter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createHighlighter";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

