/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.LineHandlerHelper;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitTextHandler;
import java.io.File;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitLineHandler
extends GitTextHandler {
    private final StringBuilder myStdoutLine;
    private final StringBuilder myStderrLine;
    private final EventDispatcher<GitLineHandlerListener> myLineListeners;

    public GitLineHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (project == null) {
            GitLineHandler.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            GitLineHandler.$$$reportNull$$$0(1);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(2);
        }
        super(project, directory, command);
        this.myStdoutLine = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
    }

    public GitLineHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        if (project == null) {
            GitLineHandler.$$$reportNull$$$0(3);
        }
        if (vcsRoot == null) {
            GitLineHandler.$$$reportNull$$$0(4);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(5);
        }
        super(project, vcsRoot, command);
        this.myStdoutLine = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
    }

    public GitLineHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (project == null) {
            GitLineHandler.$$$reportNull$$$0(6);
        }
        if (vcsRoot == null) {
            GitLineHandler.$$$reportNull$$$0(7);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(8);
        }
        if (configParameters == null) {
            GitLineHandler.$$$reportNull$$$0(9);
        }
        super(project, vcsRoot, command, configParameters);
        this.myStdoutLine = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
    }

    @Override
    protected void processTerminated(int exitCode) {
        if (this.myStdoutLine.length() != 0) {
            this.onTextAvailable("\n\r", ProcessOutputTypes.STDOUT);
        } else if (!this.isStderrSuppressed() && this.myStderrLine.length() != 0) {
            this.onTextAvailable("\n\r", ProcessOutputTypes.STDERR);
        }
    }

    public void addLineListener(GitLineHandlerListener listener2) {
        super.addListener((ProcessEventListener)listener2);
        this.myLineListeners.addListener((EventListener)((Object)listener2));
    }

    @Override
    protected void onTextAvailable(String text, Key outputType) {
        Iterator<String> lines = LineHandlerHelper.splitText((String)text).iterator();
        if (ProcessOutputTypes.STDOUT == outputType) {
            this.notifyLines(outputType, lines, this.myStdoutLine);
        } else if (ProcessOutputTypes.STDERR == outputType) {
            this.notifyLines(outputType, lines, this.myStderrLine);
        }
    }

    private void notifyLines(Key outputType, Iterator<String> lines, StringBuilder lineBuilder) {
        block5: {
            String line;
            if (!lines.hasNext()) {
                return;
            }
            if (lineBuilder.length() > 0) {
                lineBuilder.append(lines.next());
                if (lines.hasNext()) {
                    line = lineBuilder.toString();
                    this.notifyLine(line, outputType);
                    lineBuilder.setLength(0);
                }
            }
            while (true) {
                line = null;
                if (lines.hasNext()) {
                    line = lines.next();
                }
                if (!lines.hasNext()) break;
                this.notifyLine(line, outputType);
            }
            if (line == null || line.length() <= 0) break block5;
            lineBuilder.append(line);
        }
    }

    private void notifyLine(String line, Key outputType) {
        String trimmed = LineHandlerHelper.trimLineSeparator((String)line);
        if (this.myVcs != null && !"\r".equals(line.substring(trimmed.length()))) {
            if (outputType == ProcessOutputTypes.STDOUT) {
                if (!(this.isStdoutSuppressed() || this.mySilent || StringUtil.isEmptyOrSpaces((String)line))) {
                    this.myVcs.showMessages(trimmed);
                    LOG.info(line.trim());
                } else {
                    OUTPUT_LOG.debug(line.trim());
                }
            } else if (!(outputType != ProcessOutputTypes.STDERR || this.isStderrSuppressed() || this.mySilent || StringUtil.isEmptyOrSpaces((String)line))) {
                this.myVcs.showErrorMessages(trimmed);
                LOG.info(line.trim());
            } else {
                LOG.debug(line.trim());
            }
        }
        ((GitLineHandlerListener)((Object)this.myLineListeners.getMulticaster())).onLineAvailable(trimmed, outputType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "directory";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[0] = "command";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "vcsRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[0] = "configParameters";
                break;
            }
        }
        objectArray[1] = "git4idea/commands/GitLineHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

