/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import git4idea.GitFormatException;
import git4idea.GitVcs;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitChangeType;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogStatusInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogParser {
    public static final String RECORD_START = "\u0001\u0001";
    public static final String ITEMS_SEPARATOR = "\u0002";
    public static final String RECORD_END = "\u0003\u0003";
    public static final String RECORD_START_GIT = "%x01%x01";
    private static final String ITEMS_SEPARATOR_GIT = "%x02";
    private static final String RECORD_END_GIT = "%x03%x03";
    private static final int INPUT_ERROR_MESSAGE_HEAD_LIMIT = 1000000;
    private static final int INPUT_ERROR_MESSAGE_TAIL_LIMIT = 100;
    private final String myFormat;
    private final GitLogOption[] myOptions;
    private final boolean mySupportsRawBody;
    private final NameStatus myNameStatusOption;
    private static final Pattern ONE_RECORD = Pattern.compile("(?:\u0001\u0001)?(.*)\u0003\u0003\n*(.*)", 32);
    private static final String SINGLE_PATH = "([^\t\r\n]+)";
    private static final String EOL = "\\s*(?:\r|\n|\r\n)";
    private static final String PATHS = "([^\t\r\n]+)(?:\t([^\t\r\n]+))?(?:\\s*(?:\r|\n|\r\n))?";
    private static Pattern NAME_ONLY = Pattern.compile("([^\t\r\n]+)(?:\t([^\t\r\n]+))?(?:\\s*(?:\r|\n|\r\n))?");
    private static Pattern NAME_STATUS = Pattern.compile("([\\S]+)\t([^\t\r\n]+)(?:\t([^\t\r\n]+))?(?:\\s*(?:\r|\n|\r\n))?");

    GitLogParser(Project project, GitLogOption ... options) {
        this(project, NameStatus.NONE, options);
    }

    GitLogParser(Project project, NameStatus nameStatusOption, GitLogOption ... options) {
        this.myFormat = GitLogParser.makeFormatFromOptions(options);
        this.myOptions = options;
        this.myNameStatusOption = nameStatusOption;
        GitVcs vcs = GitVcs.getInstance(project);
        this.mySupportsRawBody = vcs != null && GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(vcs.getVersion());
    }

    private static String makeFormatFromOptions(GitLogOption[] options) {
        Function function = option -> "%" + ((GitLogOption)option).getPlaceholder();
        return RECORD_START_GIT + StringUtil.join((Object[])options, (Function)function, (String)ITEMS_SEPARATOR_GIT) + RECORD_END_GIT;
    }

    String getPretty() {
        return "--pretty=format:" + this.myFormat;
    }

    @NotNull
    List<GitLogRecord> parse(@NotNull CharSequence output) {
        if (output == null) {
            GitLogParser.$$$reportNull$$$0(0);
        }
        List records = StringUtil.split((CharSequence)output, (CharSequence)RECORD_START);
        String notMatchedPart = null;
        ArrayList<GitLogRecord> res = new ArrayList<GitLogRecord>(records.size());
        for (CharSequence record : records) {
            String recordString = record.toString();
            if (recordString.isEmpty()) continue;
            if (notMatchedPart != null) {
                recordString = notMatchedPart + recordString;
            }
            if (ONE_RECORD.matcher(recordString).matches()) {
                notMatchedPart = null;
                res.add(this.parseOneRecord(recordString));
                continue;
            }
            notMatchedPart = recordString;
        }
        ArrayList<GitLogRecord> arrayList = res;
        if (arrayList == null) {
            GitLogParser.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    GitLogRecord parseOneRecord(@NotNull CharSequence line) {
        ArrayList<GitLogStatusInfo> statuses;
        ArrayList<String> paths;
        Map<GitLogOption, String> res;
        block10: {
            String commitInfo;
            if (line == null) {
                GitLogParser.$$$reportNull$$$0(2);
            }
            if (line.length() == 0) {
                return null;
            }
            Matcher matcher = ONE_RECORD.matcher(line);
            if (!matcher.matches()) {
                GitLogParser.throwGFE("ONE_RECORD didn't match", line);
            }
            if ((commitInfo = matcher.group(1)) == null) {
                GitLogParser.throwGFE("No match for group#1 in", line);
            }
            res = this.parseCommitInfo(commitInfo);
            paths = new ArrayList<String>(1);
            statuses = new ArrayList<GitLogStatusInfo>();
            if (this.myNameStatusOption == NameStatus.NONE) break block10;
            String pathsAndStatuses = matcher.group(2);
            if (pathsAndStatuses == null) {
                GitLogParser.throwGFE("No match for group#2 in", line);
            }
            if (this.myNameStatusOption == NameStatus.NAME) {
                Matcher pathsMatcher = NAME_ONLY.matcher(pathsAndStatuses);
                while (pathsMatcher.find()) {
                    String path1 = pathsMatcher.group(1);
                    String path2 = pathsMatcher.group(2);
                    GitLogParser.assertNotNull(path1, "path", pathsAndStatuses);
                    paths.add(path1);
                    if (path2 == null) continue;
                    paths.add(path2);
                }
            } else {
                Matcher nameStatusMatcher = NAME_STATUS.matcher(pathsAndStatuses);
                while (nameStatusMatcher.find()) {
                    String status = nameStatusMatcher.group(1);
                    String path1 = nameStatusMatcher.group(2);
                    String path2 = nameStatusMatcher.group(3);
                    GitLogParser.assertNotNull(status, "status", pathsAndStatuses);
                    GitLogParser.assertNotNull(path1, "path1", pathsAndStatuses);
                    paths.add(path1);
                    if (path2 != null) {
                        paths.add(path2);
                    }
                    statuses.add(new GitLogStatusInfo(GitChangeType.fromString(status), path1, path2));
                }
            }
        }
        return new GitLogRecord(res, paths, statuses, this.mySupportsRawBody);
    }

    @NotNull
    private Map<GitLogOption, String> parseCommitInfo(@NotNull String commitInfo) {
        int i;
        if (commitInfo == null) {
            GitLogParser.$$$reportNull$$$0(3);
        }
        String[] values = commitInfo.split(ITEMS_SEPARATOR);
        HashMap<GitLogOption, String> res = new HashMap<GitLogOption, String>(values.length);
        for (i = 0; i < values.length && i < this.myOptions.length; ++i) {
            res.put(this.myOptions[i], values[i]);
        }
        while (i < this.myOptions.length) {
            res.put(this.myOptions[i], "");
            ++i;
        }
        HashMap<GitLogOption, String> hashMap = res;
        if (hashMap == null) {
            GitLogParser.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static void assertNotNull(String value, String valueName, String line) {
        if (value == null) {
            GitLogParser.throwGFE("Unexpectedly null " + valueName + " in ", line);
        }
    }

    private static void throwGFE(@NotNull String message, @NotNull CharSequence line) {
        if (message == null) {
            GitLogParser.$$$reportNull$$$0(5);
        }
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(6);
        }
        throw new GitFormatException(message + " [" + GitLogParser.getTruncatedEscapedOutput(line) + "]");
    }

    @NotNull
    public static String getTruncatedEscapedOutput(@NotNull CharSequence line) {
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(7);
        }
        String formatString = "%s...(%d more characters)...%s";
        String lineString = line.length() > 1000100 + formatString.length() ? String.format(formatString, line.subSequence(0, 1000000), line.length() - 1000000 - 100, line.subSequence(line.length() - 100, line.length())) : line.toString();
        String string = StringUtil.escapeStringCharacters((String)lineString);
        if (string == null) {
            GitLogParser.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogParser";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCommitInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTruncatedEscapedOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseOneRecord";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseCommitInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "throwGFE";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTruncatedEscapedOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum GitLogOption {
        HASH("H"),
        TREE("T"),
        COMMIT_TIME("ct"),
        AUTHOR_NAME("an"),
        AUTHOR_TIME("at"),
        AUTHOR_EMAIL("ae"),
        COMMITTER_NAME("cn"),
        COMMITTER_EMAIL("ce"),
        SUBJECT("s"),
        BODY("b"),
        PARENTS("P"),
        REF_NAMES("d"),
        SHORT_REF_LOG_SELECTOR("gd"),
        RAW_BODY("B");

        private String myPlaceholder;

        private GitLogOption(String placeholder) {
            this.myPlaceholder = placeholder;
        }

        private String getPlaceholder() {
            return this.myPlaceholder;
        }
    }

    static enum NameStatus {
        NONE,
        NAME,
        STATUS;

    }
}

