/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.vcs.log.Hash;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitSubmoduleInfo;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepoInfo {
    @Nullable
    private final GitLocalBranch myCurrentBranch;
    @Nullable
    private final String myCurrentRevision;
    @NotNull
    private final Repository.State myState;
    @NotNull
    private final Set<GitRemote> myRemotes;
    @NotNull
    private final Map<GitLocalBranch, Hash> myLocalBranches;
    @NotNull
    private final Map<GitRemoteBranch, Hash> myRemoteBranches;
    @NotNull
    private final Set<GitBranchTrackInfo> myBranchTrackInfos;
    @NotNull
    private final Collection<GitSubmoduleInfo> mySubmodules;
    @NotNull
    private final GitHooksInfo myHooksInfo;

    public GitRepoInfo(@Nullable GitLocalBranch currentBranch, @Nullable String currentRevision, @NotNull Repository.State state, @NotNull Collection<GitRemote> remotes, @NotNull Map<GitLocalBranch, Hash> localBranches, @NotNull Map<GitRemoteBranch, Hash> remoteBranches, @NotNull Collection<GitBranchTrackInfo> branchTrackInfos, @NotNull Collection<GitSubmoduleInfo> submodules, @NotNull GitHooksInfo hooksInfo) {
        if (state == null) {
            GitRepoInfo.$$$reportNull$$$0(0);
        }
        if (remotes == null) {
            GitRepoInfo.$$$reportNull$$$0(1);
        }
        if (localBranches == null) {
            GitRepoInfo.$$$reportNull$$$0(2);
        }
        if (remoteBranches == null) {
            GitRepoInfo.$$$reportNull$$$0(3);
        }
        if (branchTrackInfos == null) {
            GitRepoInfo.$$$reportNull$$$0(4);
        }
        if (submodules == null) {
            GitRepoInfo.$$$reportNull$$$0(5);
        }
        if (hooksInfo == null) {
            GitRepoInfo.$$$reportNull$$$0(6);
        }
        this.myCurrentBranch = currentBranch;
        this.myCurrentRevision = currentRevision;
        this.myState = state;
        this.myRemotes = new LinkedHashSet<GitRemote>(remotes);
        this.myLocalBranches = new LinkedHashMap<GitLocalBranch, Hash>(localBranches);
        this.myRemoteBranches = new LinkedHashMap<GitRemoteBranch, Hash>(remoteBranches);
        this.myBranchTrackInfos = new LinkedHashSet<GitBranchTrackInfo>(branchTrackInfos);
        this.mySubmodules = submodules;
        this.myHooksInfo = hooksInfo;
    }

    @Nullable
    public GitLocalBranch getCurrentBranch() {
        return this.myCurrentBranch;
    }

    @NotNull
    public Collection<GitRemote> getRemotes() {
        Set<GitRemote> set = this.myRemotes;
        if (set == null) {
            GitRepoInfo.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Map<GitLocalBranch, Hash> getLocalBranchesWithHashes() {
        Map<GitLocalBranch, Hash> map = this.myLocalBranches;
        if (map == null) {
            GitRepoInfo.$$$reportNull$$$0(8);
        }
        return map;
    }

    @NotNull
    public Map<GitRemoteBranch, Hash> getRemoteBranchesWithHashes() {
        Map<GitRemoteBranch, Hash> map = this.myRemoteBranches;
        if (map == null) {
            GitRepoInfo.$$$reportNull$$$0(9);
        }
        return map;
    }

    @Deprecated
    @NotNull
    public Collection<GitRemoteBranch> getRemoteBranches() {
        Set<GitRemoteBranch> set = this.myRemoteBranches.keySet();
        if (set == null) {
            GitRepoInfo.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        Set<GitBranchTrackInfo> set = this.myBranchTrackInfos;
        if (set == null) {
            GitRepoInfo.$$$reportNull$$$0(11);
        }
        return set;
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myCurrentRevision;
    }

    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myState;
        if (state == null) {
            GitRepoInfo.$$$reportNull$$$0(12);
        }
        return state;
    }

    @NotNull
    public Collection<GitSubmoduleInfo> getSubmodules() {
        Collection<GitSubmoduleInfo> collection = this.mySubmodules;
        if (collection == null) {
            GitRepoInfo.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    public GitHooksInfo getHooksInfo() {
        GitHooksInfo gitHooksInfo = this.myHooksInfo;
        if (gitHooksInfo == null) {
            GitRepoInfo.$$$reportNull$$$0(14);
        }
        return gitHooksInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitRepoInfo info = (GitRepoInfo)o;
        if (this.myState != info.myState) {
            return false;
        }
        if (this.myCurrentRevision != null ? !this.myCurrentRevision.equals(info.myCurrentRevision) : info.myCurrentRevision != null) {
            return false;
        }
        if (this.myCurrentBranch != null ? !this.myCurrentBranch.equals(info.myCurrentBranch) : info.myCurrentBranch != null) {
            return false;
        }
        if (!this.myRemotes.equals(info.myRemotes)) {
            return false;
        }
        if (!this.myBranchTrackInfos.equals(info.myBranchTrackInfos)) {
            return false;
        }
        if (!GitRepoInfo.areEqual(this.myLocalBranches, info.myLocalBranches)) {
            return false;
        }
        if (!GitRepoInfo.areEqual(this.myRemoteBranches, info.myRemoteBranches)) {
            return false;
        }
        if (!this.mySubmodules.equals(info.mySubmodules)) {
            return false;
        }
        return this.myHooksInfo.equals(info.myHooksInfo);
    }

    public int hashCode() {
        int result2 = this.myCurrentBranch != null ? this.myCurrentBranch.hashCode() : 0;
        result2 = 31 * result2 + (this.myCurrentRevision != null ? this.myCurrentRevision.hashCode() : 0);
        result2 = 31 * result2 + this.myState.hashCode();
        result2 = 31 * result2 + this.myRemotes.hashCode();
        result2 = 31 * result2 + this.myLocalBranches.hashCode();
        result2 = 31 * result2 + this.myRemoteBranches.hashCode();
        result2 = 31 * result2 + this.myBranchTrackInfos.hashCode();
        result2 = 31 * result2 + this.mySubmodules.hashCode();
        result2 = 31 * result2 + this.myHooksInfo.hashCode();
        return result2;
    }

    public String toString() {
        return String.format("GitRepoInfo{current=%s, remotes=%s, localBranches=%s, remoteBranches=%s, trackInfos=%s, submodules=%s, hooks=%s}", this.myCurrentBranch, this.myRemotes, this.myLocalBranches, this.myRemoteBranches, this.myBranchTrackInfos, this.mySubmodules, this.myHooksInfo);
    }

    private static <T extends GitBranch> boolean areEqual(Map<T, Hash> c1, Map<T, Hash> c2) {
        THashSet set1 = new THashSet(c1.entrySet(), (TObjectHashingStrategy)new BranchesComparingStrategy());
        THashSet set2 = new THashSet(c2.entrySet(), (TObjectHashingStrategy)new BranchesComparingStrategy());
        return set1.equals((Object)set2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranches";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranches";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchTrackInfos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "submodules";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hooksInfo";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRepoInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRepoInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalBranchesWithHashes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteBranchesWithHashes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteBranches";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchTrackInfos";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubmodules";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHooksInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BranchesComparingStrategy
    implements TObjectHashingStrategy<Map.Entry<? extends GitBranch, Hash>> {
        private BranchesComparingStrategy() {
        }

        public int computeHashCode(@NotNull Map.Entry<? extends GitBranch, Hash> branchEntry) {
            if (branchEntry == null) {
                BranchesComparingStrategy.$$$reportNull$$$0(0);
            }
            return 31 * branchEntry.getKey().getName().hashCode() + branchEntry.getValue().hashCode();
        }

        public boolean equals(@NotNull Map.Entry<? extends GitBranch, Hash> b1, @NotNull Map.Entry<? extends GitBranch, Hash> b2) {
            if (b1 == null) {
                BranchesComparingStrategy.$$$reportNull$$$0(1);
            }
            if (b2 == null) {
                BranchesComparingStrategy.$$$reportNull$$$0(2);
            }
            if (b1 == b2) {
                return true;
            }
            if (b1.getClass() != b2.getClass()) {
                return false;
            }
            return b1.getKey().getName().equals(b2.getKey().getName()) && b1.getValue().equals(b2.getValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b2";
                    break;
                }
            }
            objectArray2[1] = "git4idea/repo/GitRepoInfo$BranchesComparingStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeHashCode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "equals";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

