/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.openapi.util.objectTree.ObjectTreeListener;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectTree<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectTree");
    private final List<ObjectTreeListener> myListeners;
    private final Set<T> myRootObjects;
    private final Map<T, ObjectNode<T>> myObject2NodeMap;
    private final Map<Object, Object> myDisposedObjects;
    private final List<ObjectNode<T>> myExecutedNodes;
    private final List<T> myExecutedUnregisteredNodes;
    final Object treeLock;
    private final AtomicLong myModification;

    /*
     * Exception decompiling
     */
    public ObjectTree() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    ObjectNode<T> getNode(@NotNull T object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(0);
        }
        return this.myObject2NodeMap.get(object);
    }

    void putNode(@NotNull T object, @Nullable(value="null means remove") ObjectNode<T> node) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(1);
        }
        if (node == null) {
            this.myObject2NodeMap.remove(object);
        } else {
            this.myObject2NodeMap.put(object, node);
        }
    }

    @NotNull
    final List<ObjectNode<T>> getNodesInExecution() {
        List<ObjectNode<T>> list = this.myExecutedNodes;
        if (list == null) {
            ObjectTree.$$$reportNull$$$0(2);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(@NotNull T parent, @NotNull T child) {
        if (parent == null) {
            ObjectTree.$$$reportNull$$$0(3);
        }
        if (child == null) {
            ObjectTree.$$$reportNull$$$0(4);
        }
        if (parent == child) {
            throw new IllegalArgumentException("Cannot register to itself: " + parent);
        }
        Object wasDisposed = this.getDisposalInfo(parent);
        if (wasDisposed != null) {
            throw new IncorrectOperationException("Sorry but parent: " + parent + " has already been disposed (see the cause for stacktrace) so the child: " + child + " will never be disposed", wasDisposed instanceof Throwable ? (Throwable)wasDisposed : null);
        }
        if (this.isDisposing(parent)) {
            throw new IncorrectOperationException("Sorry but parent: " + parent + " is being disposed so the child: " + child + " will never be disposed");
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode<T> childNode;
            this.myDisposedObjects.remove(child);
            ObjectNode<T> parentNode = this.getNode(parent);
            if (parentNode == null) {
                parentNode = this.createNodeFor(parent, null);
            }
            if ((childNode = this.getNode(child)) == null) {
                childNode = this.createNodeFor(child, parentNode);
            } else {
                ObjectNode<T> oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            this.checkWasNotAddedAlready(parentNode, childNode);
            parentNode.addChild(childNode);
            this.fireRegistered(childNode.getObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDisposalInfo(@NotNull T parent) {
        if (parent == null) {
            ObjectTree.$$$reportNull$$$0(5);
        }
        Object object = this.treeLock;
        synchronized (object) {
            return this.myDisposedObjects.get(parent);
        }
    }

    private void checkWasNotAddedAlready(ObjectNode<T> childNode, @NotNull ObjectNode<T> parentNode) {
        if (parentNode == null) {
            ObjectTree.$$$reportNull$$$0(6);
        }
        for (ObjectNode<T> node = childNode; node != null; node = node.getParent()) {
            if (node != parentNode) continue;
            throw new IncorrectOperationException("'" + childNode.getObject() + "' was already added as a child of '" + parentNode.getObject() + "'");
        }
    }

    @NotNull
    private ObjectNode<T> createNodeFor(@NotNull T object, @Nullable ObjectNode<T> parentNode) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(7);
        }
        ObjectNode<T> newNode = new ObjectNode<T>(this, parentNode, object, this.getNextModification());
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        ObjectNode<T> objectNode = newNode;
        if (objectNode == null) {
            ObjectTree.$$$reportNull$$$0(8);
        }
        return objectNode;
    }

    private long getNextModification() {
        return this.myModification.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeAll(@NotNull T object, @NotNull ObjectTreeAction<T> action, boolean processUnregistered) {
        ObjectNode<T> node;
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(9);
        }
        if (action == null) {
            ObjectTree.$$$reportNull$$$0(10);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            node = this.getNode(object);
        }
        if (node == null) {
            if (processUnregistered) {
                this.rememberDisposedTrace(object);
                this.executeUnregistered(object, action);
            }
        } else {
            node.execute(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposing(@NotNull T disposable) {
        List<ObjectNode<T>> guard;
        if (disposable == null) {
            ObjectTree.$$$reportNull$$$0(11);
        }
        List<ObjectNode<T>> list = guard = this.getNodesInExecution();
        synchronized (list) {
            for (ObjectNode<T> node : guard) {
                if (node.getObject() != disposable) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    static <T> void executeActionWithRecursiveGuard(@NotNull T object, @NotNull List<T> recursiveGuard, @NotNull ObjectTreeAction<T> action) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ComparisonOperation.applyExpressionRewriter(ComparisonOperation.java:138)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:19)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.rewriteExpressions(IfStatement.java:53)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeUnregistered(@NotNull T object, @NotNull ObjectTreeAction<T> action) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(15);
        }
        if (action == null) {
            ObjectTree.$$$reportNull$$$0(16);
        }
        ObjectTree.executeActionWithRecursiveGuard(object, this.myExecutedUnregisteredNodes, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeChildAndReplace(@NotNull T toExecute, @NotNull T toReplace, @NotNull ObjectTreeAction<T> action) {
        T parentObject;
        ObjectNode<T> toExecuteNode;
        if (toExecute == null) {
            ObjectTree.$$$reportNull$$$0(17);
        }
        if (toReplace == null) {
            ObjectTree.$$$reportNull$$$0(18);
        }
        if (action == null) {
            ObjectTree.$$$reportNull$$$0(19);
        }
        Object object = this.treeLock;
        synchronized (object) {
            toExecuteNode = this.getNode(toExecute);
            if (toExecuteNode == null) {
                throw new IllegalArgumentException("Object " + toExecute + " wasn't registered or already disposed");
            }
            ObjectNode<T> parent = toExecuteNode.getParent();
            if (parent == null) {
                throw new IllegalArgumentException("Object " + toExecute + " is not connected to the tree - doesn't have parent");
            }
            parentObject = parent.getObject();
        }
        toExecuteNode.execute(action);
        this.register(parentObject, toReplace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(@NotNull T object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(20);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            return this.getNode(object) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertNoReferenceKeptInTree(@NotNull T disposable) {
        if (disposable == null) {
            ObjectTree.$$$reportNull$$$0(21);
        }
        Object object = this.treeLock;
        synchronized (object) {
            Collection<ObjectNode<T>> nodes = this.myObject2NodeMap.values();
            for (ObjectNode<T> node : nodes) {
                node.assertNoReferencesKept(disposable);
            }
        }
    }

    void removeRootObject(@NotNull T object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(22);
        }
        this.myRootObjects.remove(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertIsEmpty(boolean throwError) {
        Object object = this.treeLock;
        synchronized (object) {
            for (T object2 : this.myRootObjects) {
                ObjectNode<T> objectNode;
                if (object2 == null || (objectNode = this.getNode(object2)) == null) continue;
                while (objectNode.getParent() != null) {
                    objectNode = objectNode.getParent();
                }
                Throwable trace = objectNode.getTrace();
                RuntimeException exception = new RuntimeException("Memory leak detected: '" + object2 + "' of " + object2.getClass() + "\nSee the cause for the corresponding Disposer.register() stacktrace:\n", trace);
                if (throwError) {
                    throw exception;
                }
                LOG.error(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.myRootObjects.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    Set<T> getRootObjects() {
        Object object = this.treeLock;
        // MONITORENTER : object
        Set<T> set = this.myRootObjects;
        // MONITOREXIT : object
        if (set != null) return set;
        ObjectTree.$$$reportNull$$$0(23);
        return set;
    }

    void addListener(@NotNull ObjectTreeListener listener) {
        if (listener == null) {
            ObjectTree.$$$reportNull$$$0(24);
        }
        this.myListeners.add(listener);
    }

    void removeListener(@NotNull ObjectTreeListener listener) {
        if (listener == null) {
            ObjectTree.$$$reportNull$$$0(25);
        }
        this.myListeners.remove(listener);
    }

    private void fireRegistered(@NotNull Object object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(26);
        }
        for (ObjectTreeListener each : this.myListeners) {
            each.objectRegistered(object);
        }
    }

    void fireExecuted(@NotNull Object object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(27);
        }
        for (ObjectTreeListener each : this.myListeners) {
            each.objectExecuted(object);
        }
        this.rememberDisposedTrace(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberDisposedTrace(@NotNull Object object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(28);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            this.myDisposedObjects.put(object, Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.myObject2NodeMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <D extends Disposable> D findRegisteredObject(@NotNull T parentDisposable, @NotNull D object) {
        if (parentDisposable == null) {
            ObjectTree.$$$reportNull$$$0(29);
        }
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(30);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            ObjectNode<T> parentNode = this.getNode(parentDisposable);
            if (parentNode == null) {
                return null;
            }
            return parentNode.findChildEqualTo(object);
        }
    }

    long getModification() {
        return this.myModification.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/objectTree/ObjectTree";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursiveGuard";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExecute";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/objectTree/ObjectTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesInExecution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeFor";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putNode";
                break;
            }
            case 2: 
            case 8: 
            case 23: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkWasNotAddedAlready";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNodeFor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeAll";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDisposing";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeActionWithRecursiveGuard";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeUnregistered";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "executeChildAndReplace";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferenceKeptInTree";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeRootObject";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fireRegistered";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fireExecuted";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "rememberDisposedTrace";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

