/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.DarculaColors;
import com.intellij.ui.Gray;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.jetbrains.annotations.NotNull;

public class JBColor
extends Color {
    private static volatile boolean DARK = UIUtil.isUnderDarcula();
    private final Color darkColor;
    private final NotNullProducer<Color> func;
    public static final JBColor red;
    public static final JBColor RED;
    public static final JBColor blue;
    public static final JBColor BLUE;
    public static final JBColor white;
    public static final JBColor WHITE;
    public static final JBColor black;
    public static final JBColor BLACK;
    public static final JBColor gray;
    public static final JBColor GRAY;
    public static final JBColor lightGray;
    public static final JBColor LIGHT_GRAY;
    public static final JBColor darkGray;
    public static final JBColor DARK_GRAY;
    public static final JBColor pink;
    public static final JBColor PINK;
    public static final JBColor orange;
    public static final JBColor ORANGE;
    public static final JBColor yellow;
    public static final JBColor YELLOW;
    public static final JBColor green;
    public static final JBColor GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;

    public JBColor(int rgb, int darkRGB) {
        this(new Color(rgb), new Color(darkRGB));
    }

    public JBColor(Color regular, Color dark) {
        super(regular.getRGB(), regular.getAlpha() != 255);
        this.darkColor = dark;
        DARK = UIUtil.isUnderDarcula();
        this.func = null;
    }

    public JBColor(NotNullProducer<Color> function) {
        super(0);
        this.darkColor = null;
        this.func = function;
    }

    public static void setDark(boolean dark) {
        DARK = dark;
    }

    public static boolean isBright() {
        return !DARK;
    }

    Color getDarkVariant() {
        return this.darkColor;
    }

    Color getColor() {
        if (this.func != null) {
            return this.func.produce();
        }
        return DARK ? this.getDarkVariant() : this;
    }

    @Override
    public int getRed() {
        Color c = this.getColor();
        return c == this ? super.getRed() : c.getRed();
    }

    @Override
    public int getGreen() {
        Color c = this.getColor();
        return c == this ? super.getGreen() : c.getGreen();
    }

    @Override
    public int getBlue() {
        Color c = this.getColor();
        return c == this ? super.getBlue() : c.getBlue();
    }

    @Override
    public int getAlpha() {
        Color c = this.getColor();
        return c == this ? super.getAlpha() : c.getAlpha();
    }

    @Override
    public int getRGB() {
        Color c = this.getColor();
        return c == this ? super.getRGB() : c.getRGB();
    }

    @Override
    public Color brighter() {
        if (this.func != null) {
            return new JBColor(new NotNullProducer<Color>(){

                @Override
                @NotNull
                public Color produce() {
                    Color color = ((Color)JBColor.this.func.produce()).brighter();
                    if (color == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/JBColor$1", "produce"));
                }
            });
        }
        return new JBColor(super.brighter(), this.getDarkVariant().brighter());
    }

    @Override
    public Color darker() {
        if (this.func != null) {
            return new JBColor(new NotNullProducer<Color>(){

                @Override
                @NotNull
                public Color produce() {
                    Color color = ((Color)JBColor.this.func.produce()).darker();
                    if (color == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/JBColor$2", "produce"));
                }
            });
        }
        return new JBColor(super.darker(), this.getDarkVariant().darker());
    }

    @Override
    public int hashCode() {
        Color c = this.getColor();
        return c == this ? super.hashCode() : c.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        Color c = this.getColor();
        return c == this ? super.equals(obj) : c.equals(obj);
    }

    @Override
    public String toString() {
        Color c = this.getColor();
        return c == this ? super.toString() : c.toString();
    }

    @Override
    public float[] getRGBComponents(float[] compArray) {
        Color c = this.getColor();
        return c == this ? super.getRGBComponents(compArray) : c.getRGBComponents(compArray);
    }

    @Override
    public float[] getRGBColorComponents(float[] compArray) {
        Color c = this.getColor();
        return c == this ? super.getRGBComponents(compArray) : c.getRGBColorComponents(compArray);
    }

    @Override
    public float[] getComponents(float[] compArray) {
        Color c = this.getColor();
        return c == this ? super.getComponents(compArray) : c.getComponents(compArray);
    }

    @Override
    public float[] getColorComponents(float[] compArray) {
        Color c = this.getColor();
        return c == this ? super.getColorComponents(compArray) : c.getColorComponents(compArray);
    }

    @Override
    public float[] getComponents(ColorSpace cspace, float[] compArray) {
        Color c = this.getColor();
        return c == this ? super.getComponents(cspace, compArray) : c.getComponents(cspace, compArray);
    }

    @Override
    public float[] getColorComponents(ColorSpace cspace, float[] compArray) {
        Color c = this.getColor();
        return c == this ? super.getColorComponents(cspace, compArray) : c.getColorComponents(cspace, compArray);
    }

    @Override
    public ColorSpace getColorSpace() {
        Color c = this.getColor();
        return c == this ? super.getColorSpace() : c.getColorSpace();
    }

    @Override
    public synchronized PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform xform, RenderingHints hints) {
        Color c = this.getColor();
        return c == this ? super.createContext(cm, r, r2d, xform, hints) : c.createContext(cm, r, r2d, xform, hints);
    }

    @Override
    public int getTransparency() {
        Color c = this.getColor();
        return c == this ? super.getTransparency() : c.getTransparency();
    }

    public static Color foreground() {
        return new JBColor(new NotNullProducer<Color>(){

            @Override
            @NotNull
            public Color produce() {
                Color color = UIUtil.getLabelForeground();
                if (color == null) {
                    4.$$$reportNull$$$0(0);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/JBColor$4", "produce"));
            }
        });
    }

    public static Color background() {
        return new JBColor(new NotNullProducer<Color>(){

            @Override
            @NotNull
            public Color produce() {
                Color color = UIUtil.getListBackground();
                if (color == null) {
                    5.$$$reportNull$$$0(0);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/JBColor$5", "produce"));
            }
        });
    }

    public static Color border() {
        return new JBColor(new NotNullProducer<Color>(){

            @Override
            @NotNull
            public Color produce() {
                Color color = UIUtil.getBorderColor();
                if (color == null) {
                    6.$$$reportNull$$$0(0);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/JBColor$6", "produce"));
            }
        });
    }

    static {
        RED = red = new JBColor(Color.red, DarculaColors.RED);
        BLUE = blue = new JBColor(Color.blue, DarculaColors.BLUE);
        WHITE = white = new JBColor(Color.white, UIUtil.getListBackground()){

            @Override
            Color getDarkVariant() {
                return UIUtil.getListBackground();
            }
        };
        BLACK = black = new JBColor(Color.black, JBColor.foreground());
        GRAY = gray = new JBColor(Gray._128, Gray._128);
        LIGHT_GRAY = lightGray = new JBColor(Gray._192, Gray._64);
        DARK_GRAY = darkGray = new JBColor(Gray._64, Gray._192);
        PINK = pink = new JBColor(Color.pink, Color.pink);
        ORANGE = orange = new JBColor(Color.orange, new Color(159, 107, 0));
        YELLOW = yellow = new JBColor(Color.yellow, new Color(138, 138, 0));
        GREEN = green = new JBColor(Color.green, new Color(98, 150, 85));
        MAGENTA = magenta = new JBColor(Color.magenta, new Color(151, 118, 169));
        CYAN = cyan = new JBColor(Color.cyan, new Color(0, 137, 137));
    }
}

