/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentIntKeyRefValueHashMap<V>
implements ConcurrentIntObjectMap<V> {
    private final ConcurrentIntObjectMap<IntReference<V>> myMap = ContainerUtil.createConcurrentIntObjectMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    ConcurrentIntKeyRefValueHashMap() {
    }

    @NotNull
    protected abstract IntReference<V> createReference(int var1, @NotNull V var2, @NotNull ReferenceQueue<V> var3);

    private void processQueue() {
        IntReference ref;
        while ((ref = (IntReference)((Object)this.myQueue.poll())) != null) {
            int key = ref.getKey();
            this.myMap.remove(key, ref);
        }
        return;
    }

    @Override
    @NotNull
    public V cacheOrGet(int key, @NotNull V value) {
        IntReference<V> ref;
        boolean replaced;
        if (value == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(0);
        }
        this.processQueue();
        IntReference<V> newRef = this.createReference(key, value, this.myQueue);
        do {
            if ((ref = this.myMap.putIfAbsent(key, newRef)) == null) {
                V v = value;
                if (v == null) {
                    ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(1);
                }
                return v;
            }
            V old = ref.get();
            if (old == null) continue;
            V v = old;
            if (v == null) {
                ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(2);
            }
            return v;
        } while (!(replaced = this.myMap.replace(key, ref, newRef)));
        V v = value;
        if (v == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(3);
        }
        return v;
    }

    @Override
    public boolean remove(int key, @NotNull V value) {
        if (value == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(4);
        }
        this.processQueue();
        return this.myMap.remove(key, this.createReference(key, value, this.myQueue));
    }

    @Override
    public boolean replace(int key, @NotNull V oldValue, @NotNull V newValue) {
        if (oldValue == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(5);
        }
        if (newValue == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(6);
        }
        this.processQueue();
        return this.myMap.replace(key, this.createReference(key, oldValue, this.myQueue), this.createReference(key, newValue, this.myQueue));
    }

    @Override
    public V put(int key, @NotNull V value) {
        if (value == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(7);
        }
        this.processQueue();
        IntReference<V> ref = this.myMap.put(key, this.createReference(key, value, this.myQueue));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V get(int key) {
        IntReference<V> ref = this.myMap.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(int key) {
        this.processQueue();
        IntReference<V> ref = this.myMap.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public boolean containsKey(int key) {
        return this.myMap.containsKey(key);
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    @NotNull
    public int[] keys() {
        int[] nArray = this.myMap.keys();
        if (nArray == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(8);
        }
        return nArray;
    }

    @Override
    @NotNull
    public Iterable<ConcurrentIntObjectMap.IntEntry<V>> entries() {
        final Iterator<ConcurrentIntObjectMap.IntEntry<IntReference<V>>> entryIterator = this.myMap.entries().iterator();
        Iterable iterable = new Iterable<ConcurrentIntObjectMap.IntEntry<V>>(){

            @Override
            public Iterator<ConcurrentIntObjectMap.IntEntry<V>> iterator() {
                return new Iterator<ConcurrentIntObjectMap.IntEntry<V>>(){
                    private ConcurrentIntObjectMap.IntEntry<V> next = this.nextAliveEntry();

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public ConcurrentIntObjectMap.IntEntry<V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ConcurrentIntObjectMap.IntEntry result = this.next;
                        this.next = this.nextAliveEntry();
                        return result;
                    }

                    private ConcurrentIntObjectMap.IntEntry<V> nextAliveEntry() {
                        while (entryIterator.hasNext()) {
                            ConcurrentIntObjectMap.IntEntry entry = (ConcurrentIntObjectMap.IntEntry)entryIterator.next();
                            final Object v = ((IntReference)entry.getValue()).get();
                            if (v == null) continue;
                            final int key = entry.getKey();
                            return new ConcurrentIntObjectMap.IntEntry<V>(){

                                @Override
                                public int getKey() {
                                    return key;
                                }

                                @Override
                                @NotNull
                                public V getValue() {
                                    Object object = v;
                                    if (object == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    return object;
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentIntKeyRefValueHashMap$1$1$1", "getValue"));
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (iterable == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(9);
        }
        return iterable;
    }

    @Override
    public int size() {
        this.processQueue();
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.myMap.isEmpty();
    }

    @Override
    @NotNull
    public Enumeration<V> elements() {
        final Enumeration<IntReference<V>> elementRefs = this.myMap.elements();
        Enumeration enumeration = new Enumeration<V>(){
            private V next = this.findNextRef();

            private V findNextRef() {
                while (elementRefs.hasMoreElements()) {
                    IntReference result = (IntReference)elementRefs.nextElement();
                    Object v = result.get();
                    if (v == null) continue;
                    return v;
                }
                return null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            @Override
            public V nextElement() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object v = this.next;
                this.next = this.findNextRef();
                return v;
            }
        };
        if (enumeration == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(10);
        }
        return enumeration;
    }

    @Override
    public V putIfAbsent(int key, @NotNull V value) {
        V oldVal;
        block3: {
            IntReference<V> oldRef;
            if (value == null) {
                ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(11);
            }
            IntReference<V> newRef = this.createReference(key, value, this.myQueue);
            do {
                this.processQueue();
                oldRef = this.myMap.putIfAbsent(key, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block3;
            } while (!this.myMap.replace(key, oldRef, newRef));
            return null;
        }
        return oldVal;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        THashSet result = new THashSet();
        ContainerUtil.addAll(result, this.elements());
        THashSet tHashSet = result;
        if (tHashSet == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(12);
        }
        return tHashSet;
    }

    @Override
    public boolean containsValue(@NotNull V value) {
        if (value == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(13);
        }
        for (ConcurrentIntObjectMap.IntEntry<IntReference<V>> entry : this.myMap.entries()) {
            if (!value.equals(entry.getValue().get())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentIntKeyRefValueHashMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentIntKeyRefValueHashMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheOrGet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "entries";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "elements";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cacheOrGet";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface IntReference<V> {
        public int getKey();

        public V get();
    }
}

