/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.awt.event.KeyEvent;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyboardLayoutUtil {
    private static final Map<Character, Character> ourLLtoASCII = ContainerUtil.newConcurrentMap();

    @Nullable
    public static Character getAsciiForChar(char a) {
        char lc = Character.toLowerCase(a);
        Character c = ourLLtoASCII.get(Character.valueOf(lc));
        if (c == null && (ourLLtoASCII.isEmpty() || SystemInfo.isLinux)) {
            c = (Character)HardCoded.LL.get(Character.valueOf(lc));
        }
        return c == null ? null : Character.valueOf(lc == a ? c.charValue() : Character.toUpperCase(c.charValue()));
    }

    public static void storeAsciiForChar(@NotNull KeyEvent e) {
        int id;
        if (e == null) {
            KeyboardLayoutUtil.$$$reportNull$$$0(0);
        }
        if ((id = e.getID()) != 401) {
            return;
        }
        int mods = e.getModifiers();
        int code = e.getKeyCode();
        char aChar = e.getKeyChar();
        if ((mods & 0xFFFFFFFE & 0xFFFFFFBF) != 0) {
            return;
        }
        if (code < 65 || code > 90) {
            return;
        }
        if (aChar == '\uffff') {
            return;
        }
        if ('a' <= aChar && aChar <= 'z' || 'A' <= aChar && aChar <= 'Z') {
            return;
        }
        if (ourLLtoASCII.containsKey(Character.valueOf(aChar))) {
            return;
        }
        ourLLtoASCII.put(Character.valueOf(aChar), Character.valueOf((char)(97 + (code - 65))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/KeyboardLayoutUtil", "storeAsciiForChar"));
    }

    private static class HardCoded {
        private static final Map<Character, Character> LL = ContainerUtilRt.newHashMap(33);

        private HardCoded() {
        }

        static {
            char[] layout = new char[]{'\u0439', 'q', '\u0446', 'w', '\u0443', 'e', '\u043a', 'r', '\u0435', 't', '\u043d', 'y', '\u0433', 'u', '\u0448', 'i', '\u0449', 'o', '\u0437', 'p', '\u0445', '[', '\u044a', ']', '\u0444', 'a', '\u044b', 's', '\u0432', 'd', '\u0430', 'f', '\u043f', 'g', '\u0440', 'h', '\u043e', 'j', '\u043b', 'k', '\u0434', 'l', '\u0436', ';', '\u044d', '\'', '\u044f', 'z', '\u0447', 'x', '\u0441', 'c', '\u043c', 'v', '\u0438', 'b', '\u0442', 'n', '\u044c', 'm', '\u0431', ',', '\u044e', '.', '.', '/'};
            int i = 0;
            while (i < layout.length) {
                LL.put(Character.valueOf(layout[i++]), Character.valueOf(layout[i++]));
            }
        }
    }
}

