/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.run.sphinx;

import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rest.RestFile;
import com.jetbrains.rest.run.RestRunConfiguration;
import com.jetbrains.rest.run.RestRunConfigurationType;
import com.jetbrains.rest.run.sphinx.SphinxRunConfiguration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SphinxConfigurationProducer
extends RuntimeConfigurationProducer
implements Cloneable {
    private PsiDirectory mySourceFile = null;

    public SphinxConfigurationProducer() {
        super(RestRunConfigurationType.getInstance().SPHINX_FACTORY);
    }

    public PsiElement getSourceElement() {
        return this.mySourceFile;
    }

    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context) {
        VirtualFile parent;
        PsiElement element = location.getPsiElement();
        if (!(element instanceof PsiDirectory)) {
            return null;
        }
        this.mySourceFile = (PsiDirectory)element;
        boolean hasRstFile = false;
        boolean hasConf = false;
        for (PsiFile file : this.mySourceFile.getFiles()) {
            if ("conf.py".equals(file.getName())) {
                hasConf = true;
            }
            if (!(file instanceof RestFile)) continue;
            hasRstFile = true;
        }
        if (!hasRstFile || !hasConf) {
            return null;
        }
        Project project = this.mySourceFile.getProject();
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(project, context);
        SphinxRunConfiguration configuration = (SphinxRunConfiguration)settings.getConfiguration();
        VirtualFile vFile = this.mySourceFile.getVirtualFile();
        configuration.setInputFile(vFile.getPath());
        configuration.setName(((PsiDirectory)element).getName());
        if (configuration.getTask().isEmpty()) {
            configuration.setTask("html");
        }
        if ((parent = vFile.getParent()) != null) {
            configuration.setWorkingDirectory(parent.getPath());
        }
        configuration.setName(configuration.suggestedName());
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module != null) {
            configuration.setUseModuleSdk(true);
            configuration.setModule(module);
        }
        return settings;
    }

    @Nullable
    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurations, ConfigurationContext context) {
        PsiElement element;
        if (existingConfigurations == null) {
            SphinxConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (!((element = location.getPsiElement()) instanceof PsiDirectory)) {
            return null;
        }
        VirtualFile vFile = ((PsiDirectory)element).getVirtualFile();
        String path = vFile.getPath();
        for (RunnerAndConfigurationSettings configuration : existingConfigurations) {
            String scriptName = ((RestRunConfiguration)configuration.getConfiguration()).getInputFile();
            if (!FileUtil.toSystemIndependentName((String)scriptName).equals(FileUtil.toSystemIndependentName((String)path))) continue;
            return configuration;
        }
        return null;
    }

    public int compareTo(Object o) {
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingConfigurations", "com/jetbrains/rest/run/sphinx/SphinxConfigurationProducer", "findExistingByElement"));
    }
}

