/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.sphinx;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.jetbrains.rest.RestPythonUtil;
import com.jetbrains.rest.sphinx.SphinxBaseCommand;

public class RunSphinxQuickStartAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent event) {
        super.update(event);
        RestPythonUtil.updateSphinxQuickStartRequiredAction(event);
    }

    public void actionPerformed(AnActionEvent e) {
        Presentation presentation = RestPythonUtil.updateSphinxQuickStartRequiredAction(e);
        assert (presentation.isEnabled() && presentation.isVisible()) : "Sphinx requirements for action are not satisfied";
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module == null) {
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            Module module2 = module = modules.length == 0 ? null : modules[0];
        }
        if (module == null) {
            return;
        }
        SphinxBaseCommand action = new SphinxBaseCommand();
        Module finalModule = module;
        ApplicationManager.getApplication().invokeLater(() -> action.execute(finalModule), ModalityState.NON_MODAL);
    }
}

