/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.fogbugz;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import icons.TasksCoreIcons;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="FogBugz")
public class FogBugzRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.fogbugz.FogBugzRepository");
    private String myToken;

    public FogBugzRepository(TaskRepositoryType type) {
        super(type);
        this.setUrl("https://example.fogbugz.com");
    }

    private FogBugzRepository(FogBugzRepository other) {
        super((BaseRepositoryImpl)other);
        this.myToken = other.myToken;
    }

    public boolean equals(Object o) {
        return super.equals(o) && Comparing.equal((String)this.myToken, (String)((FogBugzRepository)((Object)o)).myToken);
    }

    public FogBugzRepository() {
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        return this.getCases(StringUtil.notNullize((String)query));
    }

    private Task[] getCases(String q) throws Exception {
        this.loginIfNeeded();
        PostMethod method = new PostMethod(this.getUrl() + "/api.asp");
        method.addParameter("token", this.myToken);
        method.addParameter("cmd", "search");
        method.addParameter("q", q);
        method.addParameter("cols", "sTitle,fOpen,dtOpened,dtLastUpdated,ixCategory");
        int status = this.getHttpClient().executeMethod((HttpMethod)method);
        if (status != 200) {
            throw new Exception("Error listing cases: " + method.getStatusLine());
        }
        Document document = new SAXBuilder(false).build(method.getResponseBodyAsStream()).getDocument();
        List errorNodes = XPath.newInstance((String)"/response/error").selectNodes((Object)document);
        if (!errorNodes.isEmpty()) {
            throw new Exception("Error listing cases: " + ((Element)errorNodes.get(0)).getText());
        }
        XPath commentPath = XPath.newInstance((String)"events/event");
        List nodes = XPath.newInstance((String)"/response/cases/case").selectNodes((Object)document);
        List tasks = ContainerUtil.mapNotNull((Collection)nodes, (Function)((NotNullFunction)element -> this.createCase((Element)element, commentPath)));
        return tasks.toArray(new Task[tasks.size()]);
    }

    private static TaskType getType(Element element) {
        String category = element.getChildText("ixCategory");
        if ("1".equals(category)) {
            return TaskType.BUG;
        }
        if ("2".equals(category)) {
            return TaskType.FEATURE;
        }
        return TaskType.OTHER;
    }

    @NotNull
    private Task createCase(final Element element, final XPath commentPath) {
        final String id = element.getAttributeValue("ixBug");
        final String title = element.getChildTextTrim("sTitle");
        final TaskType type = FogBugzRepository.getType(element);
        Task task = new Task(){

            @NotNull
            public String getId() {
                String string = id;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = title;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            public String getDescription() {
                return null;
            }

            @NotNull
            public Comment[] getComments() {
                List nodes;
                try {
                    nodes = commentPath.selectNodes((Object)element);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error selecting comment nodes", e);
                }
                List comments = ContainerUtil.mapNotNull((Collection)nodes, (Function)new NotNullFunction<Element, Comment>(){

                    @NotNull
                    public Comment fun(Element element) {
                        Comment comment = this.createComment(element);
                        if (comment == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return comment;
                    }

                    private Comment createComment(final Element element) {
                        return new Comment(){

                            public String getText() {
                                return element.getChildTextTrim("s");
                            }

                            @Nullable
                            public String getAuthor() {
                                return element.getChildTextTrim("sPerson");
                            }

                            @Nullable
                            public Date getDate() {
                                return FogBugzRepository.parseDate(element.getChildTextTrim("dt"));
                            }
                        };
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/fogbugz/FogBugzRepository$1$1", "fun"));
                    }
                });
                Comment[] commentArray = comments.toArray(new Comment[comments.size()]);
                if (commentArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return commentArray;
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = TasksCoreIcons.Fogbugz;
                if (icon == null) {
                    1.$$$reportNull$$$0(3);
                }
                return icon;
            }

            @NotNull
            public TaskType getType() {
                TaskType taskType = type;
                if (taskType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return taskType;
            }

            @Nullable
            public Date getUpdated() {
                return FogBugzRepository.parseDate(element.getChildText("dtLastUpdated"));
            }

            @Nullable
            public Date getCreated() {
                return FogBugzRepository.parseDate(element.getChildTextTrim("dtOpened"));
            }

            public boolean isClosed() {
                return Boolean.valueOf(element.getChildTextTrim("fOpen")) == false;
            }

            public boolean isIssue() {
                return true;
            }

            @Nullable
            public String getIssueUrl() {
                return FogBugzRepository.this.getUrl() + "/default.asp?" + this.getId();
            }

            @Nullable
            public TaskRepository getRepository() {
                return FogBugzRepository.this;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/tasks/fogbugz/FogBugzRepository$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummary";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (task == null) {
            FogBugzRepository.$$$reportNull$$$0(0);
        }
        return task;
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        if (id == null) {
            FogBugzRepository.$$$reportNull$$$0(1);
        }
        Task[] tasks = this.getCases(id);
        switch (tasks.length) {
            case 0: {
                return null;
            }
            case 1: {
                return tasks[0];
            }
        }
        LOG.warn("Expected unique case for case id: " + id + ", got " + tasks.length + " instead. Using the first one.");
        return tasks[0];
    }

    @NotNull
    public BaseRepository clone() {
        FogBugzRepository fogBugzRepository = new FogBugzRepository(this);
        if (fogBugzRepository == null) {
            FogBugzRepository.$$$reportNull$$$0(2);
        }
        return fogBugzRepository;
    }

    private void loginIfNeeded() throws Exception {
        if (StringUtil.isEmpty((String)this.myToken)) {
            this.login(this.getLoginMethod());
        }
    }

    private void login(@NotNull PostMethod method) throws Exception {
        if (method == null) {
            FogBugzRepository.$$$reportNull$$$0(3);
        }
        LOG.debug("Requesting new token");
        int status = this.getHttpClient().executeMethod((HttpMethod)method);
        if (status != 200) {
            throw new Exception("Error logging in: " + method.getStatusLine());
        }
        Document document = new SAXBuilder(false).build(method.getResponseBodyAsStream()).getDocument();
        XPath path = XPath.newInstance((String)"/response/token");
        Element result = (Element)path.selectSingleNode((Object)document);
        if (result == null) {
            Element error = (Element)XPath.newInstance((String)"/response/error").selectSingleNode((Object)document);
            throw new Exception(error == null ? "Error logging in" : error.getText());
        }
        this.myToken = result.getTextTrim();
    }

    @NotNull
    private PostMethod getLoginMethod() {
        PostMethod method = new PostMethod(this.getUrl() + "/api.asp");
        method.addParameter("cmd", "logon");
        method.addParameter("email", this.getUsername());
        method.addParameter("password", this.getPassword());
        PostMethod postMethod = method;
        if (postMethod == null) {
            FogBugzRepository.$$$reportNull$$$0(4);
        }
        return postMethod;
    }

    @NotNull
    private PostMethod getLogoutMethod() throws Exception {
        PostMethod method = new PostMethod(this.getUrl() + "/api.asp");
        method.addParameter("cmd", "logoff");
        assert (this.myToken != null);
        method.addParameter("token", this.myToken);
        PostMethod postMethod = method;
        if (postMethod == null) {
            FogBugzRepository.$$$reportNull$$$0(5);
        }
        return postMethod;
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){
            PostMethod myMethod;

            protected void doTest() throws Exception {
                if (StringUtil.isNotEmpty((String)FogBugzRepository.this.myToken)) {
                    this.myMethod = FogBugzRepository.this.getLogoutMethod();
                    LOG.debug("Revoking previously used token");
                    FogBugzRepository.this.getHttpClient().executeMethod((HttpMethod)this.myMethod);
                }
                this.myMethod = FogBugzRepository.this.getLoginMethod();
                FogBugzRepository.this.login(this.myMethod);
            }

            public void cancel() {
                if (this.myMethod != null) {
                    this.myMethod.abort();
                }
            }
        };
    }

    @NotNull
    private static Date parseDate(@NotNull String string) {
        Date date;
        if (string == null) {
            FogBugzRepository.$$$reportNull$$$0(6);
        }
        try {
            date = DatatypeFactory.newInstance().newXMLGregorianCalendar(string).toGregorianCalendar().getTime();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Error configuring datatype factory", e);
        }
        if (date == null) {
            FogBugzRepository.$$$reportNull$$$0(7);
        }
        return date;
    }

    public String getComment() {
        return "{id} (e.g. 2344245), {summary}";
    }

    @Tag(value="token")
    @NotNull
    public String getEncodedToken() {
        String string = PasswordUtil.encodePassword((String)this.myToken);
        if (string == null) {
            FogBugzRepository.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setEncodedToken(@Nullable String token) {
        try {
            this.myToken = PasswordUtil.decodePassword((String)token);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/fogbugz/FogBugzRepository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCase";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/fogbugz/FogBugzRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoginMethod";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogoutMethod";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEncodedToken";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "login";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

