/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.mantis;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.TaskUiUtil;
import com.intellij.tasks.mantis.MantisFilter;
import com.intellij.tasks.mantis.MantisProject;
import com.intellij.tasks.mantis.MantisRepository;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MantisRepositoryEditor
extends BaseRepositoryEditor<MantisRepository> {
    private ComboBox myProjectCombobox;
    private ComboBox myFilterCombobox;
    private JBLabel myProjectLabel;
    private JBLabel myFilterLabel;
    private boolean myInitialized = false;

    public MantisRepositoryEditor(Project project, MantisRepository repository, Consumer<MantisRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
        this.myTestButton.setText("Login");
        this.myTestButton.setEnabled(((MantisRepository)this.myRepository).isConfigured());
        this.myProjectCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MantisProject project;
                if (e.getStateChange() == 1 && (project = (MantisProject)MantisRepositoryEditor.this.myProjectCombobox.getSelectedItem()) != null) {
                    MantisRepositoryEditor.this.myFilterCombobox.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(project.getFilters())));
                    if (!project.equals(((MantisRepository)MantisRepositoryEditor.this.myRepository).getCurrentProject())) {
                        MantisRepositoryEditor.this.myFilterCombobox.setSelectedIndex(0);
                        MantisRepositoryEditor.this.doApply();
                    } else if (!MantisRepositoryEditor.this.myInitialized) {
                        MantisRepositoryEditor.this.myFilterCombobox.setSelectedItem((Object)((MantisRepository)MantisRepositoryEditor.this.myRepository).getCurrentFilter());
                        MantisRepositoryEditor.this.myInitialized = true;
                    }
                }
            }
        });
        this.installListener((JComboBox)this.myFilterCombobox);
        if (((MantisRepository)this.myRepository).getCurrentProject() != null) {
            UIUtil.invokeLaterIfNeeded(() -> new FetchMantisProjects().queue());
        }
    }

    public void apply() {
        super.apply();
        ((MantisRepository)this.myRepository).setCurrentProject((MantisProject)this.myProjectCombobox.getSelectedItem());
        ((MantisRepository)this.myRepository).setCurrentFilter((MantisFilter)this.myFilterCombobox.getSelectedItem());
        this.myTestButton.setEnabled(((MantisRepository)this.myRepository).isConfigured());
    }

    protected void afterTestConnection(boolean connectionSuccessful) {
        super.afterTestConnection(connectionSuccessful);
        if (connectionSuccessful) {
            new FetchMantisProjects().queue();
        } else {
            this.myProjectCombobox.removeAllItems();
            this.myFilterCombobox.removeAllItems();
        }
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myProjectLabel.setAnchor(anchor);
        this.myFilterLabel.setAnchor(anchor);
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.myProjectLabel = new JBLabel("Project:", 4);
        this.myProjectCombobox = new ComboBox(200);
        this.myProjectCombobox.setRenderer(new TaskUiUtil.SimpleComboBoxRenderer("Login first"));
        this.myFilterLabel = new JBLabel("Filter:", 4);
        this.myFilterCombobox = new ComboBox(200);
        this.myFilterCombobox.setRenderer(new TaskUiUtil.SimpleComboBoxRenderer("Login first"));
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myProjectLabel, (JComponent)this.myProjectCombobox).addLabeledComponent((JComponent)this.myFilterLabel, (JComponent)this.myFilterCombobox).getPanel();
    }

    private class FetchMantisProjects
    extends TaskUiUtil.ComboBoxUpdater<MantisProject> {
        private FetchMantisProjects() {
            super(MantisRepositoryEditor.this.myProject, "Downloading Mantis Projects...", (JComboBox)MantisRepositoryEditor.this.myProjectCombobox);
        }

        @Override
        @NotNull
        protected List<MantisProject> fetch(@NotNull ProgressIndicator indicator) throws Exception {
            if (indicator == null) {
                FetchMantisProjects.$$$reportNull$$$0(0);
            }
            ((MantisRepository)MantisRepositoryEditor.this.myRepository).refreshProjects();
            List<MantisProject> list = ((MantisRepository)MantisRepositoryEditor.this.myRepository).getProjects();
            if (list == null) {
                FetchMantisProjects.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @Nullable
        public MantisProject getSelectedItem() {
            return ((MantisRepository)MantisRepositoryEditor.this.myRepository).getCurrentProject();
        }

        @Override
        protected void handleError() {
            super.handleError();
            MantisRepositoryEditor.this.myFilterCombobox.removeAllItems();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/mantis/MantisRepositoryEditor$FetchMantisProjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/mantis/MantisRepositoryEditor$FetchMantisProjects";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fetch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fetch";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

