/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.CustomResourceBundle;
import com.intellij.lang.properties.CustomResourceBundleState;
import com.intellij.lang.properties.EmptyResourceBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.ResourceBundleManagerState;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ResourceBundleManager", storages={@Storage(value="resourceBundles.xml")})
public class ResourceBundleManager
implements PersistentStateComponent<ResourceBundleManagerState> {
    private static final Logger LOG = Logger.getInstance(ResourceBundleManager.class);
    private ResourceBundleManagerState myState = new ResourceBundleManagerState();

    public ResourceBundleManager(PsiManager manager) {
        manager.addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childMoved(final @NotNull PsiTreeChangeEvent event) {
                PsiElement child;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((child = event.getChild()) instanceof PsiFile)) {
                    if (child instanceof PsiDirectory && event.getOldParent() instanceof PsiDirectory && event.getNewParent() instanceof PsiDirectory) {
                        String fromDirUrl = ((PsiDirectory)event.getOldParent()).getVirtualFile().getUrl() + "/";
                        NotNullLazyValue<String> toDirUrl = new NotNullLazyValue<String>(){

                            @NotNull
                            protected String compute() {
                                String string = ((PsiDirectory)event.getNewParent()).getVirtualFile().getUrl() + "/";
                                if (string == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return string;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleManager$1$1", "compute"));
                            }
                        };
                        for (String dissociatedFileUrl : new SmartList(ResourceBundleManager.this.myState.getDissociatedFiles())) {
                            if (!dissociatedFileUrl.startsWith(fromDirUrl)) continue;
                            ResourceBundleManager.this.myState.getDissociatedFiles().remove(dissociatedFileUrl);
                            ResourceBundleManager.this.myState.getDissociatedFiles().add((String)toDirUrl.getValue() + dissociatedFileUrl.substring(fromDirUrl.length()));
                        }
                        for (CustomResourceBundleState customResourceBundleState : ResourceBundleManager.this.myState.getCustomResourceBundles()) {
                            for (String fileUrl : new SmartList(customResourceBundleState.getFileUrls())) {
                                if (!fileUrl.startsWith(fromDirUrl)) continue;
                                customResourceBundleState.getFileUrls().remove(fileUrl);
                                customResourceBundleState.getFileUrls().add((String)toDirUrl.getValue() + fileUrl.substring(fromDirUrl.length()));
                            }
                        }
                    }
                    return;
                }
                final PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)child);
                if (propertiesFile == null) {
                    return;
                }
                final String oldParentUrl = this.getUrl(event.getOldParent());
                if (oldParentUrl == null) {
                    return;
                }
                final String newParentUrl = this.getUrl(event.getNewParent());
                if (newParentUrl == null) {
                    return;
                }
                NotNullLazyValue<Pair<String, String>> oldAndNewUrls = new NotNullLazyValue<Pair<String, String>>(){

                    @NotNull
                    protected Pair<String, String> compute() {
                        String newUrl = propertiesFile.getVirtualFile().getUrl();
                        Pair pair = Pair.create((Object)(oldParentUrl + newUrl.substring(newParentUrl.length())), (Object)newUrl);
                        if (pair == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return pair;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleManager$1$2", "compute"));
                    }
                };
                if (!ResourceBundleManager.this.myState.getDissociatedFiles().isEmpty() && ResourceBundleManager.this.myState.getDissociatedFiles().remove(((Pair)oldAndNewUrls.getValue()).getFirst())) {
                    ResourceBundleManager.this.myState.getDissociatedFiles().add((String)((Pair)oldAndNewUrls.getValue()).getSecond());
                }
                for (CustomResourceBundleState customResourceBundleState : ResourceBundleManager.this.myState.getCustomResourceBundles()) {
                    if (!customResourceBundleState.getFileUrls().remove(((Pair)oldAndNewUrls.getValue()).getFirst())) continue;
                    customResourceBundleState.getFileUrls().add((String)((Pair)oldAndNewUrls.getValue()).getSecond());
                    break;
                }
            }

            @Nullable
            private String getUrl(PsiElement element) {
                return !(element instanceof PsiDirectory) ? null : ((PsiDirectory)element).getVirtualFile().getUrl();
            }

            public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
                PsiElement child;
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!((child = event.getChild()) instanceof PsiFile)) {
                    if (child instanceof PsiDirectory) {
                        String deletedDirUrl = ((PsiDirectory)child).getVirtualFile().getUrl() + "/";
                        for (String dissociatedFileUrl : new SmartList(ResourceBundleManager.this.myState.getDissociatedFiles())) {
                            if (!dissociatedFileUrl.startsWith(deletedDirUrl)) continue;
                            ResourceBundleManager.this.myState.getDissociatedFiles().remove(dissociatedFileUrl);
                        }
                        for (CustomResourceBundleState customResourceBundleState : new SmartList(ResourceBundleManager.this.myState.getCustomResourceBundles())) {
                            for (String fileUrl : new ArrayList<String>(customResourceBundleState.getFileUrls())) {
                                if (!fileUrl.startsWith(deletedDirUrl)) continue;
                                customResourceBundleState.getFileUrls().remove(fileUrl);
                            }
                            if (customResourceBundleState.getFileUrls().size() >= 2) continue;
                            ResourceBundleManager.this.myState.getCustomResourceBundles().remove(customResourceBundleState);
                        }
                    }
                    return;
                }
                PsiFile psiFile = (PsiFile)child;
                if (!PropertiesImplUtil.canBePropertyFile(psiFile)) {
                    return;
                }
                final VirtualFile virtualFile = psiFile.getVirtualFile();
                NotNullLazyValue<String> url = new NotNullLazyValue<String>(){

                    @NotNull
                    protected String compute() {
                        String string = virtualFile.getUrl();
                        if (string == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleManager$1$3", "compute"));
                    }
                };
                if (!ResourceBundleManager.this.myState.getDissociatedFiles().isEmpty()) {
                    ResourceBundleManager.this.myState.getDissociatedFiles().remove(url.getValue());
                }
                for (CustomResourceBundleState customResourceBundleState : new SmartList(ResourceBundleManager.this.myState.getCustomResourceBundles())) {
                    Set<String> urls = customResourceBundleState.getFileUrls();
                    if (!urls.remove(url.getValue())) continue;
                    if (urls.size() >= 2) break;
                    ResourceBundleManager.this.myState.getCustomResourceBundles().remove(customResourceBundleState);
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/lang/properties/ResourceBundleManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeChildRemoval";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static ResourceBundleManager getInstance(Project project) {
        return (ResourceBundleManager)ServiceManager.getService((Project)project, ResourceBundleManager.class);
    }

    @Nullable
    public String getFullName(@NotNull PropertiesFile propertiesFile) {
        if (propertiesFile == null) {
            ResourceBundleManager.$$$reportNull$$$0(0);
        }
        return (String)ReadAction.compute(() -> {
            PsiDirectory directory;
            String packageQualifiedName;
            if (propertiesFile == null) {
                ResourceBundleManager.$$$reportNull$$$0(12);
            }
            if ((packageQualifiedName = PropertiesUtil.getPackageQualifiedName(directory = propertiesFile.getParent())) == null) {
                return null;
            }
            StringBuilder qName = new StringBuilder(packageQualifiedName);
            if (qName.length() > 0) {
                qName.append(".");
            }
            qName.append(this.getBaseName(propertiesFile.getContainingFile()));
            return qName.toString();
        });
    }

    @NotNull
    public String getBaseName(@NotNull PsiFile file) {
        VirtualFile vFile;
        CustomResourceBundleState customResourceBundle;
        if (file == null) {
            ResourceBundleManager.$$$reportNull$$$0(1);
        }
        if ((customResourceBundle = this.getCustomResourceBundleState(vFile = file.getVirtualFile())) != null) {
            String string = customResourceBundle.getBaseName();
            if (string == null) {
                ResourceBundleManager.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (this.isDefaultDissociated(vFile)) {
            String string = vFile.getNameWithoutExtension();
            if (string == null) {
                ResourceBundleManager.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = PropertiesUtil.getDefaultBaseName(file);
        if (string == null) {
            ResourceBundleManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void dissociateResourceBundle(@NotNull ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            ResourceBundleManager.$$$reportNull$$$0(5);
        }
        ResourceBundleManager.closeResourceBundleEditors(resourceBundle);
        if (resourceBundle instanceof CustomResourceBundle) {
            CustomResourceBundleState state = this.getCustomResourceBundleState(resourceBundle.getDefaultPropertiesFile().getVirtualFile());
            LOG.assertTrue(state != null);
            this.myState.getCustomResourceBundles().remove(state);
        } else {
            if (EmptyResourceBundle.getInstance() != resourceBundle) {
                ((ResourceBundleImpl)resourceBundle).invalidate();
            }
            for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
                VirtualFile file = propertiesFile.getContainingFile().getVirtualFile();
                this.myState.getDissociatedFiles().add(file.getUrl());
            }
        }
    }

    public void combineToResourceBundle(@NotNull List<PropertiesFile> propertiesFiles, String baseName) {
        if (propertiesFiles == null) {
            ResourceBundleManager.$$$reportNull$$$0(6);
        }
        this.myState.getCustomResourceBundles().add(new CustomResourceBundleState().addAll(ContainerUtil.map(propertiesFiles, file -> file.getVirtualFile().getUrl())).setBaseName(baseName));
    }

    public ResourceBundle combineToResourceBundleAndGet(@NotNull List<PropertiesFile> propertiesFiles, String baseName) {
        if (propertiesFiles == null) {
            ResourceBundleManager.$$$reportNull$$$0(7);
        }
        this.combineToResourceBundle(propertiesFiles, baseName);
        return propertiesFiles.get(0).getResourceBundle();
    }

    @Nullable
    public CustomResourceBundle getCustomResourceBundle(@NotNull PropertiesFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            ResourceBundleManager.$$$reportNull$$$0(8);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            return null;
        }
        CustomResourceBundleState state = this.getCustomResourceBundleState(virtualFile);
        return state == null ? null : CustomResourceBundle.fromState(state, file.getProject());
    }

    public boolean isDefaultDissociated(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ResourceBundleManager.$$$reportNull$$$0(9);
        }
        if (this.myState.getDissociatedFiles().isEmpty() && this.myState.getCustomResourceBundles().isEmpty()) {
            return false;
        }
        String url = virtualFile.getUrl();
        return this.myState.getDissociatedFiles().contains(url) || this.getCustomResourceBundleState(virtualFile) != null;
    }

    @Nullable
    private CustomResourceBundleState getCustomResourceBundleState(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ResourceBundleManager.$$$reportNull$$$0(10);
        }
        if (this.myState.getCustomResourceBundles().isEmpty()) {
            return null;
        }
        String url = virtualFile.getUrl();
        for (CustomResourceBundleState customResourceBundleState : this.myState.getCustomResourceBundles()) {
            if (!customResourceBundleState.getFileUrls().contains(url)) continue;
            return customResourceBundleState;
        }
        return null;
    }

    @Nullable
    public ResourceBundleManagerState getState() {
        return this.myState.isEmpty() ? null : this.myState;
    }

    public void loadState(ResourceBundleManagerState state) {
        this.myState = state.removeNonExistentFiles();
    }

    private static void closeResourceBundleEditors(@NotNull ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            ResourceBundleManager.$$$reportNull$$$0(11);
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)resourceBundle.getProject());
        fileEditorManager.closeFile((VirtualFile)new ResourceBundleAsVirtualFile(resourceBundle));
        for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
            fileEditorManager.closeFile(propertiesFile.getVirtualFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFile";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/ResourceBundleManager";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/ResourceBundleManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBaseName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dissociateResourceBundle";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "combineToResourceBundle";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "combineToResourceBundleAndGet";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCustomResourceBundle";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultDissociated";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCustomResourceBundleState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "closeResourceBundleEditors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFullName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

