/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config.ui;

import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ui.ConfigureCvsGlobalSettingsDialog;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Options;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CvsConfigurationPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.config.ui.CvsConfigurationPanel");
    private JPanel myPanel;
    private JCheckBox myMakeNewFilesReadOnly;
    private JComboBox myDefaultTextFileKeywordSubstitution;
    private JCheckBox myShowOutput;
    private ArrayList<CvsRootConfiguration> myConfigurations;
    private JButton myConfigureGlobalButton;
    private JRadioButton myGetLatestVersionOnMergedWithConflict;
    private JRadioButton mySkipOnMergedWithConflict;
    private JRadioButton myShowDialogOnMergedWithConflict;
    private final JRadioButton[] myOnFileMergedWithConflictGroup;

    public CvsConfigurationPanel(Project project) {
        JRadioButton[] jRadioButtonArray = new JRadioButton[3];
        this.$$$setupUI$$$();
        jRadioButtonArray[0] = this.myShowDialogOnMergedWithConflict;
        jRadioButtonArray[1] = this.myGetLatestVersionOnMergedWithConflict;
        jRadioButtonArray[2] = this.mySkipOnMergedWithConflict;
        this.myOnFileMergedWithConflictGroup = jRadioButtonArray;
        this.myConfigureGlobalButton.addActionListener(e -> {
            ConfigureCvsGlobalSettingsDialog dialog = new ConfigureCvsGlobalSettingsDialog(project);
            dialog.show();
        });
    }

    public static void addBrowseHandler(Project project, TextFieldWithBrowseButton field, String title) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        field.addBrowseFolderListener(title, null, project, descriptor, (TextComponentAccessor)new TextComponentAccessor<JTextField>(){

            public String getText(JTextField textField) {
                String text = textField.getText();
                if (!text.isEmpty()) {
                    text = CvsApplicationLevelConfiguration.convertToIOFilePath(text);
                }
                return text;
            }

            public void setText(JTextField textField, @NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                textField.setText(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/cvsSupport2/config/ui/CvsConfigurationPanel$1", "setText"));
            }
        });
    }

    public void updateFrom(CvsConfiguration config, CvsApplicationLevelConfiguration appLevelConfiguration) {
        this.myConfigurations = new ArrayList<CvsRootConfiguration>(appLevelConfiguration.CONFIGURATIONS);
        this.myShowOutput.setSelected(config.SHOW_OUTPUT);
        this.myMakeNewFilesReadOnly.setSelected(config.MAKE_NEW_FILES_READONLY);
        this.myOnFileMergedWithConflictGroup[config.SHOW_CORRUPTED_PROJECT_FILES].setSelected(true);
        this.myDefaultTextFileKeywordSubstitution.removeAllItems();
        for (KeywordSubstitutionWrapper keywordSubstitution : KeywordSubstitutionWrapper.values()) {
            this.myDefaultTextFileKeywordSubstitution.addItem(keywordSubstitution);
        }
        this.myDefaultTextFileKeywordSubstitution.setSelectedItem(KeywordSubstitutionWrapper.getValue(config.DEFAULT_TEXT_FILE_SUBSTITUTION));
    }

    @Options.Values
    private static int getSelected(JRadioButton[] group) {
        if (group[0].isSelected()) {
            return 0;
        }
        if (group[1].isSelected()) {
            return 1;
        }
        if (group[2].isSelected()) {
            return 2;
        }
        LOG.assertTrue(false);
        return -1;
    }

    public void saveTo(CvsConfiguration config, CvsApplicationLevelConfiguration appLevelConfiguration) {
        appLevelConfiguration.CONFIGURATIONS = this.myConfigurations;
        config.MAKE_NEW_FILES_READONLY = this.myMakeNewFilesReadOnly.isSelected();
        config.DEFAULT_TEXT_FILE_SUBSTITUTION = this.selectedSubstitution();
        config.SHOW_OUTPUT = this.myShowOutput.isSelected();
        config.SHOW_CORRUPTED_PROJECT_FILES = CvsConfigurationPanel.getSelected(this.myOnFileMergedWithConflictGroup);
    }

    private String selectedSubstitution() {
        return ((KeywordSubstitutionWrapper)this.myDefaultTextFileKeywordSubstitution.getSelectedItem()).getSubstitution().toString();
    }

    public boolean equalsTo(CvsConfiguration config, CvsApplicationLevelConfiguration appLevelConfiguration) {
        return new HashSet<CvsRootConfiguration>(appLevelConfiguration.CONFIGURATIONS).equals(new HashSet<CvsRootConfiguration>(this.myConfigurations)) && config.MAKE_NEW_FILES_READONLY == this.myMakeNewFilesReadOnly.isSelected() && config.SHOW_OUTPUT == this.myShowOutput.isSelected() && config.SHOW_CORRUPTED_PROJECT_FILES == CvsConfigurationPanel.getSelected(this.myOnFileMergedWithConflictGroup) && config.DEFAULT_TEXT_FILE_SUBSTITUTION.equals(this.selectedSubstitution());
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 2, 0, 0), -1, 0, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("border.title.update.options.updating.group"), (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.when.project.or.module.file.is.merged.with.conflicts.group"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowDialogOnMergedWithConflict = jRadioButton3 = new JRadioButton();
        jRadioButton3.setMargin(new Insets(5, 1, 5, 1));
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.show.dialog.when.project.file.corrupted"));
        jPanel3.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySkipOnMergedWithConflict = jRadioButton2 = new JRadioButton();
        jRadioButton2.setMargin(new Insets(1, 1, 5, 1));
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.skip.merging.for.all.project.or.module.files.merged.with.conflicts"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGetLatestVersionOnMergedWithConflict = jRadioButton = new JRadioButton();
        jRadioButton.setMargin(new Insets(1, 1, 10, 1));
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.get.latest.repository.versions.silently"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("border.title.update.options.other.settings"), (int)0, (int)0, null, null));
        this.myMakeNewFilesReadOnly = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbox.use.read.only.flag.for.not.edited.files"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowOutput = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(1, 1, 10, 1));
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbox.show.cvs.server.output"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 3, null, null, null));
        this.myDefaultTextFileKeywordSubstitution = jComboBox = new JComboBox();
        jPanel5.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.default.keyword.substitution.for.text.files"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConfigureGlobalButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("button.text.global.settings"));
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 4, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

