/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.jetbrains.python.console.pydev.AbstractPyCodeCompletion;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PydevXmlUtils {
    static SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    private PydevXmlUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SAXParser getSAXParser() throws Exception {
        SAXParser parser = null;
        SAXParserFactory sAXParserFactory = parserFactory;
        synchronized (sAXParserFactory) {
            parser = parserFactory.newSAXParser();
        }
        return parser;
    }

    @Nullable
    private static String decode(String value) {
        if (value != null) {
            try {
                return URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static List<PydevCompletionVariant> decodeCompletions(Object fromServer, String actTok) {
        ArrayList<PydevCompletionVariant> ret = new ArrayList<PydevCompletionVariant>();
        List completionList = PydevXmlUtils.objectToList(fromServer);
        for (Object o : completionList) {
            List comp = PydevXmlUtils.objectToList(o);
            int type = PydevXmlUtils.extractInt(comp.get(3));
            String args = AbstractPyCodeCompletion.getArgs((String)comp.get(2), type, 1);
            String name = (String)comp.get(0);
            if (name.contains(".") && name.startsWith(actTok)) {
                name = name.substring(actTok.length());
            }
            ret.add(new PydevCompletionVariant(name, (String)comp.get(1), args, type));
        }
        return ret;
    }

    public static List objectToList(Object object) {
        List<Object> list;
        if (object instanceof Collection) {
            list = new ArrayList((Collection)object);
        } else if (object instanceof Object[]) {
            list = Arrays.asList((Object[])object);
        } else {
            throw new IllegalStateException("cant handle type of " + object);
        }
        return list;
    }

    public static int extractInt(Object objToGetInt) {
        if (objToGetInt instanceof Integer) {
            return (Integer)objToGetInt;
        }
        return Integer.parseInt(objToGetInt.toString());
    }

    public static List<PydevCompletionVariant> xmlToCompletions(String payload, String actionToken) throws Exception {
        SAXParser parser = PydevXmlUtils.getSAXParser();
        XMLToCompletionsInfo info = new XMLToCompletionsInfo();
        parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes()), (DefaultHandler)info);
        return PydevXmlUtils.decodeCompletions(info.getCompletions(), actionToken);
    }

    static class XMLToCompletionsInfo
    extends DefaultHandler {
        private List<Object[]> completions = new ArrayList<Object[]>();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("comp")) {
                Object[] comp = new Object[]{PydevXmlUtils.decode(attributes.getValue("p0")), PydevXmlUtils.decode(attributes.getValue("p1")), PydevXmlUtils.decode(attributes.getValue("p2")), PydevXmlUtils.decode(attributes.getValue("p3"))};
                this.completions.add(comp);
            }
        }

        public List<Object[]> getCompletions() {
            return this.completions;
        }
    }
}

