/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev.transport;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.transport.BaseDebuggerReader;
import com.jetbrains.python.debugger.pydev.transport.BaseDebuggerTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientModeDebuggerTransport
extends BaseDebuggerTransport {
    private static final Logger LOG = Logger.getInstance(ClientModeDebuggerTransport.class);
    private static final int MAX_CONNECTION_TRIES = 20;
    private static final long CHECK_CONNECTION_APPROVED_DELAY = 1000L;
    private static final long SLEEP_TIME_BETWEEN_CONNECTION_TRIES = 150L;
    @NotNull
    private final String myHost;
    private final int myPort;
    @NotNull
    private volatile State myState;
    @Nullable
    private Socket mySocket;
    @Nullable
    private volatile DebuggerReader myDebuggerReader;

    public ClientModeDebuggerTransport(@NotNull RemoteDebugger debugger, @NotNull String host, int port) {
        if (debugger == null) {
            ClientModeDebuggerTransport.$$$reportNull$$$0(0);
        }
        if (host == null) {
            ClientModeDebuggerTransport.$$$reportNull$$$0(1);
        }
        super(debugger);
        this.myState = State.INIT;
        this.myHost = host;
        this.myPort = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForConnect() throws IOException {
        if (this.myState != State.INIT) {
            throw new IllegalStateException("Inappropriate state of Python debugger for connecting to Python debugger: " + (Object)((Object)this.myState) + "; " + (Object)((Object)State.INIT) + " is expected");
        }
        Object object = this.mySocketObject;
        synchronized (object) {
            if (this.mySocket != null) {
                try {
                    this.mySocket.close();
                }
                catch (IOException e) {
                    LOG.debug("Failed to close previously opened socket", (Throwable)e);
                }
                finally {
                    this.mySocket = null;
                }
            }
        }
        int i = 0;
        boolean connected = false;
        while (!connected && i < 20) {
            int attempt = ++i;
            LOG.debug(String.format("[%d] Trying to connect: #%d attempt", this.hashCode(), attempt));
            try {
                Socket clientSocket = new Socket();
                clientSocket.setSoTimeout(0);
                clientSocket.connect(new InetSocketAddress(this.myHost, this.myPort));
                Object object2 = this.mySocketObject;
                synchronized (object2) {
                    this.mySocket = clientSocket;
                    this.myState = State.CONNECTED;
                }
                try {
                    InputStream stream;
                    Object object3 = this.mySocketObject;
                    synchronized (object3) {
                        stream = this.mySocket.getInputStream();
                    }
                    this.myDebuggerReader = new DebuggerReader(this.myDebugger, stream);
                }
                catch (IOException e) {
                    LOG.debug("Failed to create debugger reader", (Throwable)e);
                    throw e;
                }
                CountDownLatch beforeHandshake = new CountDownLatch(1);
                Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    beforeHandshake.countDown();
                    try {
                        this.myDebugger.handshake();
                        this.myDebuggerReader.connectionApproved();
                        return true;
                    }
                    catch (PyDebuggerException e) {
                        LOG.debug(String.format("[%d] Handshake failed: #%d attempt", this.hashCode(), attempt));
                        return false;
                    }
                });
                try {
                    beforeHandshake.await();
                    connected = (Boolean)future.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    LOG.debug(String.format("[%d] Waiting for handshake interrupted: #%d attempt", this.hashCode(), attempt), (Throwable)e);
                    this.myDebuggerReader.close();
                    throw new IOException("Waiting for subprocess interrupted", e);
                }
                catch (ExecutionException e) {
                    LOG.debug(String.format("[%d] Execution exception occurred: #%d attempt", this.hashCode(), attempt), (Throwable)e);
                }
                catch (TimeoutException e) {
                    LOG.debug(String.format("[%d] Timeout: #%d attempt", this.hashCode(), attempt), (Throwable)e);
                    future.cancel(true);
                }
                if (connected) continue;
                this.myDebuggerReader.close();
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            catch (ConnectException e) {
                if (i >= 20) continue;
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException e1) {
                    throw new IOException(e1);
                }
            }
        }
        if (!connected) {
            this.myState = State.DISCONNECTED;
            throw new IOException("Failed to connect to debugging script");
        }
        this.myState = State.APPROVED;
        LOG.debug(String.format("[%d] Connected to Python debugger script on #%d attempt", this.hashCode(), i));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean sendMessageImpl(byte[] packed) throws IOException {
        Object object = this.mySocketObject;
        synchronized (object) {
            if (this.mySocket == null || this.mySocket.isClosed()) {
                return false;
            }
            OutputStream os = this.mySocket.getOutputStream();
            os.write(packed);
            os.flush();
            return true;
        }
    }

    @Override
    protected void onSocketException() {
        this.myDebugger.disconnect();
        if (this.myState == State.APPROVED) {
            this.myDebugger.fireCommunicationError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            DebuggerReader debuggerReader = this.myDebuggerReader;
            if (debuggerReader != null) {
                debuggerReader.stop();
            }
        }
        finally {
            Object object = this.mySocketObject;
            synchronized (object) {
                if (this.mySocket != null) {
                    try {
                        this.mySocket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.myState == State.APPROVED;
    }

    @Override
    public void disconnect() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "debugger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "host";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/debugger/pydev/transport/ClientModeDebuggerTransport";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DebuggerReader
    extends BaseDebuggerReader {
        private final AtomicBoolean myConnectionApproved;

        public DebuggerReader(@NotNull RemoteDebugger debugger, @NotNull InputStream stream) throws IOException {
            if (debugger == null) {
                DebuggerReader.$$$reportNull$$$0(0);
            }
            if (stream == null) {
                DebuggerReader.$$$reportNull$$$0(1);
            }
            super(stream, CharsetToolkit.UTF8_CHARSET, debugger);
            this.myConnectionApproved = new AtomicBoolean(false);
            this.start(((Object)((Object)this)).getClass().getName());
        }

        @Override
        protected void onExit() {
            if (this.myConnectionApproved.get()) {
                this.getDebugger().fireExitEvent();
            }
        }

        @Override
        protected void onCommunicationError() {
            if (this.myConnectionApproved.get()) {
                this.getDebugger().fireCommunicationError();
            }
        }

        public void connectionApproved() {
            this.myConnectionApproved.set(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "debugger";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/pydev/transport/ClientModeDebuggerTransport$DebuggerReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum State {
        INIT,
        CONNECTED,
        APPROVED,
        DISCONNECTED;

    }
}

