/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.action;

import com.intellij.application.options.codeStyle.arrangement.action.AbstractArrangementRuleAction;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMoveArrangementRuleAction
extends AbstractArrangementRuleAction
implements DumbAware {
    public void update(AnActionEvent e) {
        ArrangementMatchingRulesControl control = this.getRulesControl(e);
        if (control == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        ArrayList<int[]> mappings = new ArrayList<int[]>();
        this.fillMappings(control, mappings);
        for (int[] mapping : mappings) {
            if (mapping[0] == mapping[1]) continue;
            e.getPresentation().setEnabled(true);
            return;
        }
        e.getPresentation().setEnabled(false);
    }

    public void actionPerformed(AnActionEvent e) {
        ArrangementMatchingRulesControl control = this.getRulesControl(e);
        if (control == null) {
            return;
        }
        int editing = control.getEditingRow() - 1;
        control.runOperationIgnoreSelectionChange(() -> {
            Object pair;
            control.hideEditor();
            ArrayList<int[]> mappings = new ArrayList<int[]>();
            this.fillMappings(control, mappings);
            if (mappings.isEmpty()) {
                return;
            }
            Object newRowToEdit = editing;
            ArrangementMatchingRulesModel model = control.getModel();
            Iterator iterator = mappings.iterator();
            while (iterator.hasNext()) {
                Object to;
                pair = (int[])iterator.next();
                int from = pair[0];
                if (from == (to = pair[1])) continue;
                Object value = model.getElementAt(from);
                model.removeRow(from);
                model.insert((int)to, value);
                if (newRowToEdit != from) continue;
                newRowToEdit = to;
            }
            ListSelectionModel selectionModel = control.getSelectionModel();
            pair = mappings.iterator();
            while (pair.hasNext()) {
                int[] pair2 = (int[])pair.next();
                selectionModel.addSelectionInterval(pair2[1], pair2[1]);
            }
            int visibleRow = -1;
            if (newRowToEdit >= 0) {
                control.showEditor((int)newRowToEdit);
                visibleRow = newRowToEdit;
            } else if (!mappings.isEmpty()) {
                visibleRow = ((int[])mappings.get(0))[1];
            }
            if (visibleRow != -1) {
                this.scrollRowToVisible(control, visibleRow);
            }
        });
        control.repaintRows(0, control.getModel().getSize() - 1, true);
    }

    protected abstract void fillMappings(@NotNull ArrangementMatchingRulesControl var1, @NotNull List<int[]> var2);
}

