/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorSchemeImporter;
import com.intellij.application.options.colors.ImportHandler;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColorSchemeActions
extends AbstractSchemeActions<EditorColorsScheme> {
    protected ColorSchemeActions(@NotNull AbstractSchemesPanel<EditorColorsScheme, ?> schemesPanel) {
        if (schemesPanel == null) {
            ColorSchemeActions.$$$reportNull$$$0(0);
        }
        super(schemesPanel);
    }

    @Override
    protected Collection<String> getSchemeImportersNames() {
        ArrayList<String> importersNames = new ArrayList<String>();
        for (ImportHandler importHandler : (ImportHandler[])Extensions.getExtensions(ImportHandler.EP_NAME)) {
            importersNames.add(importHandler.getTitle());
        }
        importersNames.addAll(super.getSchemeImportersNames());
        return importersNames;
    }

    @Override
    protected void importScheme(@NotNull String importerName) {
        VirtualFile importSource;
        if (importerName == null) {
            ColorSchemeActions.$$$reportNull$$$0(1);
        }
        if (this.tryImportWithImportHandler(importerName)) {
            return;
        }
        SchemeImporter<EditorColorsScheme> importer = SchemeImporterEP.getImporter(importerName, EditorColorsScheme.class);
        if (importer != null && (importSource = SchemeImportUtil.selectImportSource(importer.getSourceExtensions(), this.getSchemesPanel(), null, "Choose " + importerName)) != null) {
            if ("jar".equals(importSource.getExtension())) {
                this.importFromJar(this.getSchemesPanel().getToolbar(), importer, importSource);
            } else {
                this.doImport(importer, importSource);
            }
        }
    }

    private void doImport(@NotNull SchemeImporter<EditorColorsScheme> importer, @NotNull VirtualFile importSource) {
        if (importer == null) {
            ColorSchemeActions.$$$reportNull$$$0(2);
        }
        if (importSource == null) {
            ColorSchemeActions.$$$reportNull$$$0(3);
        }
        try {
            EditorColorsScheme imported = (EditorColorsScheme)importer.importScheme(DefaultProjectFactory.getInstance().getDefaultProject(), importSource, (Scheme)this.getOptions().getSelectedScheme(), name -> {
                String newName = SchemeNameGenerator.getUniqueName(name != null ? name : "Unnamed", candidate -> this.getSchemesPanel().getModel().containsScheme((String)candidate, false));
                EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(EmptyColorScheme.INSTANCE);
                newScheme.setName(newName);
                newScheme.setDefaultMetaInfo(EmptyColorScheme.INSTANCE);
                return newScheme;
            });
            if (imported != null) {
                this.getOptions().addImportedScheme(imported);
                this.getSchemesPanel().showStatus(ApplicationBundle.message((String)"settings.editor.scheme.import.success", (Object[])new Object[]{importSource.getPresentableUrl(), imported.getName()}), MessageType.INFO);
            }
        }
        catch (SchemeImportException e) {
            this.handleError(e, importSource);
        }
    }

    private void handleError(@NotNull SchemeImportException e, @NotNull VirtualFile importSource) {
        if (e == null) {
            ColorSchemeActions.$$$reportNull$$$0(4);
        }
        if (importSource == null) {
            ColorSchemeActions.$$$reportNull$$$0(5);
        }
        String details = e.getMessage();
        this.getSchemesPanel().showStatus(ApplicationBundle.message((String)"settings.editor.scheme.import.failure", (Object[])new Object[]{importSource.getPresentableUrl()}) + (StringUtil.isEmpty((String)details) ? "" : "\n" + details), MessageType.ERROR);
    }

    private void importFromJar(@NotNull Component componentAbove, @NotNull SchemeImporter<EditorColorsScheme> importer, @NotNull VirtualFile jarFile) {
        if (componentAbove == null) {
            ColorSchemeActions.$$$reportNull$$$0(6);
        }
        if (importer == null) {
            ColorSchemeActions.$$$reportNull$$$0(7);
        }
        if (jarFile == null) {
            ColorSchemeActions.$$$reportNull$$$0(8);
        }
        try {
            List<VirtualFile> schemeFiles = ColorSchemeActions.getSchemeFiles(jarFile);
            if (schemeFiles.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
                this.doImport(importer, schemeFiles.iterator().next());
                return;
            }
            ArrayList<ColorSchemeItem> fileList = new ArrayList<ColorSchemeItem>(schemeFiles.size());
            for (VirtualFile file2 : schemeFiles) {
                Element root = SchemeImportUtil.loadSchemeDom(file2);
                String name = StringUtil.trimStart((String)ColorSchemeImporter.getSchemeName(root), (String)"_@user_");
                fileList.add(new ColorSchemeItem(name, file2));
            }
            ImportSchemeChooserDialog dialog2 = new ImportSchemeChooserDialog(this.mySchemesPanel, componentAbove, fileList);
            if (dialog2.showAndGet()) {
                List<ColorSchemeItem> selectedItems = dialog2.getSelectedItems();
                for (ColorSchemeItem item : selectedItems) {
                    this.doImport(importer, item.getFile());
                }
            }
        }
        catch (SchemeImportException e) {
            this.handleError(e, jarFile);
        }
    }

    private static List<VirtualFile> getSchemeFiles(@NotNull VirtualFile jarFile) throws SchemeImportException {
        if (jarFile == null) {
            ColorSchemeActions.$$$reportNull$$$0(9);
        }
        ArrayList<VirtualFile> schemeFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : jarFile.getChildren()) {
            if (!file2.isDirectory() || !"colors".equals(file2.getName())) continue;
            for (VirtualFile schemeFile : file2.getChildren()) {
                String ext = schemeFile.getExtension();
                if (!"icls".equals(ext) && !"xml".equals(ext)) continue;
                schemeFiles.add(schemeFile);
            }
            break;
        }
        if (schemeFiles.isEmpty()) {
            throw new SchemeImportException("The are no color schemes in the chosen file.");
        }
        return schemeFiles;
    }

    private boolean tryImportWithImportHandler(@NotNull String importerName) {
        if (importerName == null) {
            ColorSchemeActions.$$$reportNull$$$0(10);
        }
        for (ImportHandler importHandler : (ImportHandler[])Extensions.getExtensions(ImportHandler.EP_NAME)) {
            if (!importerName.equals(importHandler.getTitle())) continue;
            importHandler.performImport(this.getSchemesPanel().getToolbar(), (Consumer<EditorColorsScheme>)((Consumer)scheme2 -> {
                if (scheme2 != null) {
                    this.getOptions().addImportedScheme((EditorColorsScheme)scheme2);
                }
            }));
            return true;
        }
        return false;
    }

    @Override
    protected void resetScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            ColorSchemeActions.$$$reportNull$$$0(11);
        }
        if (Messages.showOkCancelDialog((String)ApplicationBundle.message((String)"color.scheme.reset.message", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"color.scheme.reset.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            this.getOptions().resetSchemeToOriginal(scheme2.getName());
        }
    }

    @Override
    protected void duplicateScheme(@NotNull EditorColorsScheme scheme2, @NotNull String newName) {
        if (scheme2 == null) {
            ColorSchemeActions.$$$reportNull$$$0(12);
        }
        if (newName == null) {
            ColorSchemeActions.$$$reportNull$$$0(13);
        }
        this.getOptions().saveSchemeAs(scheme2, newName);
    }

    @Override
    protected void exportScheme(@NotNull EditorColorsScheme scheme2, @NotNull String exporterName) {
        EditorColorsScheme parent;
        if (scheme2 == null) {
            ColorSchemeActions.$$$reportNull$$$0(14);
        }
        if (exporterName == null) {
            ColorSchemeActions.$$$reportNull$$$0(15);
        }
        EditorColorsScheme schemeToExport = scheme2;
        if (scheme2 instanceof AbstractColorsScheme && !((parent = ((AbstractColorsScheme)scheme2).getParentScheme()) instanceof DefaultColorsScheme)) {
            schemeToExport = parent;
        }
        schemeToExport = (EditorColorsScheme)schemeToExport.clone();
        schemeToExport.setName(SchemeManager.getDisplayName((Scheme)schemeToExport));
        super.exportScheme(schemeToExport, exporterName);
    }

    @Override
    protected Class<EditorColorsScheme> getSchemeType() {
        return EditorColorsScheme.class;
    }

    @NotNull
    protected abstract ColorAndFontOptions getOptions();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemesPanel";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importerName";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importer";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentAbove";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporterName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/colors/ColorSchemeActions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "importScheme";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doImport";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleError";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "importFromJar";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getSchemeFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "tryImportWithImportHandler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "resetScheme";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "duplicateScheme";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "exportScheme";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ColorSchemeItem {
        private String myName;
        private VirtualFile myFile;

        public ColorSchemeItem(String name, VirtualFile file2) {
            this.myName = name;
            this.myFile = file2;
        }

        public String getName() {
            return this.myName;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public String toString() {
            return this.myName;
        }
    }

    private static class ImportSchemeChooserDialog
    extends DialogWrapper {
        private Component myComponentAbove;
        private List<ColorSchemeItem> mySchemeItems;
        private JBList<ColorSchemeItem> mySchemeList;

        protected ImportSchemeChooserDialog(@NotNull Component parent, @NotNull Component componentAbove, @NotNull List<ColorSchemeItem> schemeItems) {
            if (parent == null) {
                ImportSchemeChooserDialog.$$$reportNull$$$0(0);
            }
            if (componentAbove == null) {
                ImportSchemeChooserDialog.$$$reportNull$$$0(1);
            }
            if (schemeItems == null) {
                ImportSchemeChooserDialog.$$$reportNull$$$0(2);
            }
            super(parent, false);
            this.setTitle(ApplicationBundle.message((String)"settings.editor.scheme.import.chooser.title", (Object[])new Object[0]));
            this.setOKButtonText(ApplicationBundle.message((String)"settings.editor.scheme.import.chooser.button", (Object[])new Object[0]));
            this.myComponentAbove = componentAbove;
            this.mySchemeItems = schemeItems;
            this.init();
        }

        @Nullable
        public Point getInitialLocation() {
            Point location = this.myComponentAbove.getLocationOnScreen();
            location.translate(0, this.myComponentAbove.getHeight() + JBUI.scale((int)20));
            return location;
        }

        protected void createDefaultActions() {
            super.createDefaultActions();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel schemesPanel = new JPanel(new BorderLayout());
            this.mySchemeList = new JBList(this.mySchemeItems);
            schemesPanel.add((Component)this.mySchemeList, "Center");
            return schemesPanel;
        }

        public List<ColorSchemeItem> getSelectedItems() {
            int minIndex = this.mySchemeList.getMinSelectionIndex();
            int maxIndex = this.mySchemeList.getMaxSelectionIndex();
            if (minIndex >= 0 && maxIndex >= minIndex) {
                return this.mySchemeItems.subList(minIndex, maxIndex + 1);
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentAbove";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "schemeItems";
                    break;
                }
            }
            objectArray[1] = "com/intellij/application/options/colors/ColorSchemeActions$ImportSchemeChooserDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

