/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.CodeFoldingOptionsProvider;
import com.intellij.application.options.editor.CodeFoldingOptionsProviderEP;
import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CodeFoldingConfigurable
extends CompositeConfigurable<CodeFoldingOptionsProvider>
implements EditorOptionsProvider {
    private JCheckBox myCbFolding;
    private JPanel myRootPanel;
    private JPanel myFoldingPanel;

    public CodeFoldingConfigurable() {
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return ApplicationBundle.message((String)"group.code.folding", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.code.folding";
    }

    public JComponent createComponent() {
        this.myFoldingPanel.removeAll();
        for (CodeFoldingOptionsProvider provider : this.getConfigurables()) {
            this.myFoldingPanel.add((Component)provider.createComponent(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 7, 0), 0, 0));
        }
        return this.myRootPanel;
    }

    @Override
    public boolean isModified() {
        return this.myCbFolding.isSelected() != EditorSettingsExternalizable.getInstance().isFoldingOutlineShown() || super.isModified();
    }

    @Override
    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable.getInstance().setFoldingOutlineShown(this.myCbFolding.isSelected());
        super.apply();
        ApplicationManager.getApplication().invokeLater(() -> CodeFoldingConfigurable.applyCodeFoldingSettingsChanges(), ModalityState.NON_MODAL);
    }

    public static void applyCodeFoldingSettingsChanges() {
        EditorOptionsPanel.reinitAllEditors();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            Project project = editor.getProject();
            if (project == null) continue;
            CodeFoldingManager.getInstance(project).scheduleAsyncFoldingUpdate(editor);
        }
    }

    @Override
    public void reset() {
        this.myCbFolding.setSelected(EditorSettingsExternalizable.getInstance().isFoldingOutlineShown());
        super.reset();
    }

    @Override
    @NotNull
    protected List<CodeFoldingOptionsProvider> createConfigurables() {
        List<CodeFoldingOptionsProvider> list2 = ConfigurableWrapper.createConfigurables(CodeFoldingOptionsProviderEP.EP_NAME);
        if (list2 == null) {
            CodeFoldingConfigurable.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public String getId() {
        if ("editor.preferences.folding" == null) {
            CodeFoldingConfigurable.$$$reportNull$$$0(1);
        }
        return "editor.preferences.folding";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/application/options/editor/CodeFoldingConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCbFolding = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.code.folding.outline"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.collapse.by.default"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFoldingPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

