/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionThreading;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;

public abstract class CompletionThreadingBase
implements CompletionThreading {
    protected static final ThreadLocal<Boolean> ourIsInBatchUpdate = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public static void withBatchUpdate(Runnable runnable2) {
        if (ourIsInBatchUpdate.get().booleanValue()) {
            runnable2.run();
            return;
        }
        try {
            ourIsInBatchUpdate.set(Boolean.TRUE);
            runnable2.run();
            ProgressManager.checkCanceled();
            CompletionProgressIndicator currentIndicator = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
            if (currentIndicator == null) {
                throw new ProcessCanceledException();
            }
            CompletionThreadingBase threading = currentIndicator.getCompletionThreading();
            assert (threading != null);
            threading.flushBatchResult(currentIndicator);
        }
        finally {
            ourIsInBatchUpdate.set(Boolean.FALSE);
        }
    }

    protected abstract void flushBatchResult(CompletionProgressIndicator var1);
}

