/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.NotNullList;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LineMarkersPass
extends TextEditorHighlightingPass
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.LineMarkersPass");
    private volatile List<LineMarkerInfo> myMarkers;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final TextRange myPriorityBounds;
    @NotNull
    private final TextRange myRestrictRange;

    LineMarkersPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Document document, @NotNull TextRange priorityBounds, @NotNull TextRange restrictRange) {
        if (project == null) {
            LineMarkersPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            LineMarkersPass.$$$reportNull$$$0(1);
        }
        if (document == null) {
            LineMarkersPass.$$$reportNull$$$0(2);
        }
        if (priorityBounds == null) {
            LineMarkersPass.$$$reportNull$$$0(3);
        }
        if (restrictRange == null) {
            LineMarkersPass.$$$reportNull$$$0(4);
        }
        super(project, document, false);
        this.myMarkers = Collections.emptyList();
        this.myFile = file2;
        this.myPriorityBounds = priorityBounds;
        this.myRestrictRange = restrictRange;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = super.getDocument();
        if (document == null) {
            LineMarkersPass.$$$reportNull$$$0(5);
        }
        return document;
    }

    @Override
    public void doApplyInformationToEditor() {
        try {
            LineMarkersUtil.setLineMarkersToEditor(this.myProject, this.getDocument(), (Segment)this.myRestrictRange, this.myMarkers, this.getId());
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            LineMarkersPass.$$$reportNull$$$0(6);
        }
        ArrayList<LineMarkerInfo> lineMarkers = new ArrayList<LineMarkerInfo>();
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language);
            HighlightingLevelManager highlightingLevelManager = HighlightingLevelManager.getInstance(this.myProject);
            if (!highlightingLevelManager.shouldHighlight((PsiElement)root)) continue;
            Divider.divideInsideAndOutsideInOneRoot(root, this.myRestrictRange, this.myPriorityBounds, (Processor<Divider.DividedElements>)((Processor)elements -> {
                List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(language, this.myProject);
                ArrayList<LineMarkerProvider> providersList = new ArrayList<LineMarkerProvider>(providers);
                LineMarkersPass.queryProviders(elements.inside, root, providersList, (PairConsumer<PsiElement, LineMarkerInfo>)((PairConsumer)(element, info) -> {
                    lineMarkers.add((LineMarkerInfo)info);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.isValid()) {
                            LineMarkersUtil.addLineMarkerToEditorIncrementally(this.myProject, this.getDocument(), info);
                        }
                    }, this.myProject.getDisposed());
                }));
                LineMarkersPass.queryProviders(elements.outside, root, providersList, (PairConsumer<PsiElement, LineMarkerInfo>)((PairConsumer)(element, info) -> lineMarkers.add((LineMarkerInfo)info)));
                return true;
            }));
        }
        this.myMarkers = LineMarkersPass.mergeLineMarkers(lineMarkers, this.getDocument());
        if (LOG.isDebugEnabled()) {
            LOG.debug("LineMarkersPass.doCollectInformation. lineMarkers: " + lineMarkers + "; merged: " + this.myMarkers);
        }
    }

    @NotNull
    private static List<LineMarkerInfo> mergeLineMarkers(@NotNull List<LineMarkerInfo> markers, @NotNull Document document) {
        if (markers == null) {
            LineMarkersPass.$$$reportNull$$$0(7);
        }
        if (document == null) {
            LineMarkersPass.$$$reportNull$$$0(8);
        }
        ArrayList<MergeableLineMarkerInfo> forMerge = new ArrayList<MergeableLineMarkerInfo>();
        TIntObjectHashMap sameLineMarkers = new TIntObjectHashMap();
        for (int i = markers.size() - 1; i >= 0; --i) {
            LineMarkerInfo marker = markers.get(i);
            if (!(marker instanceof MergeableLineMarkerInfo)) continue;
            MergeableLineMarkerInfo mergeable = (MergeableLineMarkerInfo)marker;
            forMerge.add(mergeable);
            markers.remove(i);
            int line = document.getLineNumber(marker.startOffset);
            ArrayList<MergeableLineMarkerInfo> infos = (ArrayList<MergeableLineMarkerInfo>)sameLineMarkers.get(line);
            if (infos == null) {
                infos = new ArrayList<MergeableLineMarkerInfo>();
                sameLineMarkers.put(line, infos);
            }
            infos.add(mergeable);
        }
        if (forMerge.isEmpty()) {
            List<LineMarkerInfo> list2 = markers;
            if (list2 == null) {
                LineMarkersPass.$$$reportNull$$$0(9);
            }
            return list2;
        }
        ArrayList<LineMarkerInfo> result2 = new ArrayList<LineMarkerInfo>(markers);
        for (Object v : sameLineMarkers.getValues()) {
            List infos = (List)v;
            result2.addAll(MergeableLineMarkerInfo.merge((List)infos));
        }
        ArrayList<LineMarkerInfo> arrayList = result2;
        if (arrayList == null) {
            LineMarkersPass.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public static List<LineMarkerProvider> getMarkerProviders(@NotNull Language language, @NotNull Project project) {
        if (language == null) {
            LineMarkersPass.$$$reportNull$$$0(11);
        }
        if (project == null) {
            LineMarkersPass.$$$reportNull$$$0(12);
        }
        List forLanguage = LineMarkerProviders.INSTANCE.allForLanguageOrAny(language);
        List providers = DumbService.getInstance((Project)project).filterByDumbAwareness((Collection)forLanguage);
        LineMarkerSettings settings = LineMarkerSettings.getSettings();
        List list2 = ContainerUtil.filter((Collection)providers, provider -> !(provider instanceof LineMarkerProviderDescriptor) || settings.isEnabled((GutterIconDescriptor)((LineMarkerProviderDescriptor)provider)));
        if (list2 == null) {
            LineMarkersPass.$$$reportNull$$$0(13);
        }
        return list2;
    }

    private static void queryProviders(@NotNull List<PsiElement> elements, @NotNull PsiFile containingFile, @NotNull List<LineMarkerProvider> providers, @NotNull PairConsumer<PsiElement, LineMarkerInfo> consumer) {
        if (elements == null) {
            LineMarkersPass.$$$reportNull$$$0(14);
        }
        if (containingFile == null) {
            LineMarkersPass.$$$reportNull$$$0(15);
        }
        if (providers == null) {
            LineMarkersPass.$$$reportNull$$$0(16);
        }
        if (consumer == null) {
            LineMarkersPass.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        THashSet visitedInjectedFiles = new THashSet();
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = elements.get(i);
            for (int j = 0; j < providers.size(); ++j) {
                LineMarkerInfo info;
                ProgressManager.checkCanceled();
                LineMarkerProvider provider = providers.get(j);
                try {
                    info = provider.getLineMarkerInfo(element);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                if (info == null) continue;
                consumer.consume((Object)element, (Object)info);
            }
            LineMarkersPass.queryLineMarkersForInjected(element, containingFile, (Set<PsiFile>)visitedInjectedFiles, consumer);
        }
        NotNullList slowLineMarkers = new NotNullList();
        for (int j = 0; j < providers.size(); ++j) {
            ProgressManager.checkCanceled();
            LineMarkerProvider provider = providers.get(j);
            try {
                provider.collectSlowLineMarkers(elements, (Collection)slowLineMarkers);
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (slowLineMarkers.isEmpty()) continue;
            for (int k = 0; k < slowLineMarkers.size(); ++k) {
                LineMarkerInfo slowInfo = (LineMarkerInfo)slowLineMarkers.get(k);
                PsiElement element = slowInfo.getElement();
                consumer.consume((Object)element, (Object)slowInfo);
            }
            slowLineMarkers.clear();
        }
    }

    private static void queryLineMarkersForInjected(@NotNull PsiElement element, @NotNull PsiFile containingFile, @NotNull Set<PsiFile> visitedInjectedFiles, @NotNull PairConsumer<PsiElement, LineMarkerInfo> consumer) {
        if (element == null) {
            LineMarkersPass.$$$reportNull$$$0(18);
        }
        if (containingFile == null) {
            LineMarkersPass.$$$reportNull$$$0(19);
        }
        if (visitedInjectedFiles == null) {
            LineMarkersPass.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            LineMarkersPass.$$$reportNull$$$0(21);
        }
        if (containingFile.getViewProvider() instanceof InjectedFileViewProvider) {
            return;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        InjectedLanguageUtil.enumerate(element, containingFile, false, (injectedPsi, places) -> {
            if (visitedInjectedFiles == null) {
                LineMarkersPass.$$$reportNull$$$0(29);
            }
            if (consumer == null) {
                LineMarkersPass.$$$reportNull$$$0(30);
            }
            if (!visitedInjectedFiles.add(injectedPsi)) {
                return;
            }
            Project project = injectedPsi.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project).getCachedDocument(injectedPsi);
            if (!(document instanceof DocumentWindow)) {
                return;
            }
            List<PsiElement> injElements = CollectHighlightsUtil.getElementsInRange((PsiElement)injectedPsi, 0, injectedPsi.getTextLength());
            List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(injectedPsi.getLanguage(), project);
            LineMarkersPass.queryProviders(injElements, injectedPsi, providers, (PairConsumer<PsiElement, LineMarkerInfo>)((PairConsumer)(injectedElement, injectedMarker) -> {
                if (consumer == null) {
                    LineMarkersPass.$$$reportNull$$$0(31);
                }
                GutterIconRenderer gutterRenderer = injectedMarker.createGutterRenderer();
                TextRange injectedRange = new TextRange(injectedMarker.startOffset, injectedMarker.endOffset);
                List editables = manager.intersectWithAllEditableFragments(injectedPsi, injectedRange);
                for (TextRange editable : editables) {
                    TextRange hostRange = manager.injectedToHost((PsiElement)injectedPsi, editable);
                    Icon icon = gutterRenderer == null ? null : gutterRenderer.getIcon();
                    GutterIconNavigationHandler navigationHandler = injectedMarker.getNavigationHandler();
                    LineMarkerInfo converted = new LineMarkerInfo(injectedElement, hostRange, icon, injectedMarker.updatePass, e -> injectedMarker.getLineMarkerTooltip(), navigationHandler, GutterIconRenderer.Alignment.RIGHT);
                    consumer.consume(injectedElement, (Object)converted);
                }
            }));
        });
    }

    @NotNull
    public static Collection<LineMarkerInfo> queryLineMarkers(@NotNull PsiFile file2, @NotNull Document document) {
        if (file2 == null) {
            LineMarkersPass.$$$reportNull$$$0(22);
        }
        if (document == null) {
            LineMarkersPass.$$$reportNull$$$0(23);
        }
        if (file2.getNode() == null) {
            List<LineMarkerInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                LineMarkersPass.$$$reportNull$$$0(24);
            }
            return list2;
        }
        LineMarkersPass pass = new LineMarkersPass(file2.getProject(), file2, document, file2.getTextRange(), file2.getTextRange());
        pass.doCollectInformation((ProgressIndicator)new EmptyProgressIndicator());
        List<LineMarkerInfo> list3 = pass.myMarkers;
        if (list3 == null) {
            LineMarkersPass.$$$reportNull$$$0(25);
        }
        return list3;
    }

    @NotNull
    public static LineMarkerInfo createMethodSeparatorLineMarker(@NotNull PsiElement startFrom, @NotNull EditorColorsManager colorsManager) {
        if (startFrom == null) {
            LineMarkersPass.$$$reportNull$$$0(26);
        }
        if (colorsManager == null) {
            LineMarkersPass.$$$reportNull$$$0(27);
        }
        LineMarkerInfo info = new LineMarkerInfo(startFrom, startFrom.getTextRange(), null, 11, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
        EditorColorsScheme scheme2 = colorsManager.getGlobalScheme();
        info.separatorColor = scheme2.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.TOP;
        LineMarkerInfo lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            LineMarkersPass.$$$reportNull$$$0(28);
        }
        return lineMarkerInfo;
    }

    @Override
    public String toString() {
        return super.toString() + "; myBounds: " + this.myPriorityBounds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 24: 
            case 25: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 24: 
            case 25: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityBounds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/LineMarkersPass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markers";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 17: 
            case 21: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedInjectedFiles";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startFrom";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LineMarkersPass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeLineMarkers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkerProviders";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "queryLineMarkers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodSeparatorLineMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 24: 
            case 25: 
            case 28: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mergeLineMarkers";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMarkerProviders";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "queryProviders";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "queryLineMarkersForInjected";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "queryLineMarkers";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createMethodSeparatorLineMarker";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$queryLineMarkersForInjected$7";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 24: 
            case 25: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

