/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareFileWithEditorAction
extends BaseShowDiffAction {
    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        VirtualFile selectedFile;
        if (e == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(0);
        }
        if ((selectedFile = CompareFileWithEditorAction.getSelectedFile(e)) == null) {
            return false;
        }
        VirtualFile currentFile = CompareFileWithEditorAction.getEditingFile(e);
        if (currentFile == null) {
            return false;
        }
        return CompareFileWithEditorAction.canCompare(selectedFile, currentFile);
    }

    @Nullable
    private static VirtualFile getSelectedFile(@NotNull AnActionEvent e) {
        VirtualFile[] array;
        if (e == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(1);
        }
        if ((array = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null || array.length != 1 || array[0].isDirectory()) {
            return null;
        }
        return array[0];
    }

    @Nullable
    private static VirtualFile getEditingFile(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        return FileEditorManagerEx.getInstanceEx(project).getCurrentFile();
    }

    private static boolean canCompare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(4);
        }
        return !file1.equals(file2) && CompareFileWithEditorAction.hasContent(file1) && CompareFileWithEditorAction.hasContent(file2);
    }

    @Override
    @Nullable
    protected DiffRequest getDiffRequest(@NotNull AnActionEvent e) {
        Editor[] editors;
        if (e == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(5);
        }
        Project project = e.getProject();
        VirtualFile selectedFile = CompareFileWithEditorAction.getSelectedFile(e);
        VirtualFile currentFile = CompareFileWithEditorAction.getEditingFile(e);
        assert (selectedFile != null && currentFile != null);
        ContentDiffRequest request = DiffRequestFactory.getInstance().createFromFiles(project, selectedFile, currentFile);
        DiffContent editorContent = (DiffContent)request.getContents().get(1);
        if (editorContent instanceof DocumentContent && (editors = EditorFactory.getInstance().getEditors(((DocumentContent)editorContent).getDocument())).length != 0) {
            request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)editors[0].getCaretModel().getLogicalPosition().line));
        }
        return request;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/actions/CompareFileWithEditorAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditingFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canCompare";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getDiffRequest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

