/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffChange {
    @NotNull
    private final SimpleDiffViewer myViewer;
    @NotNull
    private final LineFragment myFragment;
    @Nullable
    private final List<DiffFragment> myInnerFragments;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    @NotNull
    private final List<MyGutterOperation> myOperations;
    private boolean myIsValid;
    private int[] myLineStartShifts;
    private int[] myLineEndShifts;

    public SimpleDiffChange(@NotNull SimpleDiffViewer viewer, @NotNull LineFragment fragment, @Nullable LineFragment previousFragment) {
        if (viewer == null) {
            SimpleDiffChange.$$$reportNull$$$0(0);
        }
        if (fragment == null) {
            SimpleDiffChange.$$$reportNull$$$0(1);
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myOperations = new ArrayList<MyGutterOperation>();
        this.myIsValid = true;
        this.myLineStartShifts = new int[2];
        this.myLineEndShifts = new int[2];
        this.myViewer = viewer;
        this.myFragment = fragment;
        this.myInnerFragments = fragment.getInnerFragments();
        this.installHighlighter(previousFragment);
    }

    public void installHighlighter(@Nullable LineFragment previousFragment) {
        assert (this.myHighlighters.isEmpty());
        if (this.myInnerFragments != null) {
            this.doInstallHighlighterWithInner();
        } else {
            this.doInstallHighlighterSimple();
        }
        this.doInstallNonSquashedChangesSeparator(previousFragment);
        this.doInstallActionHighlighters();
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (MyGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    private void doInstallHighlighterSimple() {
        this.createHighlighter(Side.LEFT, false);
        this.createHighlighter(Side.RIGHT, false);
    }

    private void doInstallHighlighterWithInner() {
        assert (this.myInnerFragments != null);
        this.createHighlighter(Side.LEFT, true);
        this.createHighlighter(Side.RIGHT, true);
        for (DiffFragment fragment : this.myInnerFragments) {
            this.createInlineHighlighter(fragment, Side.LEFT);
            this.createInlineHighlighter(fragment, Side.RIGHT);
        }
    }

    private void doInstallNonSquashedChangesSeparator(@Nullable LineFragment previousFragment) {
        this.createNonSquashedChangesSeparator(previousFragment, Side.LEFT);
        this.createNonSquashedChangesSeparator(previousFragment, Side.RIGHT);
    }

    private void doInstallActionHighlighters() {
        this.myOperations.add(this.createOperation(Side.LEFT));
        this.myOperations.add(this.createOperation(Side.RIGHT));
    }

    private void createHighlighter(@NotNull Side side, boolean ignored) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(2);
        }
        EditorEx editor = this.myViewer.getEditor(side);
        TextDiffType type = DiffUtil.getLineDiffType(this.myFragment);
        int startLine = side.getStartLine(this.myFragment);
        int endLine = side.getEndLine(this.myFragment);
        this.myHighlighters.addAll(DiffDrawUtil.createHighlighter(editor, startLine, endLine, type, ignored));
    }

    private void createInlineHighlighter(@NotNull DiffFragment fragment, @NotNull Side side) {
        if (fragment == null) {
            SimpleDiffChange.$$$reportNull$$$0(3);
        }
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(4);
        }
        int start = side.getStartOffset(fragment);
        int end = side.getEndOffset(fragment);
        TextDiffType type = DiffUtil.getDiffType(fragment);
        int startOffset = side.getStartOffset((DiffFragment)this.myFragment);
        EditorEx editor = this.myViewer.getEditor(side);
        this.myHighlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, start += startOffset, end += startOffset, type));
    }

    private void createNonSquashedChangesSeparator(@Nullable LineFragment previousFragment, @NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(5);
        }
        if (previousFragment == null) {
            return;
        }
        int startLine = side.getStartLine(this.myFragment);
        int endLine = side.getEndLine(this.myFragment);
        int prevStartLine = side.getStartLine(previousFragment);
        int prevEndLine = side.getEndLine(previousFragment);
        if (startLine == endLine) {
            return;
        }
        if (prevStartLine == prevEndLine) {
            return;
        }
        if (prevEndLine != startLine) {
            return;
        }
        this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(this.myViewer.getEditor(side), startLine, TextDiffType.MODIFIED));
    }

    public void updateGutterActions(boolean force) {
        for (MyGutterOperation operation : this.myOperations) {
            operation.update(force);
        }
    }

    public int getStartLine(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(6);
        }
        return side.getStartLine(this.myFragment) + side.select(this.myLineStartShifts);
    }

    public int getEndLine(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(7);
        }
        return side.getEndLine(this.myFragment) + side.select(this.myLineEndShifts);
    }

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = DiffUtil.getLineDiffType(this.myFragment);
        if (textDiffType == null) {
            SimpleDiffChange.$$$reportNull$$$0(8);
        }
        return textDiffType;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(9);
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        int n = sideIndex;
        this.myLineStartShifts[n] = this.myLineStartShifts[n] + (newRange.startLine - line1);
        int n2 = sideIndex;
        this.myLineEndShifts[n2] = this.myLineEndShifts[n2] + (newRange.endLine - line2);
        if (newRange.damaged) {
            for (MyGutterOperation operation : this.myOperations) {
                operation.dispose();
            }
            this.myOperations.clear();
            this.myIsValid = false;
        }
        return newRange.damaged;
    }

    public boolean isSelectedByLine(int line, @NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(10);
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        return DiffUtil.isSelectedByLine(line, line1, line2);
    }

    @NotNull
    private MyGutterOperation createOperation(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(11);
        }
        int offset = side.getStartOffset((DiffFragment)this.myFragment);
        EditorEx editor = this.myViewer.getEditor(side);
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        MyGutterOperation myGutterOperation = new MyGutterOperation(side, highlighter);
        if (myGutterOperation == null) {
            SimpleDiffChange.$$$reportNull$$$0(12);
        }
        return myGutterOperation;
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(13);
        }
        return this.createIconRenderer(side, "Accept", DiffUtil.getArrowIcon(side), () -> {
            if (side == null) {
                SimpleDiffChange.$$$reportNull$$$0(20);
            }
            this.myViewer.replaceChange(this, side);
        });
    }

    @Nullable
    private GutterIconRenderer createAppendRenderer(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(14);
        }
        return this.createIconRenderer(side, "Append", DiffUtil.getArrowDownIcon(side), () -> {
            if (side == null) {
                SimpleDiffChange.$$$reportNull$$$0(19);
            }
            UsageTrigger.trigger("diff.SimpleDiffChange.Append");
            this.myViewer.appendChange(this, side);
        });
    }

    @Nullable
    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, @NotNull String tooltipText, @NotNull Icon icon, final @NotNull Runnable perform2) {
        if (sourceSide == null) {
            SimpleDiffChange.$$$reportNull$$$0(15);
        }
        if (tooltipText == null) {
            SimpleDiffChange.$$$reportNull$$$0(16);
        }
        if (icon == null) {
            SimpleDiffChange.$$$reportNull$$$0(17);
        }
        if (perform2 == null) {
            SimpleDiffChange.$$$reportNull$$$0(18);
        }
        if (!DiffUtil.isEditable(this.myViewer.getEditor(sourceSide.other()))) {
            return null;
        }
        return new DiffGutterRenderer(icon, tooltipText){

            @Override
            protected void performAction(AnActionEvent e) {
                if (!SimpleDiffChange.this.myIsValid) {
                    return;
                }
                Project project = e.getProject();
                DocumentEx document = SimpleDiffChange.this.myViewer.getEditor(sourceSide.other()).getDocument();
                DiffUtil.executeWriteCommand(document, project, "Replace change", perform2);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffChange";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffChange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInlineHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNonSquashedChangesSeparator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStartLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEndLine";
                break;
            }
            case 8: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processChange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedByLine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createOperation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createApplyRenderer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createAppendRenderer";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createAppendRenderer$1";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createApplyRenderer$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyGutterOperation {
        @NotNull
        private final Side mySide;
        @NotNull
        private final RangeHighlighter myHighlighter;
        private boolean myCtrlPressed;

        private MyGutterOperation(@NotNull Side side, RangeHighlighter highlighter) {
            if (side == null) {
                MyGutterOperation.$$$reportNull$$$0(0);
            }
            if (highlighter == null) {
                MyGutterOperation.$$$reportNull$$$0(1);
            }
            this.mySide = side;
            this.myHighlighter = highlighter;
            this.update(true);
        }

        public void dispose() {
            this.myHighlighter.dispose();
        }

        public void update(boolean force) {
            if (!force && !this.areModifiersChanged()) {
                return;
            }
            if (this.myHighlighter.isValid()) {
                this.myHighlighter.setGutterIconRenderer(this.createRenderer());
            }
        }

        private boolean areModifiersChanged() {
            return this.myCtrlPressed != SimpleDiffChange.this.myViewer.getModifierProvider().isCtrlPressed();
        }

        @Nullable
        public GutterIconRenderer createRenderer() {
            boolean isAppendable;
            this.myCtrlPressed = SimpleDiffChange.this.myViewer.getModifierProvider().isCtrlPressed();
            boolean isOtherEditable = DiffUtil.isEditable(SimpleDiffChange.this.myViewer.getEditor(this.mySide.other()));
            boolean bl = isAppendable = SimpleDiffChange.this.myFragment.getStartLine1() != SimpleDiffChange.this.myFragment.getEndLine1() && SimpleDiffChange.this.myFragment.getStartLine2() != SimpleDiffChange.this.myFragment.getEndLine2();
            if (isOtherEditable) {
                if (this.myCtrlPressed && isAppendable) {
                    return SimpleDiffChange.this.createAppendRenderer(this.mySide);
                }
                return SimpleDiffChange.this.createApplyRenderer(this.mySide);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "side";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "highlighter";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/simple/SimpleDiffChange$MyGutterOperation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

