/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.WorkingDirectoryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class ProgramParametersConfigurator {
    private static final ExtensionPointName<WorkingDirectoryProvider> WORKING_DIRECTORY_PROVIDER_EP_NAME = ExtensionPointName.create((String)"com.intellij.module.workingDirectoryProvider");
    public static final String MODULE_WORKING_DIR = "%MODULE_WORKING_DIR%";

    public void configureConfiguration(SimpleProgramParameters parameters, CommonProgramRunConfigurationParameters configuration) {
        Project project = configuration.getProject();
        Module module2 = this.getModule(configuration);
        parameters.getProgramParametersList().addParametersString(this.expandPath(configuration.getProgramParameters(), module2, project));
        parameters.setWorkingDirectory(this.getWorkingDir(configuration, project, module2));
        HashMap<String, String> envs = new HashMap<String, String>(configuration.getEnvs());
        EnvironmentUtil.inlineParentOccurrences(envs);
        for (Map.Entry entry : envs.entrySet()) {
            entry.setValue(this.expandPath((String)entry.getValue(), module2, project));
        }
        parameters.setEnv(envs);
        parameters.setPassParentEnvs(configuration.isPassParentEnvs());
    }

    @Nullable
    public String getWorkingDir(CommonProgramRunConfigurationParameters configuration, Project project, Module module2) {
        String workingDirectory = configuration.getWorkingDirectory();
        String defaultWorkingDir = this.getDefaultWorkingDir(project);
        if (StringUtil.isEmptyOrSpaces((String)workingDirectory) && (workingDirectory = defaultWorkingDir) == null) {
            return null;
        }
        if (!FileUtil.isAbsolute((String)(workingDirectory = this.expandPath(workingDirectory, module2, project))) && defaultWorkingDir != null) {
            String workingDir;
            if ("$MODULE_DIR$".equals(workingDirectory)) {
                return defaultWorkingDir;
            }
            if (module2 != null && MODULE_WORKING_DIR.equals(workingDirectory) && (workingDir = this.getDefaultWorkingDir(module2)) != null) {
                return workingDir;
            }
            workingDirectory = defaultWorkingDir + "/" + workingDirectory;
        }
        return workingDirectory;
    }

    @Nullable
    protected String getDefaultWorkingDir(@NotNull Project project) {
        if (project == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(0);
        }
        return PathUtil.getLocalPath((VirtualFile)project.getBaseDir());
    }

    @Nullable
    protected String getDefaultWorkingDir(@NotNull Module module2) {
        if (module2 == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(1);
        }
        for (WorkingDirectoryProvider provider : (WorkingDirectoryProvider[])WORKING_DIRECTORY_PROVIDER_EP_NAME.getExtensions()) {
            @SystemIndependent String path = provider.getWorkingDirectoryPath(module2);
            if (path == null) continue;
            return path;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (roots.length > 0) {
            return PathUtil.getLocalPath((VirtualFile)roots[0]);
        }
        return null;
    }

    public void checkWorkingDirectoryExist(CommonProgramRunConfigurationParameters configuration, Project project, Module module2) throws RuntimeConfigurationWarning {
        String workingDir = this.getWorkingDir(configuration, project, module2);
        if (workingDir == null) {
            throw new RuntimeConfigurationWarning("Working directory is null for project '" + project.getName() + "' (" + project.getBasePath() + "), module " + (module2 == null ? "null" : "'" + module2.getName() + "' (" + module2.getModuleFilePath() + ")"));
        }
        if (!new File(workingDir).exists()) {
            throw new RuntimeConfigurationWarning("Working directory '" + workingDir + "' doesn't exist");
        }
    }

    protected String expandPath(@Nullable String path, Module module2, Project project) {
        path = PathMacroManager.getInstance((ComponentManager)project).expandPath(path);
        if (module2 != null) {
            path = PathMacroManager.getInstance((ComponentManager)module2).expandPath(path);
        }
        return path;
    }

    @Nullable
    protected Module getModule(CommonProgramRunConfigurationParameters configuration) {
        if (configuration instanceof ModuleBasedConfiguration) {
            return ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/util/ProgramParametersConfigurator";
        objectArray[2] = "getDefaultWorkingDir";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

