/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.EventQueue;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="BookmarkManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class BookmarkManager
implements PersistentStateComponent<Element> {
    private static final int MAX_AUTO_DESCRIPTION_SIZE = 50;
    private static final Key<List<Bookmark>> BOOKMARKS_KEY = Key.create((String)"bookmarks");
    private final List<Bookmark> myBookmarks = new ArrayList<Bookmark>();
    private final Map<Trinity<VirtualFile, Integer, String>, Bookmark> myDeletedDocumentBookmarks = new HashMap<Trinity<VirtualFile, Integer, String>, Bookmark>();
    private final Map<Document, List<Trinity<Bookmark, Integer, String>>> myBeforeChangeData = new HashMap<Document, List<Trinity<Bookmark, Integer, String>>>();
    private final MessageBus myBus;
    private final Project myProject;
    private boolean mySortedState;

    public static BookmarkManager getInstance(Project project) {
        return (BookmarkManager)ServiceManager.getService((Project)project, BookmarkManager.class);
    }

    public BookmarkManager(Project project, PsiDocumentManager documentManager, EditorColorsManager colorsManager, EditorFactory editorFactory) {
        this.myProject = project;
        this.myBus = project.getMessageBus();
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme2) {
                BookmarkManager.this.colorsChanged();
            }
        });
        EditorEventMulticaster multicaster = editorFactory.getEventMulticaster();
        multicaster.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this.myProject);
        multicaster.addEditorMouseListener((EditorMouseListener)new MyEditorMouseListener(), (Disposable)this.myProject);
        documentManager.addListener(new PsiDocumentManager.Listener(){

            public void documentCreated(@NotNull Document document, PsiFile psiFile) {
                VirtualFile file2;
                if (document == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((file2 = FileDocumentManager.getInstance().getFile(document)) == null) {
                    return;
                }
                for (Bookmark bookmark : BookmarkManager.this.myBookmarks) {
                    if (!Comparing.equal((Object)bookmark.getFile(), (Object)file2)) continue;
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (document == null) {
                            2.$$$reportNull$$$0(3);
                        }
                        if (BookmarkManager.this.myProject.isDisposed()) {
                            return;
                        }
                        bookmark.createHighlighter((MarkupModelEx)DocumentMarkupModel.forDocument(document, BookmarkManager.this.myProject, true));
                        BookmarkManager.map(document, bookmark);
                    });
                }
            }

            public void fileCreated(@NotNull PsiFile file2, @NotNull Document document) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (document == null) {
                    2.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/bookmarks/BookmarkManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "documentCreated";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$documentCreated$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.mySortedState = UISettings.getInstance().getSortBookmarks();
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> {
            if (this.mySortedState != uiSettings.getSortBookmarks()) {
                this.mySortedState = uiSettings.getSortBookmarks();
                EventQueue.invokeLater(() -> ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarksOrderChanged());
            }
        });
    }

    private static void map(Document document, Bookmark bookmark) {
        if (document == null || bookmark == null) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<Bookmark> list2 = (ArrayList<Bookmark>)document.getUserData(BOOKMARKS_KEY);
        if (list2 == null) {
            list2 = new ArrayList<Bookmark>();
            document.putUserData(BOOKMARKS_KEY, list2);
        }
        list2.add(bookmark);
    }

    private static void unmap(Document document, Bookmark bookmark) {
        if (document == null || bookmark == null) {
            return;
        }
        List list2 = (List)document.getUserData(BOOKMARKS_KEY);
        if (list2 != null && list2.remove(bookmark) && list2.isEmpty()) {
            document.putUserData(BOOKMARKS_KEY, null);
        }
    }

    public void editDescription(@NotNull Bookmark bookmark) {
        String description;
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(0);
        }
        if ((description = Messages.showInputDialog((Project)this.myProject, (String)IdeBundle.message((String)"action.bookmark.edit.description.dialog.message", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.bookmark.edit.description.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)bookmark.getDescription(), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return true;
            }

            public boolean canClose(String inputString) {
                return true;
            }
        })) != null) {
            this.setDescription(bookmark, description);
        }
    }

    public void addEditorBookmark(@NotNull Editor editor, int lineIndex) {
        if (editor == null) {
            BookmarkManager.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        this.addTextBookmark(virtualFile, lineIndex, BookmarkManager.getAutoDescription(editor, lineIndex));
    }

    @NotNull
    public Bookmark addTextBookmark(@NotNull VirtualFile file2, int lineIndex, @NotNull String description) {
        if (file2 == null) {
            BookmarkManager.$$$reportNull$$$0(2);
        }
        if (description == null) {
            BookmarkManager.$$$reportNull$$$0(3);
        }
        Bookmark b = new Bookmark(this.myProject, file2, lineIndex, description);
        this.myBookmarks.add(0, b);
        BookmarkManager.map(b.getDocument(), b);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkAdded(b);
        Bookmark bookmark = b;
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(4);
        }
        return bookmark;
    }

    @NotNull
    public static String getAutoDescription(@NotNull Editor editor, int lineIndex) {
        String autoDescription;
        if (editor == null) {
            BookmarkManager.$$$reportNull$$$0(5);
        }
        if ((autoDescription = editor.getSelectionModel().getSelectedText()) == null) {
            Document document = editor.getDocument();
            autoDescription = document.getCharsSequence().subSequence(document.getLineStartOffset(lineIndex), document.getLineEndOffset(lineIndex)).toString().trim();
        }
        if (autoDescription.length() > 50) {
            String string = autoDescription.substring(0, 50) + "...";
            if (string == null) {
                BookmarkManager.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = autoDescription;
        if (string == null) {
            BookmarkManager.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public Bookmark addFileBookmark(@Nullable VirtualFile file2, @NotNull String description) {
        if (description == null) {
            BookmarkManager.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            return null;
        }
        if (this.findFileBookmark(file2) != null) {
            return null;
        }
        Bookmark b = new Bookmark(this.myProject, file2, -1, description);
        this.myBookmarks.add(0, b);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkAdded(b);
        return b;
    }

    @NotNull
    public List<Bookmark> getValidBookmarks() {
        ArrayList<Bookmark> answer = new ArrayList<Bookmark>();
        for (Bookmark bookmark : this.myBookmarks) {
            if (!bookmark.isValid()) continue;
            answer.add(bookmark);
        }
        if (UISettings.getInstance().getSortBookmarks()) {
            Collections.sort(answer);
        }
        ArrayList<Bookmark> arrayList = answer;
        if (arrayList == null) {
            BookmarkManager.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    public Bookmark findEditorBookmark(@NotNull Document document, int line) {
        List bookmarks;
        if (document == null) {
            BookmarkManager.$$$reportNull$$$0(10);
        }
        if ((bookmarks = (List)document.getUserData(BOOKMARKS_KEY)) != null) {
            for (Bookmark bookmark : bookmarks) {
                if (bookmark.getLine() != line) continue;
                return bookmark;
            }
        }
        return null;
    }

    @Nullable
    public Bookmark findFileBookmark(@NotNull VirtualFile file2) {
        if (file2 == null) {
            BookmarkManager.$$$reportNull$$$0(11);
        }
        for (Bookmark bookmark : this.myBookmarks) {
            if (!Comparing.equal((Object)bookmark.getFile(), (Object)file2) || bookmark.getLine() != -1) continue;
            return bookmark;
        }
        return null;
    }

    @Nullable
    public Bookmark findBookmarkForMnemonic(char m) {
        char mm = Character.toUpperCase(m);
        for (Bookmark bookmark : this.myBookmarks) {
            if (mm != bookmark.getMnemonic()) continue;
            return bookmark;
        }
        return null;
    }

    public boolean hasBookmarksWithMnemonics() {
        for (Bookmark bookmark : this.myBookmarks) {
            if (bookmark.getMnemonic() == '\u0000') continue;
            return true;
        }
        return false;
    }

    public void removeBookmark(@NotNull Bookmark bookmark) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(12);
        }
        if (this.myBookmarks.remove(bookmark)) {
            BookmarkManager.unmap(bookmark.getDocument(), bookmark);
            bookmark.release();
            ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkRemoved(bookmark);
        }
    }

    public Element getState() {
        Element container = new Element("BookmarkManager");
        this.writeExternal(container);
        return container;
    }

    public void loadState(Element state2) {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
            for (Bookmark bookmark : this.myBookmarks) {
                bookmark.release();
                BookmarkManager.unmap(bookmark.getDocument(), bookmark);
            }
            this.myBookmarks.clear();
            this.readExternal(state2);
        }));
    }

    private void readExternal(Element element) {
        for (Object o : element.getChildren()) {
            Element bookmarkElement = (Element)o;
            if (!"bookmark".equals(bookmarkElement.getName())) continue;
            String url = bookmarkElement.getAttributeValue("url");
            String line = bookmarkElement.getAttributeValue("line");
            String description = StringUtil.notNullize((String)bookmarkElement.getAttributeValue("description"));
            String mnemonic = bookmarkElement.getAttributeValue("mnemonic");
            Bookmark b = null;
            VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file2 != null) {
                if (line != null) {
                    try {
                        int lineIndex = Integer.parseInt(line);
                        b = this.addTextBookmark(file2, lineIndex, description);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    b = this.addFileBookmark(file2, description);
                }
            }
            if (b == null || mnemonic == null || mnemonic.length() != 1) continue;
            this.setMnemonic(b, mnemonic.charAt(0));
        }
    }

    private void writeExternal(Element element) {
        ArrayList<Bookmark> reversed = new ArrayList<Bookmark>(this.myBookmarks);
        Collections.reverse(reversed);
        for (Bookmark bookmark : reversed) {
            char mnemonic;
            int line;
            if (!bookmark.isValid()) continue;
            Element bookmarkElement = new Element("bookmark");
            bookmarkElement.setAttribute("url", bookmark.getFile().getUrl());
            String description = bookmark.getNotEmptyDescription();
            if (description != null) {
                bookmarkElement.setAttribute("description", description);
            }
            if ((line = bookmark.getLine()) >= 0) {
                bookmarkElement.setAttribute("line", String.valueOf(line));
            }
            if ((mnemonic = bookmark.getMnemonic()) != '\u0000') {
                bookmarkElement.setAttribute("mnemonic", String.valueOf(mnemonic));
            }
            element.addContent(bookmarkElement);
        }
    }

    @NotNull
    public List<Bookmark> moveBookmarkUp(@NotNull Bookmark bookmark) {
        int index;
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(13);
        }
        if ((index = this.myBookmarks.indexOf(bookmark)) > 0) {
            Collections.swap(this.myBookmarks, index, index - 1);
            EventQueue.invokeLater(() -> {
                ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(this.myBookmarks.get(index));
                ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(this.myBookmarks.get(index - 1));
            });
        }
        List<Bookmark> list2 = this.myBookmarks;
        if (list2 == null) {
            BookmarkManager.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    public List<Bookmark> moveBookmarkDown(@NotNull Bookmark bookmark) {
        int index;
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(15);
        }
        if ((index = this.myBookmarks.indexOf(bookmark)) < this.myBookmarks.size() - 1) {
            Collections.swap(this.myBookmarks, index, index + 1);
            EventQueue.invokeLater(() -> {
                ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(this.myBookmarks.get(index));
                ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(this.myBookmarks.get(index + 1));
            });
        }
        List<Bookmark> list2 = this.myBookmarks;
        if (list2 == null) {
            BookmarkManager.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @Nullable
    public Bookmark findLineBookmark(@NotNull Editor editor, boolean isWrapped, boolean next) {
        List bookmarksForDocument;
        if (editor == null) {
            BookmarkManager.$$$reportNull$$$0(17);
        }
        if ((bookmarksForDocument = (List)editor.getDocument().getUserData(BOOKMARKS_KEY)) == null) {
            return null;
        }
        int sign = next ? 1 : -1;
        Collections.sort(bookmarksForDocument, (o1, o2) -> sign * (o1.getLine() - o2.getLine()));
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        for (Bookmark bookmark : bookmarksForDocument) {
            if (next && bookmark.getLine() > caretLine) {
                return bookmark;
            }
            if (next || bookmark.getLine() >= caretLine) continue;
            return bookmark;
        }
        return isWrapped && !bookmarksForDocument.isEmpty() ? (Bookmark)bookmarksForDocument.get(0) : null;
    }

    public void setMnemonic(@NotNull Bookmark bookmark, char c) {
        Bookmark old;
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(18);
        }
        if ((old = this.findBookmarkForMnemonic(c)) != null) {
            this.removeBookmark(old);
        }
        bookmark.setMnemonic(c);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(bookmark);
    }

    public void setDescription(@NotNull Bookmark bookmark, String description) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(19);
        }
        bookmark.setDescription(description);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(bookmark);
    }

    public void colorsChanged() {
        for (Bookmark bookmark : this.myBookmarks) {
            bookmark.updateHighlighter();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bookmark";
                break;
            }
            case 1: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/bookmarks/BookmarkManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/bookmarks/BookmarkManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addTextBookmark";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidBookmarks";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "moveBookmarkUp";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "moveBookmarkDown";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "editDescription";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addEditorBookmark";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTextBookmark";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAutoDescription";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFileBookmark";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findEditorBookmark";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFileBookmark";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeBookmark";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveBookmarkUp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "moveBookmarkDown";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findLineBookmark";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setMnemonic";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void beforeDocumentChange(DocumentEvent e) {
            for (Bookmark bookmark : BookmarkManager.this.myBookmarks) {
                Document doc = bookmark.getDocument();
                if (doc == null || doc != e.getDocument() || bookmark.getLine() == -1) continue;
                ArrayList<Trinity> list2 = (ArrayList<Trinity>)BookmarkManager.this.myBeforeChangeData.get(doc);
                if (list2 == null) {
                    list2 = new ArrayList<Trinity>();
                    BookmarkManager.this.myBeforeChangeData.put(doc, list2);
                }
                list2.add(new Trinity((Object)bookmark, (Object)bookmark.getLine(), (Object)doc.getText(new TextRange(doc.getLineStartOffset(bookmark.getLine()), doc.getLineEndOffset(bookmark.getLine())))));
            }
        }

        private boolean isDuplicate(Bookmark bookmark, @Nullable List<Bookmark> toRemove2) {
            for (Bookmark b : BookmarkManager.this.myBookmarks) {
                if (b == bookmark || !b.isValid() || !Comparing.equal((Object)b.getFile(), (Object)bookmark.getFile()) || b.getLine() != bookmark.getLine() || toRemove2 != null && toRemove2.contains(b)) continue;
                return true;
            }
            return false;
        }

        private void moveToDeleted(Bookmark bookmark) {
            List list2 = (List)BookmarkManager.this.myBeforeChangeData.get(bookmark.getDocument());
            if (list2 != null) {
                for (Trinity trinity : list2) {
                    if (trinity.first != bookmark) continue;
                    BookmarkManager.this.removeBookmark(bookmark);
                    BookmarkManager.this.myDeletedDocumentBookmarks.put(new Trinity((Object)bookmark.getFile(), trinity.second, trinity.third), bookmark);
                    break;
                }
            }
        }

        public void documentChanged(DocumentEvent e) {
            ArrayList<Bookmark> bookmarksToRemove = null;
            for (Bookmark bookmark : BookmarkManager.this.myBookmarks) {
                if (bookmark.isValid() && !this.isDuplicate(bookmark, (List<Bookmark>)bookmarksToRemove)) continue;
                if (bookmarksToRemove == null) {
                    bookmarksToRemove = new ArrayList<Bookmark>();
                }
                bookmarksToRemove.add(bookmark);
            }
            if (bookmarksToRemove != null) {
                for (Bookmark bookmark : bookmarksToRemove) {
                    if (bookmark.getDocument() == e.getDocument()) {
                        this.moveToDeleted(bookmark);
                        continue;
                    }
                    BookmarkManager.this.removeBookmark(bookmark);
                }
            }
            BookmarkManager.this.myBeforeChangeData.remove(e.getDocument());
            Iterator iterator = BookmarkManager.this.myDeletedDocumentBookmarks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((VirtualFile)((Trinity)entry.getKey()).first).isValid()) {
                    iterator.remove();
                    continue;
                }
                Bookmark bookmark = (Bookmark)entry.getValue();
                Document document = bookmark.getDocument();
                if (document == null || !bookmark.getFile().equals(((Trinity)entry.getKey()).first)) continue;
                Integer line = (Integer)((Trinity)entry.getKey()).second;
                if (document.getLineCount() <= line) continue;
                String bookmarkedText = (String)((Trinity)entry.getKey()).third;
                String lineContent = this.getLineContent(document, line);
                if (!bookmarkedText.equals(lineContent) && line > 1 && (bookmarkedText.equals(StringUtil.trimEnd((String)e.getNewFragment().toString(), (String)"\n")) || bookmarkedText.equals(StringUtil.trimEnd((String)e.getOldFragment().toString(), (String)"\n")))) {
                    line = line - 2;
                    lineContent = this.getLineContent(document, line);
                }
                if (!bookmarkedText.equals(lineContent) || BookmarkManager.this.findEditorBookmark(document, line) != null) continue;
                Bookmark restored = BookmarkManager.this.addTextBookmark(bookmark.getFile(), line, bookmark.getDescription());
                if (bookmark.getMnemonic() != '\u0000') {
                    BookmarkManager.this.setMnemonic(restored, bookmark.getMnemonic());
                }
                iterator.remove();
            }
        }

        private String getLineContent(Document document, int line) {
            int start = document.getLineStartOffset(line);
            int end = document.getLineEndOffset(line);
            return document.getText(new TextRange(start, end));
        }
    }

    private class MyEditorMouseListener
    extends EditorMouseAdapter {
        private MyEditorMouseListener() {
        }

        public void mouseClicked(EditorMouseEvent e) {
            if (e.getArea() != EditorMouseEventArea.LINE_MARKERS_AREA) {
                return;
            }
            if (e.getMouseEvent().isPopupTrigger()) {
                return;
            }
            if ((e.getMouseEvent().getModifiers() & (SystemInfo.isMac ? 4 : 2)) == 0) {
                return;
            }
            Editor editor = e.getEditor();
            int line = editor.xyToLogicalPosition((Point)new Point((int)e.getMouseEvent().getX(), (int)e.getMouseEvent().getY())).line;
            if (line < 0) {
                return;
            }
            Document document = editor.getDocument();
            Bookmark bookmark = BookmarkManager.this.findEditorBookmark(document, line);
            if (bookmark == null) {
                BookmarkManager.this.addEditorBookmark(editor, line);
            } else {
                BookmarkManager.this.removeBookmark(bookmark);
            }
            e.consume();
        }
    }
}

