/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinuxDragAndDropSupport {
    public static final DataFlavor uriListFlavor = FileCopyPasteUtil.createDataFlavor("text/uri-list", String.class);
    public static final DataFlavor gnomeFileListFlavor = FileCopyPasteUtil.createDataFlavor("x-special/gnome-copied-files", null, true);
    public static final DataFlavor kdeCutMarkFlavor = FileCopyPasteUtil.createDataFlavor("application/x-kde-cutselection", null, true);

    private LinuxDragAndDropSupport() {
    }

    @Nullable
    public static List<File> getFiles(@NotNull Transferable transferable) throws IOException, UnsupportedFlavorException {
        if (transferable == null) {
            LinuxDragAndDropSupport.$$$reportNull$$$0(0);
        }
        if (transferable.isDataFlavorSupported(uriListFlavor)) {
            Object transferData = transferable.getTransferData(uriListFlavor);
            return LinuxDragAndDropSupport.getFiles(transferData.toString());
        }
        if (transferable.isDataFlavorSupported(gnomeFileListFlavor)) {
            Object transferData = transferable.getTransferData(gnomeFileListFlavor);
            String content = FileUtil.loadTextAndClose((InputStream)((InputStream)transferData));
            return LinuxDragAndDropSupport.getFiles(content);
        }
        return null;
    }

    @NotNull
    private static List<File> getFiles(@Nullable String transferData) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (transferData != null) {
            String[] uriList;
            for (String uriString : uriList = StringUtil.convertLineSeparators((String)transferData).split("\n")) {
                if (StringUtil.isEmptyOrSpaces((String)uriString) || uriString.startsWith("#") || !uriString.startsWith("file:/")) continue;
                try {
                    URI uri = new URI(uriString);
                    fileList.add(new File(uri));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        ArrayList<File> arrayList = fileList;
        if (arrayList == null) {
            LinuxDragAndDropSupport.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static String toUriList(@NotNull List<File> files) {
        if (files == null) {
            LinuxDragAndDropSupport.$$$reportNull$$$0(2);
        }
        String string = StringUtil.join(files, file2 -> file2.toURI().toString(), (String)"\n");
        if (string == null) {
            LinuxDragAndDropSupport.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean isMoveOperation(@NotNull Transferable transferable) {
        if (transferable == null) {
            LinuxDragAndDropSupport.$$$reportNull$$$0(4);
        }
        if (transferable.isDataFlavorSupported(gnomeFileListFlavor)) {
            try {
                Object transferData = transferable.getTransferData(gnomeFileListFlavor);
                String content = FileUtil.loadTextAndClose((InputStream)((InputStream)transferData));
                return content.startsWith("cut\n");
            }
            catch (Exception exception) {}
        } else if (transferable.isDataFlavorSupported(kdeCutMarkFlavor)) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferable";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/dnd/LinuxDragAndDropSupport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/dnd/LinuxDragAndDropSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toUriList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toUriList";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMoveOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

