/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.ColorBlindnessSupport;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class ColorBlindnessPanel
extends JPanel
implements ChangeListener {
    private final JCheckBox myCheckBox = new JCheckBox();
    private final JComboBox myComboBox = new ComboBox();
    private ColorBlindness myBlindness;

    public ColorBlindnessPanel() {
        super((LayoutManager)new HorizontalLayout(JBUI.scale((int)10)));
        this.add("LEFT", this.myCheckBox);
        this.add("LEFT", this.myComboBox);
        SwingActionLink label = new SwingActionLink((Action)new AbstractAction(UIBundle.message((String)"color.blindness.link.to.help", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent event) {
                HelpManager.getInstance().invokeHelp("Colorblind_Settings");
            }
        });
        this.add("LEFT", (Component)label);
        this.myCheckBox.setSelected(false);
        this.myCheckBox.addChangeListener(this);
        int count = 0;
        for (ColorBlindness blindness : ColorBlindness.values()) {
            ColorBlindnessSupport support = ColorBlindnessSupport.get((ColorBlindness)blindness);
            if (support == null) continue;
            this.myComboBox.addItem(new Item(blindness));
            ++count;
        }
        this.myComboBox.setEnabled(false);
        this.myComboBox.setVisible(count > 1);
        this.myCheckBox.setText(UIBundle.message((String)(count > 1 ? "color.blindness.combobox.text" : "color.blindness.checkbox.text"), (Object[])new Object[0]));
        this.setVisible(count > 0);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.myComboBox.setEnabled(this.myCheckBox.isSelected());
    }

    public ColorBlindness getColorBlindness() {
        if (this.myCheckBox.isSelected()) {
            if (this.myBlindness != null) {
                return this.myBlindness;
            }
            Object object = this.myComboBox.getSelectedItem();
            if (object instanceof Item) {
                Item item = (Item)object;
                return item.myBlindness;
            }
        }
        return null;
    }

    public void setColorBlindness(ColorBlindness blindness) {
        this.myBlindness = this.myComboBox.isVisible() ? null : blindness;
        Item item = null;
        if (this.myBlindness == null && blindness != null) {
            int count = this.myComboBox.getItemCount();
            for (int i = 0; i < count && item == null; ++i) {
                Object object = this.myComboBox.getItemAt(i);
                if (!(object instanceof Item) || (item = (Item)object).myBlindness == blindness) continue;
                item = null;
            }
        }
        this.myCheckBox.setSelected(this.myBlindness != null || item != null);
        if (item != null) {
            this.myComboBox.setSelectedItem(item);
        }
    }

    private static final class Item {
        private final ColorBlindness myBlindness;
        private final String myName;

        private Item(ColorBlindness blindness) {
            this.myBlindness = blindness;
            this.myName = UIBundle.message((String)blindness.key, (Object[])new Object[0]);
        }

        public String toString() {
            return this.myName;
        }
    }
}

