/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.CustomMatcherModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SynchronizedCollectConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultChooseByNameItemProvider
implements ChooseByNameItemProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ChooseByNameIdea");
    private final SmartPsiElementPointer myContext;

    public DefaultChooseByNameItemProvider(@Nullable PsiElement context) {
        this.myContext = context == null ? null : SmartPointerManager.getInstance((Project)context.getProject()).createSmartPsiElementPointer(context);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        long started;
        boolean preferStartMatches;
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(3);
        }
        if (base.myProject != null) {
            base.myProject.putUserData(ChooseByNamePopup.CURRENT_SEARCH_PATTERN, (Object)pattern);
        }
        String namePattern = DefaultChooseByNameItemProvider.getNamePattern(base, pattern);
        String qualifierPattern = DefaultChooseByNameItemProvider.getQualifierPattern(base, pattern);
        boolean bl = preferStartMatches = !pattern.startsWith("*");
        if (DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), namePattern).isEmpty() && !base.canShowListForEmptyPattern()) {
            return true;
        }
        final ChooseByNameModel model = base.getModel();
        String matchingPattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern);
        if (matchingPattern == null) {
            return true;
        }
        ArrayList namesList = new ArrayList();
        SynchronizedCollectConsumer collect = new SynchronizedCollectConsumer(namesList);
        if (model instanceof ChooseByNameModelEx) {
            indicator.checkCanceled();
            started = System.currentTimeMillis();
            MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(matchingPattern, NameUtil.MatchingCaseSensitivity.NONE);
            ((ChooseByNameModelEx)model).processNames((Processor<String>)((Processor)arg_0 -> DefaultChooseByNameItemProvider.lambda$filterElements$0(indicator, base, pattern, matcher, (CollectConsumer)collect, arg_0)), everywhere);
            if (LOG.isDebugEnabled()) {
                LOG.debug("loaded + matched:" + (System.currentTimeMillis() - started) + "," + collect.getResult().size());
            }
        } else {
            String[] names = base.getNames(everywhere);
            started = System.currentTimeMillis();
            DefaultChooseByNameItemProvider.processNamesByPattern(base, names, matchingPattern, indicator, (Consumer<MatchResult>)collect);
            if (LOG.isDebugEnabled()) {
                LOG.debug("matched:" + (System.currentTimeMillis() - started) + "," + names.length);
            }
        }
        indicator.checkCanceled();
        started = System.currentTimeMillis();
        List results = (List)collect.getResult();
        DefaultChooseByNameItemProvider.sortNamesList(namePattern, results, preferStartMatches);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorted:" + (System.currentTimeMillis() - started) + ",results:" + results.size());
        }
        indicator.checkCanceled();
        SmartList sameNameElements = new SmartList();
        THashMap qualifierMatchResults = ContainerUtil.newIdentityTroveMap();
        Comparator<Object> weightComparator = new Comparator<Object>((Map)qualifierMatchResults, preferStartMatches){
            Comparator<Object> modelComparator;
            final /* synthetic */ Map val$qualifierMatchResults;
            final /* synthetic */ boolean val$preferStartMatches;
            {
                this.val$qualifierMatchResults = map2;
                this.val$preferStartMatches = bl;
                this.modelComparator = model instanceof Comparator ? (Comparator)model : DefaultChooseByNameItemProvider.this.getPathProximityComparator();
            }

            @Override
            public int compare(Object o1, Object o2) {
                int result2 = this.modelComparator.compare(o1, o2);
                return result2 != 0 ? result2 : ((MatchResult)this.val$qualifierMatchResults.get(o1)).compareWith((MatchResult)this.val$qualifierMatchResults.get(o2), this.val$preferStartMatches);
            }
        };
        ArrayList qualifierMiddleMatched = new ArrayList();
        List<Pair<String, MinusculeMatcher>> patternsAndMatchers = DefaultChooseByNameItemProvider.getPatternsAndMatchers(qualifierPattern, base);
        IdFilter idFilter = null;
        if (model instanceof ContributorsBasedGotoByModel) {
            idFilter = ((ContributorsBasedGotoByModel)model).getIdFilter(everywhere);
        }
        GlobalSearchScope searchScope = FindSymbolParameters.searchScopeFor(base.myProject, everywhere);
        FindSymbolParameters parameters = new FindSymbolParameters(pattern, namePattern, searchScope, idFilter);
        for (MatchResult result2 : namesList) {
            Object[] elements;
            indicator.checkCanceled();
            String name = result2.elementName;
            Object[] objectArray = elements = model instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model).getElementsByName(name, parameters, indicator) : model.getElementsByName(name, everywhere, namePattern);
            if (elements.length > 1) {
                sameNameElements.clear();
                qualifierMatchResults.clear();
                for (Object element : elements) {
                    indicator.checkCanceled();
                    MatchResult qualifierResult = DefaultChooseByNameItemProvider.matchQualifier(element, base, patternsAndMatchers);
                    if (qualifierResult == null) continue;
                    sameNameElements.add(element);
                    qualifierMatchResults.put(element, qualifierResult);
                }
                Collections.sort(sameNameElements, weightComparator);
                for (Object element : sameNameElements) {
                    if (!((MatchResult)qualifierMatchResults.get(element)).startMatch) {
                        qualifierMiddleMatched.add(element);
                        continue;
                    }
                    if (consumer.process(element)) continue;
                    return false;
                }
                continue;
            }
            if (elements.length != 1 || DefaultChooseByNameItemProvider.matchQualifier(elements[0], base, patternsAndMatchers) == null || consumer.process(elements[0])) continue;
            return false;
        }
        return ContainerUtil.process(qualifierMiddleMatched, consumer);
    }

    @NotNull
    protected PathProximityComparator getPathProximityComparator() {
        PathProximityComparator pathProximityComparator = new PathProximityComparator(this.myContext == null ? null : this.myContext.getElement());
        if (pathProximityComparator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(4);
        }
        return pathProximityComparator;
    }

    private static void sortNamesList(@NotNull String namePattern, @NotNull List<MatchResult> namesList, boolean preferStartMatches) {
        if (namePattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(5);
        }
        if (namesList == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(6);
        }
        Collections.sort(namesList, (mr1, mr2) -> {
            boolean exactPrefix2;
            boolean exactPrefix1;
            if (namePattern == null) {
                DefaultChooseByNameItemProvider.$$$reportNull$$$0(48);
            }
            if ((exactPrefix1 = namePattern.equalsIgnoreCase(mr1.elementName)) != (exactPrefix2 = namePattern.equalsIgnoreCase(mr2.elementName))) {
                return exactPrefix1 ? -1 : 1;
            }
            return mr1.compareWith((MatchResult)mr2, preferStartMatches);
        });
    }

    @NotNull
    private static String getQualifierPattern(@NotNull ChooseByNameBase base, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(7);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(8);
        }
        pattern = base.transformPattern(pattern);
        String[] separators = base.getModel().getSeparators();
        int lastSeparatorOccurrence = 0;
        for (String separator : separators) {
            int idx = pattern.lastIndexOf(separator);
            if (idx == pattern.length() - 1) {
                idx = pattern.lastIndexOf(separator, idx - 1);
            }
            lastSeparatorOccurrence = Math.max(lastSeparatorOccurrence, idx);
        }
        String string = pattern.substring(0, lastSeparatorOccurrence);
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String getNamePattern(@NotNull ChooseByNameBase base, String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(10);
        }
        String transformedPattern = base.transformPattern(pattern);
        String string = DefaultChooseByNameItemProvider.getNamePattern(base.getModel(), transformedPattern);
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static String getNamePattern(ChooseByNameModel model, String pattern) {
        String[] separators = model.getSeparators();
        int lastSeparatorOccurrence = 0;
        for (String separator : separators) {
            int idx = pattern.lastIndexOf(separator);
            if (idx == pattern.length() - 1) {
                idx = pattern.lastIndexOf(separator, idx - 1);
            }
            lastSeparatorOccurrence = Math.max(lastSeparatorOccurrence, idx == -1 ? idx : idx + separator.length());
        }
        return pattern.substring(lastSeparatorOccurrence);
    }

    @NotNull
    private static List<String> split(@NotNull String s, @NotNull ChooseByNameBase base) {
        if (s == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(12);
        }
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(13);
        }
        ArrayList<String> answer = new ArrayList<String>();
        for (String token : StringUtil.tokenize((String)s, (String)StringUtil.join((String[])base.getModel().getSeparators(), (String)""))) {
            if (token.isEmpty()) continue;
            answer.add(token);
        }
        List<String> list2 = answer.isEmpty() ? Collections.singletonList(s) : answer;
        if (list2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(14);
        }
        return list2;
    }

    private static MatchResult matchQualifier(@NotNull Object element, @NotNull ChooseByNameBase base, @NotNull List<Pair<String, MinusculeMatcher>> patternsAndMatchers) {
        String name;
        if (element == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(15);
        }
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(16);
        }
        if (patternsAndMatchers == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(17);
        }
        if ((name = base.getModel().getFullName(element)) == null) {
            return null;
        }
        List<String> suspects = DefaultChooseByNameItemProvider.split(name, base);
        int matchingDegree = 0;
        int matchPosition = 0;
        boolean startMatch = true;
        block0: for (Pair<String, MinusculeMatcher> patternAndMatcher : patternsAndMatchers) {
            String pattern = (String)patternAndMatcher.first;
            MinusculeMatcher matcher = (MinusculeMatcher)patternAndMatcher.second;
            if (pattern.isEmpty()) continue;
            for (int j = matchPosition; j < suspects.size() - 1; ++j) {
                String suspect = suspects.get(j);
                MatchResult suspectMatch = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, suspect);
                if (suspectMatch != null) {
                    matchingDegree += suspectMatch.matchingDegree;
                    startMatch &= suspectMatch.startMatch;
                    matchPosition = j + 1;
                    continue block0;
                }
                matchingDegree -= (j + 1) * (j + 1);
            }
            return null;
        }
        for (int j = matchPosition; j < suspects.size() - 1; ++j) {
            matchingDegree -= (j + 1) * (j + 1);
        }
        return new MatchResult(name, matchingDegree, startMatch);
    }

    @NotNull
    private static List<Pair<String, MinusculeMatcher>> getPatternsAndMatchers(@NotNull String qualifierPattern, @NotNull ChooseByNameBase base) {
        if (qualifierPattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(18);
        }
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(19);
        }
        List list2 = ContainerUtil.map2List(DefaultChooseByNameItemProvider.split(qualifierPattern, base), s -> {
            if (base == null) {
                DefaultChooseByNameItemProvider.$$$reportNull$$$0(47);
            }
            String namePattern = DefaultChooseByNameItemProvider.addSearchAnywherePatternDecorationIfNeeded(base, DefaultChooseByNameItemProvider.getNamePattern(base, s));
            return Pair.create((Object)namePattern, (Object)DefaultChooseByNameItemProvider.buildPatternMatcher(namePattern, NameUtil.MatchingCaseSensitivity.NONE));
        });
        if (list2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(20);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, @NotNull String[] names, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(21);
        }
        if (names == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(22);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(23);
        }
        if ((pattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, pattern)) == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 != null) return list2;
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(24);
            return list2;
        }
        ArrayList<String> filtered = new ArrayList<String>();
        DefaultChooseByNameItemProvider.processNamesByPattern(base, names, pattern, ProgressIndicatorProvider.getGlobalProgressIndicator(), (Consumer<MatchResult>)((Consumer)result2 -> {
            List list2 = filtered;
            synchronized (list2) {
                filtered.add(result2.elementName);
            }
        }));
        ArrayList<String> arrayList2 = filtered;
        // MONITORENTER : arrayList2
        ArrayList<String> arrayList = filtered;
        // MONITOREXIT : arrayList2
        if (arrayList != null) return arrayList;
        DefaultChooseByNameItemProvider.$$$reportNull$$$0(25);
        return arrayList;
    }

    private static void processNamesByPattern(@NotNull ChooseByNameBase base, @NotNull String[] names, @NotNull String pattern, ProgressIndicator indicator, @NotNull Consumer<MatchResult> consumer) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(26);
        }
        if (names == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(27);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(28);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(29);
        }
        MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(pattern, NameUtil.MatchingCaseSensitivity.NONE);
        Processor processor2 = name -> {
            if (base == null) {
                DefaultChooseByNameItemProvider.$$$reportNull$$$0(44);
            }
            if (pattern == null) {
                DefaultChooseByNameItemProvider.$$$reportNull$$$0(45);
            }
            if (consumer == null) {
                DefaultChooseByNameItemProvider.$$$reportNull$$$0(46);
            }
            ProgressManager.checkCanceled();
            MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, name);
            if (result2 != null) {
                consumer.consume((Object)result2);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(names), indicator, false, true, processor2)) {
            throw new ProcessCanceledException();
        }
    }

    @Nullable
    private static String convertToMatchingPattern(@NotNull ChooseByNameBase base, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(30);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(31);
        }
        pattern = DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern);
        if (!base.canShowListForEmptyPattern() && pattern.isEmpty()) {
            return null;
        }
        return DefaultChooseByNameItemProvider.addSearchAnywherePatternDecorationIfNeeded(base, pattern);
    }

    @NotNull
    private static String addSearchAnywherePatternDecorationIfNeeded(@NotNull ChooseByNameBase base, @NotNull String pattern) {
        String trimmedPattern;
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(32);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(33);
        }
        if (base.isSearchInAnyPlace() && !(trimmedPattern = pattern.trim()).isEmpty() && trimmedPattern.length() > 1) {
            pattern = "*" + pattern;
        }
        String string = pattern;
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static String removeModelSpecificMarkup(@NotNull ChooseByNameModel model, @NotNull String pattern) {
        if (model == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(35);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(36);
        }
        if (model instanceof ContributorsBasedGotoByModel) {
            pattern = ((ContributorsBasedGotoByModel)model).removeModelSpecificMarkup(pattern);
        }
        String string = pattern;
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(37);
        }
        return string;
    }

    @Nullable
    protected static MatchResult matches(@NotNull ChooseByNameBase base, @NotNull String pattern, @NotNull MinusculeMatcher matcher, @Nullable String name) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(38);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(39);
        }
        if (matcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(40);
        }
        if (name == null) {
            return null;
        }
        if (base.getModel() instanceof CustomMatcherModel) {
            try {
                return ((CustomMatcherModel)base.getModel()).matches(name, pattern) ? new MatchResult(name, 0, true) : null;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        FList fragments = matcher.matchingFragments(name);
        return fragments != null ? new MatchResult(name, matcher.matchingDegree(name, false, fragments), MinusculeMatcher.isStartMatch((Iterable)fragments)) : null;
    }

    @NotNull
    private static MinusculeMatcher buildPatternMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity caseSensitivity) {
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(41);
        }
        if (caseSensitivity == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(42);
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)pattern, (NameUtil.MatchingCaseSensitivity)caseSensitivity);
        if (minusculeMatcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(43);
        }
        return minusculeMatcher;
    }

    private static /* synthetic */ boolean lambda$filterElements$0(@NotNull ProgressIndicator indicator, @NotNull ChooseByNameBase base, @NotNull String pattern, MinusculeMatcher matcher, CollectConsumer collect, String sequence) {
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(49);
        }
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(50);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(51);
        }
        indicator.checkCanceled();
        MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, sequence);
        if (result2 != null) {
            collect.consume((Object)result2);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 20: 
            case 24: 
            case 25: 
            case 34: 
            case 37: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 20: 
            case 24: 
            case 25: 
            case 34: 
            case 37: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 8: 
            case 23: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 41: 
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 29: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 20: 
            case 24: 
            case 25: 
            case 34: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider";
                break;
            }
            case 5: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePattern";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternsAndMatchers";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierPattern";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseSensitivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathProximityComparator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierPattern";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamePattern";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternsAndMatchers";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNames";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "addSearchAnywherePatternDecorationIfNeeded";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModelSpecificMarkup";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatternMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 20: 
            case 24: 
            case 25: 
            case 34: 
            case 37: 
            case 43: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sortNamesList";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierPattern";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNamePattern";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "matchQualifier";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPatternsAndMatchers";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "filterNames";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processNamesByPattern";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "convertToMatchingPattern";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addSearchAnywherePatternDecorationIfNeeded";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeModelSpecificMarkup";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "buildPatternMatcher";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processNamesByPattern$4";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPatternsAndMatchers$2";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sortNamesList$1";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterElements$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 20: 
            case 24: 
            case 25: 
            case 34: 
            case 37: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class PathProximityComparator
    implements Comparator<Object> {
        @NotNull
        private final PsiProximityComparator myProximityComparator;

        private PathProximityComparator(@Nullable PsiElement context) {
            this.myProximityComparator = new PsiProximityComparator(context);
        }

        private static boolean isCompiledWithoutSource(Object o) {
            return o instanceof PsiCompiledElement && ((PsiCompiledElement)o).getNavigationElement() == o;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int rc = this.myProximityComparator.compare(o1, o2);
            if (rc != 0) {
                return rc;
            }
            int o1Weight = PathProximityComparator.isCompiledWithoutSource(o1) ? 1 : 0;
            int o2Weight = PathProximityComparator.isCompiledWithoutSource(o2) ? 1 : 0;
            return o1Weight - o2Weight;
        }
    }
}

